/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StaticSessionListener
implements HttpSessionListener {
    private static final Logger LOG = LoggerFactory.getLogger(StaticSessionListener.class);
    private static final List<HttpSessionListener> LISTENERS = Collections.synchronizedList(new ArrayList());

    public void sessionCreated(HttpSessionEvent event) {
        for (HttpSessionListener l : LISTENERS) {
            l.sessionCreated(event);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        LOG.debug("Session zerst\u00f6rt" + event.toString());
        for (HttpSessionListener l : LISTENERS) {
            l.sessionDestroyed(event);
        }
    }

    public static void addSessionListener(HttpSessionListener sessionListener) {
        LISTENERS.add(sessionListener);
    }
}

