/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.presentation.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.client.event.ColorSelectEvent;
import com.freiheit.toro.common.presentation.client.event.ColorSelectHandler;
import com.freiheit.toro.common.presentation.client.event.HasColorSelectHandlers;
import com.freiheit.toro.common.presentation.ui.ColorPickerWidget;
import com.freiheit.toro.common.shared.model.Color;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;

public class ColorPickerDialog
extends JCDialogBox
implements HasColorSelectHandlers {
    public ColorPickerDialog(Color color) {
        super(false, true);
        this.initGUI(color);
    }

    private void initGUI(Color color) {
        ClickHandler closeListener = event -> this.hide();
        ClickHandler submitListener = event -> {
            String colorHex = DOM.getElementById((String)"colorPickerPlugHex").getPropertyString("value");
            ColorSelectEvent.fire((HasColorSelectHandlers)this, (Color)new Color(colorHex));
            this.hide();
        };
        this.setText(I18nMediator.BASIC.pickColor());
        this.setContent((IsWidget)new ColorPickerWidget(color));
        this.addButton(new JCButton(I18nMediator.BASIC.pick(), submitListener));
        JCButton cancelButton = new JCButton(I18nMediator.BASIC.abbrechen(), closeListener);
        cancelButton.setType(ButtonType.LINK);
        this.addButton(cancelButton);
    }

    public HandlerRegistration addColorSelectHandler(ColorSelectHandler handler) {
        return this.addHandler((EventHandler)handler, ColorSelectEvent.getType());
    }
}

