/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.config.kafka;

import de.justsoftware.searchltr.tracking.TrackingMessage;
import de.justsoftware.searchltr.tracking.TrackingMessageDeserializer;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\bj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001`\u0007H\u0012\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/searchltr/config/kafka/KafkaConfiguration;", "", "bootstrapServers", "", "<init>", "(Ljava/lang/String;)V", "defaultConsumerConfig", "Lkotlin/collections/HashMap;", "Ljava/util/HashMap;", "()Ljava/util/HashMap;", "trackingMessageListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "Lde/justsoftware/searchltr/tracking/TrackingMessage;", "search-ltr"})
public class KafkaConfiguration {
    @NotNull
    private String bootstrapServers;

    public KafkaConfiguration(@Value(value="${kafka.bootstrapServers:}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    private HashMap<String, Object> defaultConsumerConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        ((Map)config).put("bootstrap.servers", this.bootstrapServers);
        ((Map)config).put("enable.auto.commit", "false");
        ((Map)config).put("auto.offset.reset", "earliest");
        ((Map)config).put("key.deserializer", ErrorHandlingDeserializer.class);
        ((Map)config).put("value.deserializer", ErrorHandlingDeserializer.class);
        ((Map)config).put("max.poll.records", 100);
        return config;
    }

    @Bean
    @Nullable
    public ConcurrentKafkaListenerContainerFactory<String, TrackingMessage> trackingMessageListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory containerFactory = new ConcurrentKafkaListenerContainerFactory();
        HashMap consumerConfig = this.defaultConsumerConfig();
        ((Map)consumerConfig).put("group.id", "just.search.ltr.trackingConsumer");
        ((Map)consumerConfig).put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        ((Map)consumerConfig).put("spring.deserializer.value.delegate.class", TrackingMessageDeserializer.class);
        containerFactory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory((Map)consumerConfig));
        containerFactory.setBatchListener(Boolean.valueOf(true));
        return containerFactory;
    }
}

