/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.settings.service;

import de.justsoftware.mobile.gateway.news.model.NewsConfig;
import de.justsoftware.mobile.gateway.news.service.NewsApiGatewayService;
import de.justsoftware.mobile.gateway.settings.model.PlatformInfo;
import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.model.User;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsInfo;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsSettings;
import de.justsoftware.mobile.gateway.toro.model.ApiMobileAppsUser;
import de.justsoftware.mobile.gateway.toro.service.ToroApiGatewayService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@RefreshScope
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0012J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "", "newsApiGatewayService", "Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;", "toroApiGatewayService", "Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;", "<init>", "(Lde/justsoftware/mobile/gateway/news/service/NewsApiGatewayService;Lde/justsoftware/mobile/gateway/toro/service/ToroApiGatewayService;)V", "getPlatformSettings", "Lde/justsoftware/mobile/gateway/settings/model/PlatformSettings;", "getUser", "Lde/justsoftware/mobile/gateway/settings/model/User;", "getPlatformInfo", "Lde/justsoftware/mobile/gateway/settings/model/PlatformInfo;", "apiMobileAppsSettings", "Lde/justsoftware/mobile/gateway/toro/model/ApiMobileAppsSettings;", "newsConfig", "Lde/justsoftware/mobile/gateway/news/model/NewsConfig;", "mobileAppsSettings", "mobileAppsInfo", "Lde/justsoftware/mobile/gateway/toro/model/ApiMobileAppsInfo;", "mobile-gateway"})
public class SettingsService {
    @NotNull
    private final NewsApiGatewayService newsApiGatewayService;
    @NotNull
    private final ToroApiGatewayService toroApiGatewayService;

    public SettingsService(@NotNull NewsApiGatewayService newsApiGatewayService, @NotNull ToroApiGatewayService toroApiGatewayService) {
        Intrinsics.checkNotNullParameter((Object)newsApiGatewayService, (String)"newsApiGatewayService");
        Intrinsics.checkNotNullParameter((Object)toroApiGatewayService, (String)"toroApiGatewayService");
        this.newsApiGatewayService = newsApiGatewayService;
        this.toroApiGatewayService = toroApiGatewayService;
    }

    @NotNull
    public PlatformSettings getPlatformSettings() {
        ApiMobileAppsSettings apiMobileAppsSettings = this.toroApiGatewayService.getMobileAppsInfo().getSettings();
        return this.getPlatformSettings(apiMobileAppsSettings);
    }

    @NotNull
    public User getUser() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return this.getUser(mobileAppsInfo);
    }

    @NotNull
    public PlatformInfo getPlatformInfo() {
        ApiMobileAppsInfo mobileAppsInfo = this.toroApiGatewayService.getMobileAppsInfo();
        return new PlatformInfo(this.getUser(mobileAppsInfo), this.getPlatformSettings(mobileAppsInfo.getSettings()));
    }

    private PlatformSettings getPlatformSettings(ApiMobileAppsSettings apiMobileAppsSettings) {
        return (PlatformSettings)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private PlatformSettings getPlatformSettings(NewsConfig newsConfig, ApiMobileAppsSettings mobileAppsSettings) {
        boolean bl = mobileAppsSettings.getAbsenceEnabled();
        int n = mobileAppsSettings.getAbsenceNoteMaxLength();
        boolean bl2 = mobileAppsSettings.getBirthdayListEnabled();
        boolean bl3 = mobileAppsSettings.getTrackingEnabled();
        int n2 = newsConfig.getCommentMaxLength();
        boolean bl4 = newsConfig.getCommentsDisabledDefault();
        boolean bl5 = mobileAppsSettings.getChatEnabled();
        boolean bl6 = mobileAppsSettings.getNewsEnabled();
        boolean bl7 = mobileAppsSettings.getDeviceLockRequired();
        boolean bl8 = mobileAppsSettings.getCookieBannerEnabled();
        boolean bl9 = mobileAppsSettings.getChangeEmailEnabled();
        boolean bl10 = mobileAppsSettings.getChangePasswordEnabled();
        boolean bl11 = mobileAppsSettings.getDeleteAccountEnabled();
        String string = mobileAppsSettings.getPlatformVersion();
        String string2 = mobileAppsSettings.getTermsPath();
        return new PlatformSettings(bl5, bl6, bl7, bl8, bl9, bl10, bl11, string, string2, bl, n, bl2, bl3, n2, bl4, false, 32768, null);
    }

    private User getUser(ApiMobileAppsInfo mobileAppsInfo) {
        ApiMobileAppsUser mobileAppsUser = mobileAppsInfo.getUser();
        return new User(mobileAppsUser.getProfileId(), mobileAppsUser.getName(), mobileAppsUser.getFirstName(), mobileAppsUser.getLastName(), mobileAppsUser.getEmail(), mobileAppsUser.getImageId(), mobileAppsUser.getBirthday(), mobileAppsUser.getTermsAcceptanceRequired(), mobileAppsUser.getPreferredTranslationLanguage());
    }

    public static final /* synthetic */ NewsApiGatewayService access$getNewsApiGatewayService$p(SettingsService $this) {
        return $this.newsApiGatewayService;
    }

    public static final /* synthetic */ PlatformSettings access$getPlatformSettings(SettingsService $this, NewsConfig newsConfig, ApiMobileAppsSettings mobileAppsSettings) {
        return $this.getPlatformSettings(newsConfig, mobileAppsSettings);
    }
}

