/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceInformationData;
import de.justsoftware.mobile.gateway.people.model.remote.ApiAbsenceInformation;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiBirthdayList;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiBirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfileSearchResults;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiProfiles;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiSearchType;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroup;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroupDetails;
import de.justsoftware.mobile.gateway.people.model.remote.PeopleApiUserGroups;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$disableBirthdayReminderForProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$enableBirthdayReminderForProfile$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getAbsenceForProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getProfiles$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$getUserGroup$;
import de.justsoftware.mobile.gateway.people.service.PeopleApiGatewayService$updateAbsenceInformation$;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0003H\u0016J(\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\"\u0010&\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\"\u0010'\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u0010(\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0003H\u0012J \u0010)\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J \u0010*\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0012J\u0010\u0010,\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0003H\u0012J\"\u0010-\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService;", "", "peopleApiUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "absenceForProfilesUri", "Ljava/net/URI;", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiProfile;", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiUserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/remote/PeopleApiBirthdayProfile;", "currentDate", "getAbsenceForProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/remote/ApiAbsenceInformation;", "profileIds", "", "updateAbsenceInformation", "profileId", "updateAbsenceInformationData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceInformationData;", "enableBirthdayReminderForProfile", "", "disableBirthdayReminderForProfile", "suggestProfiles", "profilesUri", "userGroupsUri", "userGroupDetailsUri", "userGroupMembersUri", "birthdayProfileUri", "absenceForProfileUri", "updateBirthdayReminderForProfileUri", "suggestProfilesUri", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nPeopleApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,191:1\n48#2:192\n48#2:193\n48#2:194\n48#2:195\n48#2:196\n57#2:197\n57#2:198\n54#2:199\n85#2:200\n48#2:201\n*S KotlinDebug\n*F\n+ 1 PeopleApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/PeopleApiGatewayService\n*L\n37#1:192\n52#1:193\n63#1:194\n72#1:195\n87#1:196\n97#1:197\n106#1:198\n112#1:199\n115#1:200\n118#1:201\n*E\n"})
public class PeopleApiGatewayService {
    @NotNull
    private final String peopleApiUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private final URI absenceForProfilesUri;

    public PeopleApiGatewayService(@Value(value="${just.people.api.url}") @NotNull String peopleApiUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)peopleApiUrl, (String)"peopleApiUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.peopleApiUrl = peopleApiUrl;
        this.webClient = webClient;
        this.absenceForProfilesUri = UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/absence"), null, null, (int)6, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getProfiles(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.profilesUri(query, offset, limit);
        boolean $i$f$get = false;
        return PeopleApiProfile.Companion.toApiProfiles((PeopleApiProfileSearchResults)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getProfiles$$inlined$get$1((WebClient)$this$get$iv, (URI)uri$iv, null)), (int)1, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiUserGroup> getUserGroups(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupsUri(query, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroups)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PeopleApiUserGroup getUserGroup(@NotNull String groupId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.userGroupDetailsUri(groupId);
        boolean $i$f$get = false;
        return ((PeopleApiUserGroupDetails)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getUserGroup$$inlined$get$1((WebClient)$this$get$iv, uri$iv, null)), (int)1, null)).getUserGroup();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> getUserGroupMembers(@NotNull String groupId, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        WebClient webClient = this.webClient;
        URI uRI = this.userGroupMembersUri(groupId, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiBirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        WebClient webClient = this.webClient;
        URI uRI = this.birthdayProfileUri(currentDate, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiBirthdayList)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, ApiAbsenceInformation> getAbsenceForProfiles(@NotNull Set<String> profileIds) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        WebClient webClient = this.webClient;
        URI uri$iv = this.absenceForProfilesUri;
        boolean $i$f$post = false;
        return (Map)BuildersKt.runBlocking$default(null, (Function2)((Function2)new getAbsenceForProfiles$$inlined$post$1((WebClient)$this$post$iv, uri$iv, profileIds, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ApiAbsenceInformation updateAbsenceInformation(@NotNull String profileId, @NotNull UpdateAbsenceInformationData updateAbsenceInformationData) {
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceInformationData, (String)"updateAbsenceInformationData");
        WebClient webClient = this.webClient;
        URI uRI = this.absenceForProfileUri(profileId);
        boolean $i$f$post = false;
        return (ApiAbsenceInformation)BuildersKt.runBlocking$default(null, (Function2)((Function2)new updateAbsenceInformation$$inlined$post$1((WebClient)$this$post$iv, (URI)uri$iv, (Object)updateAbsenceInformationData, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void enableBirthdayReminderForProfile(@NotNull String profileId) {
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.updateBirthdayReminderForProfileUri(profileId);
        boolean $i$f$post = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new enableBirthdayReminderForProfile$$inlined$post$1((WebClient)$this$post$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void disableBirthdayReminderForProfile(@NotNull String profileId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.updateBirthdayReminderForProfileUri(profileId);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new disableBirthdayReminderForProfile$$inlined$delete$1((WebClient)$this$delete$iv, uri$iv, null)), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<PeopleApiProfile> suggestProfiles(@Nullable String query, int offset, int limit) {
        void uri$iv;
        void $this$get$iv;
        WebClient webClient = this.webClient;
        URI uRI = this.suggestProfilesUri(query, offset, limit);
        boolean $i$f$get = false;
        return ((PeopleApiProfiles)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null)).getRows();
    }

    private URI profilesUri(String query, int offset, int limit) {
        Map map;
        Map $this$profilesUri_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$profilesUri_u24lambda_u240.put("offset", offset);
        $this$profilesUri_u24lambda_u240.put("limit", limit);
        if (query != null) {
            $this$profilesUri_u24lambda_u240.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles"), (Map)params, null, (int)4, null);
    }

    private URI userGroupsUri(String query, int offset, int limit) {
        Map map;
        Map $this$userGroupsUri_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$userGroupsUri_u24lambda_u241.put("offset", offset);
        $this$userGroupsUri_u24lambda_u241.put("limit", limit);
        if (query != null) {
            $this$userGroupsUri_u24lambda_u241.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups"), (Map)params, null, (int)4, null);
    }

    private URI userGroupDetailsUri(String groupId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups/" + groupId), null, null, (int)6, null);
    }

    private URI userGroupMembersUri(String groupId, int offset, int limit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"limit", (Object)limit)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/usergroups/" + groupId + "/members"), (Map)params, null, (int)4, null);
    }

    private URI birthdayProfileUri(String currentDate, int offset, int limit) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"currentDate", (Object)currentDate), TuplesKt.to((Object)"offset", (Object)offset), TuplesKt.to((Object)"limit", (Object)limit)};
        Map params = MapsKt.mapOf((Pair[])pairArray);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/birthdayList"), (Map)params, null, (int)4, null);
    }

    private URI absenceForProfileUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/" + profileId + "/absence"), null, null, (int)6, null);
    }

    private URI updateBirthdayReminderForProfileUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/profiles/birthdayList/reminder/" + profileId), null, null, (int)6, null);
    }

    private URI suggestProfilesUri(String query, int offset, int limit) {
        Map map;
        Map $this$suggestProfilesUri_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$suggestProfilesUri_u24lambda_u242.put("offset", offset);
        $this$suggestProfilesUri_u24lambda_u242.put("limit", limit);
        $this$suggestProfilesUri_u24lambda_u242.put("type", PeopleApiSearchType.PROFILE);
        if (query != null) {
            $this$suggestProfilesUri_u24lambda_u242.put("query", query);
        }
        Map params = MapsKt.build((Map)map);
        return UrisKt.buildUri$default((String)(this.peopleApiUrl + "/search/names"), (Map)params, null, (int)4, null);
    }
}

