/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.people.model.local.AbsenceInformation;
import de.justsoftware.mobile.gateway.people.model.local.BirthdayProfile;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileConfiguration;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UpdateAbsenceInformationData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateBirthdayData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileDetailsData;
import de.justsoftware.mobile.gateway.people.model.local.UpdateProfileSectionData;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.service.PeopleService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/people"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J$\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0017J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0017J.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0017J\u0012\u0010\u0018\u001a\u00020\u00172\b\b\u0001\u0010\u0019\u001a\u00020\tH\u0017J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u0019\u001a\u00020\t2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0017J$\u0010\u001b\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u001a\u0010\u001e\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u00102\b\b\u0001\u0010\b\u001a\u00020\tH\u0017J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u00102\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010%\u001a\u00020\tH\u0017J\u0012\u0010&\u001a\u00020'2\b\b\u0001\u0010\b\u001a\u00020\tH\u0017J$\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020*0)2\u000e\b\u0001\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0,H\u0017J\u001c\u0010-\u001a\u00020*2\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010.\u001a\u00020/H\u0017J$\u00100\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u00101\u001a\u0002022\u0006\u0010\n\u001a\u00020\u000bH\u0017J&\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00102\u0006\u00105\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0017J\u0012\u00106\u001a\u0002072\b\b\u0001\u00108\u001a\u00020\tH\u0017J\u0012\u00109\u001a\u0002072\b\b\u0001\u00108\u001a\u00020\tH\u0017J,\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0001\u0010\u0012\u001a\u00020\t2\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0014H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lde/justsoftware/mobile/gateway/people/controller/PeopleController;", "", "peopleService", "Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "<init>", "(Lde/justsoftware/mobile/gateway/people/service/PeopleService;)V", "getProfileDetails", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "userId", "", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "updateProfileDetails", "updateProfileDetailsData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileDetailsData;", "getProfiles", "", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "offset", "", "limit", "getUserGroups", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "getUserGroup", "groupId", "getUserGroupMembers", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "updateAttribute", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "updateAttributeData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateProfileSectionData;", "getAttributes", "deleteAttributes", "sectionKey", "getConfiguration", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileConfiguration;", "getAbsenceInformation", "", "Lde/justsoftware/mobile/gateway/people/model/local/AbsenceInformation;", "userIds", "", "updateAbsenceInformation", "updateAbsenceInformationData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateAbsenceInformationData;", "updateProfileBirthday", "updateBirthdayData", "Lde/justsoftware/mobile/gateway/people/model/local/UpdateBirthdayData;", "getBirthdayProfiles", "Lde/justsoftware/mobile/gateway/people/model/local/BirthdayProfile;", "currentDate", "enableBirthdayReminderForProfile", "", "profileId", "disableBirthdayReminderForProfile", "suggestProfiles", "mobile-gateway"})
public class PeopleController {
    @NotNull
    private final PeopleService peopleService;

    public PeopleController(@NotNull PeopleService peopleService) {
        Intrinsics.checkNotNullParameter((Object)peopleService, (String)"peopleService");
        this.peopleService = peopleService;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ProfileDetails getProfileDetails(@PathVariable(value="id") @NotNull String userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfileDetails(userId, authContext.getProfileId());
    }

    @PutMapping(value={"/{id}"})
    @NotNull
    public ProfileDetails updateProfileDetails(@PathVariable(value="id") @NotNull String userId, @RequestBody @NotNull UpdateProfileDetailsData updateProfileDetailsData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateProfileDetailsData, (String)"updateProfileDetailsData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateProfileDetails(userId, updateProfileDetailsData, authContext.getProfileId());
    }

    @GetMapping
    @NotNull
    public List<Profile> getProfiles(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        return this.peopleService.getProfiles(query, offset, limit);
    }

    @GetMapping(value={"/groups"})
    @NotNull
    public List<UserGroup> getUserGroups(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        return this.peopleService.getUserGroups(query, offset, limit);
    }

    @GetMapping(value={"/groups/{id}"})
    @NotNull
    public UserGroup getUserGroup(@PathVariable(value="id") @NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroup(groupId);
    }

    @GetMapping(value={"/groups/{id}/members"})
    @NotNull
    public List<Profile> getUserGroupMembers(@PathVariable(value="id") @NotNull String groupId, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroupMembers(groupId, offset, limit);
    }

    @PostMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails updateUserImage(@PathVariable(value="id") @NotNull String userId, @RequestPart(value="image") @NotNull MultipartFile image, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateUserImage(userId, image, authContext.getProfileId());
    }

    @DeleteMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails deleteUserImage(@PathVariable(value="id") @NotNull String userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.deleteUserImage(userId, authContext.getProfileId());
    }

    @PutMapping(value={"/{id}/attribute"})
    @NotNull
    public List<ProfileSection> updateAttribute(@PathVariable(value="id") @NotNull String userId, @RequestBody @NotNull UpdateProfileSectionData updateAttributeData) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateAttributeData, (String)"updateAttributeData");
        return this.peopleService.updateAttribute(userId, updateAttributeData);
    }

    @GetMapping(value={"/{id}/attributes"})
    @NotNull
    public List<ProfileSection> getAttributes(@PathVariable(value="id") @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.peopleService.getAttributes(userId);
    }

    @DeleteMapping(value={"/{id}/attributes/{sectionKey}"})
    @NotNull
    public List<ProfileSection> deleteAttributes(@PathVariable(value="id") @NotNull String userId, @PathVariable(value="sectionKey") @NotNull String sectionKey) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)sectionKey, (String)"sectionKey");
        return this.peopleService.deleteAttributes(userId, sectionKey);
    }

    @GetMapping(value={"/{id}/configuration"})
    @NotNull
    public ProfileConfiguration getConfiguration(@PathVariable(value="id") @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.peopleService.getConfiguration(userId);
    }

    @PostMapping(value={"/absence"})
    @NotNull
    public Map<String, AbsenceInformation> getAbsenceInformation(@RequestBody @NotNull Set<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return this.peopleService.getAbsenceInformation(userIds);
    }

    @PutMapping(value={"/{id}/absence"})
    @NotNull
    public AbsenceInformation updateAbsenceInformation(@PathVariable(value="id") @NotNull String userId, @RequestBody @NotNull UpdateAbsenceInformationData updateAbsenceInformationData) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateAbsenceInformationData, (String)"updateAbsenceInformationData");
        return this.peopleService.updateAbsenceInformation(userId, updateAbsenceInformationData);
    }

    @PutMapping(value={"/{id}/birthday"})
    @NotNull
    public ProfileDetails updateProfileBirthday(@PathVariable(value="id") @NotNull String userId, @RequestBody @NotNull UpdateBirthdayData updateBirthdayData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)updateBirthdayData, (String)"updateBirthdayData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateBirthday(userId, updateBirthdayData, authContext.getProfileId());
    }

    @GetMapping(value={"/birthdayProfiles"})
    @NotNull
    public List<BirthdayProfile> getBirthdayProfiles(@NotNull String currentDate, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        return this.peopleService.getBirthdayProfiles(currentDate, offset, limit);
    }

    @PostMapping(value={"/birthdayProfiles/{profileId}/enableReminder"})
    public void enableBirthdayReminderForProfile(@PathVariable @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.peopleService.enableBirthdayReminderForProfile(profileId);
    }

    @PostMapping(value={"/birthdayProfiles/{profileId}/disableReminder"})
    public void disableBirthdayReminderForProfile(@PathVariable @NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.peopleService.disableBirthdayReminderForProfile(profileId);
    }

    @GetMapping(value={"/suggest"})
    @NotNull
    public List<Profile> suggestProfiles(@RequestParam(name="query") @NotNull String query, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="15") int limit) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.peopleService.suggestProfiles(query, offset, limit);
    }
}

