/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Configuration(value="mobileGatewayConfiguration")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0012J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0012\u00a8\u0006\r"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/ApiGatewayConfiguration;", "", "<init>", "()V", "apiWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "maxInMemorySize", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "authFilter", "Lorg/springframework/web/reactive/function/client/ExchangeFilterFunction;", "acceptLanguage", "mobile-gateway"})
public class ApiGatewayConfiguration {
    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    @NotNull
    public WebClient apiWebClient(@Value(value="${spring.codec.max-in-memory-size}") int maxInMemorySize, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        WebClient webClient = WebClient.builder().exchangeStrategies(ExchangeStrategies.builder().codecs(arg_0 -> ApiGatewayConfiguration.apiWebClient$lambda$0(maxInMemorySize, arg_0)).build()).filter(this.authFilter(request)).filter(this.acceptLanguage(request)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    private ExchangeFilterFunction authFilter(HttpServletRequest request) {
        return (arg_0, arg_1) -> ApiGatewayConfiguration.authFilter$lambda$1(request, arg_0, arg_1);
    }

    private ExchangeFilterFunction acceptLanguage(HttpServletRequest request) {
        return (arg_0, arg_1) -> ApiGatewayConfiguration.acceptLanguage$lambda$2(request, arg_0, arg_1);
    }

    private static final void apiWebClient$lambda$0(int $maxInMemorySize, ClientCodecConfigurer it) {
        it.defaultCodecs().maxInMemorySize($maxInMemorySize);
    }

    private static final Mono authFilter$lambda$1(HttpServletRequest $request, ClientRequest apiGatewayRequest, ExchangeFunction next) {
        Intrinsics.checkNotNullParameter((Object)apiGatewayRequest, (String)"apiGatewayRequest");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        String[] stringArray = new String[]{$request.getHeader("Authorization")};
        ClientRequest.Builder builder = ClientRequest.from((ClientRequest)apiGatewayRequest).header("Authorization", stringArray);
        stringArray = new String[]{$request.getHeader("just-token")};
        return next.exchange(builder.header("just-token", stringArray).build());
    }

    private static final Mono acceptLanguage$lambda$2(HttpServletRequest $request, ClientRequest apiGatewayRequest, ExchangeFunction next) {
        Intrinsics.checkNotNullParameter((Object)apiGatewayRequest, (String)"apiGatewayRequest");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        String[] stringArray = new String[]{$request.getHeader("Accept-Language")};
        return next.exchange(ClientRequest.from((ClientRequest)apiGatewayRequest).header("Accept-Language", stringArray).build());
    }
}

