/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.UserResource;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ResourceUtils {
    public static void validateUserResource(UserResource user) throws PreconditionFailedException {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        String firstName = null;
        String lastName = null;
        String email = user.getUserName();
        Name name = user.getName();
        if (name != null) {
            firstName = name.getGivenName();
            lastName = name.getFamilyName();
        }
        if (email == null) {
            missingAttributes.add("userName");
        }
        if (name == null) {
            missingAttributes.add("name");
        }
        if (firstName == null) {
            missingAttributes.add("givenName");
        }
        if (lastName == null) {
            missingAttributes.add("familyName");
        }
        if (user.getExternalId() == null) {
            missingAttributes.add("externalId");
        }
        if (missingAttributes.isEmpty()) {
            return;
        }
        String errorMsg = "Missing attributes: " + String.join((CharSequence)", ", missingAttributes);
        throw new PreconditionFailedException(errorMsg);
    }
}

