/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.transaction;

import de.justsoftware.drive.persistence.common.FlushMapper;
import de.justsoftware.drive.persistence.transaction.TransactionCallback;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionOperations;

@Service
@ParametersAreNonnullByDefault
public class TransactionSupportImpl
implements TransactionSupport {
    private final TransactionOperations _transactionOperations;
    private final FlushMapper _flushMapper;

    @Autowired
    public TransactionSupportImpl(TransactionOperations transactionOperations, FlushMapper flushMapper) {
        this._transactionOperations = transactionOperations;
        this._flushMapper = flushMapper;
    }

    public <T> T doInTransaction(TransactionCallback<T> callback) {
        Object callbackResult = this._transactionOperations.execute(status -> callback.doInTransaction());
        if (callbackResult == null) {
            throw new IllegalArgumentException("TransactionCallback didn't provide a required return value.");
        }
        return (T)callbackResult;
    }

    public void doInTransaction(Runnable action) {
        this._transactionOperations.execute(status -> {
            action.run();
            return null;
        });
    }

    public void flushBatchStatements() {
        this._flushMapper.flush();
    }
}

