/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.event.DocumentMetadataChangedEvent;
import de.justsoftware.drive.business.event.DocumentsChangedEvent;
import de.justsoftware.drive.business.event.DocumentsMovedEvent;
import de.justsoftware.drive.business.event.FilesCreatedEvent;
import de.justsoftware.drive.business.event.FilesDeletedEvent;
import de.justsoftware.drive.business.event.FilesRenamedEvent;
import de.justsoftware.drive.business.event.FoldersCreatedEvent;
import de.justsoftware.drive.business.event.FoldersDeletedEvent;
import de.justsoftware.drive.business.event.FoldersRenamedEvent;
import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.business.event.ItemsPurgeEvent;
import de.justsoftware.drive.business.event.NewFileVersionUploadedEvent;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class SolrIndexQueueProducer {
    private final DocumentSupportDAO _documentSupportDAO;
    private final DocumentService _documentService;
    private final SharesService _sharesService;
    private final SolrIndexQueue _solrIndexQueue;

    @Autowired
    public SolrIndexQueueProducer(DocumentSupportDAO documentSupportDAO, DocumentService documentService, EventBus eventBus, SharesService sharesService, SolrIndexQueue solrIndexQueue) {
        this._documentSupportDAO = documentSupportDAO;
        this._documentService = documentService;
        this._sharesService = sharesService;
        this._solrIndexQueue = solrIndexQueue;
        eventBus.register((Object)this);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFilesCreated(FilesCreatedEvent e) {
        this.handle((DocumentsChangedEvent)e, true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFoldersCreated(FoldersCreatedEvent e) {
        this.handle((DocumentsChangedEvent)e, true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFilesRenamed(FilesRenamedEvent e) {
        this.handle((DocumentsChangedEvent)e, false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFoldersRenamed(FoldersRenamedEvent e) {
        this.handle((DocumentsChangedEvent)e, false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFilesDeleted(FilesDeletedEvent e) {
        this.handle((DocumentsChangedEvent)e, true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onFoldersDeleted(FoldersDeletedEvent e) {
        this.handleRecursive((DocumentsChangedEvent)e, true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMetadataChanged(DocumentMetadataChangedEvent e) {
        this.handle((Set)e.getDocumentIds(), false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onItemVisibilitiesChanged(ItemVisibilitiesChangedEvent e) {
        this.addToSolrIndexQueue((Set)this._sharesService.getRootFolderIds((Set)e.getItems()).values().stream().collect(ImmutableSet.toImmutableSet()), true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewFileVersionUploaded(NewFileVersionUploadedEvent e) {
        this.handle((DocumentsChangedEvent)e, true);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDocumentsMoved(DocumentsMovedEvent e) {
        this.handleRecursive((DocumentsChangedEvent)e, false);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onItemPurged(ItemsPurgeEvent event) {
        this.addToSolrIndexQueue((Set)event.getRootFolderIds().values().stream().collect(ImmutableSet.toImmutableSet()), true);
    }

    private void handle(Set<DocumentId> documents, boolean fullIndex) {
        this.addToSolrIndexQueue(documents, fullIndex);
    }

    private void handle(DocumentsChangedEvent e, boolean fullIndex) {
        this.addToSolrIndexQueue((Set)e.getDocumentVersions().keySet(), fullIndex);
    }

    private void handleRecursive(DocumentsChangedEvent e, boolean fullIndex) {
        this.handle((Set)Sets.union((Set)e.getDocumentVersions().keySet(), (Set)this.getAllChildren(e)), fullIndex);
    }

    @Nonnull
    private ImmutableSet<DocumentId> getAllChildren(DocumentsChangedEvent e) {
        ImmutableMap documentVersions = e.getDocumentVersions();
        ImmutableSetMultimap children = this._documentSupportDAO.getFolderContentsRecursive((Set)ImmutableSet.copyOf((Collection)documentVersions.values()));
        ImmutableMap documentIdsOfChildren = this._documentService.getDocumentIdsOfVersions((Set)children.inverse().keySet());
        return ImmutableSet.copyOf((Collection)documentIdsOfChildren.values());
    }

    private void addToSolrIndexQueue(Set<DocumentId> documents, boolean fullIndex) {
        if (fullIndex) {
            this._solrIndexQueue.queueFullIndex(SolrIndexQueueProducer.toSearchableIds(documents), SearchType.DRIVE_FILE);
        } else {
            this._solrIndexQueue.queueMetadataAtomicUpdate(SolrIndexQueueProducer.toSearchableIds(documents), SearchType.DRIVE_FILE);
        }
    }

    @Nonnull
    private static List<SearchableId> toSearchableIds(Collection<DocumentId> documentIds) {
        return documentIds.stream().map(SolrIndexQueueProducer::toSearchableId).collect(Collectors.toList());
    }

    @Nonnull
    private static SearchableId toSearchableId(DocumentId documentId) {
        return SearchableId.Companion.fromCanonicalId(documentId.toSearchId());
    }
}

