/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.event.DocumentMetadataChangedEvent;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.FileDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileServiceImpl
implements FileService {
    final FileDAO _fileDAO;
    final FileVersionDAO _fileVersionDAO;
    final FileStorageDAO _fileStorageDao;
    final DocumentDAO _documentDAO;
    final EventBus _evenbus;

    @Autowired
    public FileServiceImpl(FileDAO fileDAO, FileVersionDAO fileVersionDAO, DocumentDAO documentDAO, FileStorageDAO fileStorageDAO, EventBus eventBus) {
        this._fileDAO = fileDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._documentDAO = documentDAO;
        this._fileStorageDao = fileStorageDAO;
        this._evenbus = eventBus;
    }

    public FileVersionBO getLastFileVersion(DocumentId fileId, PublishedFilter publishedFilter) {
        DocumentVersionId version = (DocumentVersionId)this._documentDAO.getLastVersions((Set)ImmutableSet.of((Object)fileId), publishedFilter).get((Object)fileId);
        if (version == null) {
            return null;
        }
        return (FileVersionBO)this._fileVersionDAO.getByIds((Set)ImmutableSet.of((Object)version)).get((Object)version);
    }

    public ByteSource getFileByteSource(FileVersionBO fileVersion) {
        return this._fileStorageDao.load(fileVersion.getStorageId());
    }

    public String getFileStorageUrl(FileVersionBO fileVersion) {
        return this._fileStorageDao.getUrl(fileVersion.getStorageId());
    }

    public boolean isFileStorageAvailable() {
        return this._fileStorageDao.isAvailable();
    }

    public ImmutableMap<DocumentVersionId, FileVersionBO> getVersionsByIds(Set<DocumentVersionId> fileIds) {
        return this._fileVersionDAO.getByIds(fileIds);
    }

    public FileVersionBO getSingleVersionById(DocumentVersionId fileVersionId) {
        return (FileVersionBO)this.getVersionsByIds((Set)ImmutableSet.of((Object)fileVersionId)).get((Object)fileVersionId);
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> ids, PublishedFilter publishedFilter) {
        return this._fileVersionDAO.getVersionsByDocumentIds(ids, publishedFilter);
    }

    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId id, PublishedFilter publishedFilter, int limit) {
        return this._fileVersionDAO.getLatestVersions(id, publishedFilter, limit);
    }

    public void updateMetadata(DocumentId fileId, String newDesc, String newTags) {
        this._documentDAO.updateMetadata(fileId, newDesc, newTags);
        this._evenbus.post((Object)new DocumentMetadataChangedEvent(fileId));
    }
}

