/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.search;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.batch.search.IndexerData;
import de.justsoftware.drive.batch.search.SearchIndexDataService;
import de.justsoftware.drive.batch.search.SearchIndexPublisher;
import de.justsoftware.drive.batch.search.SearchUtils;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import de.justsoftware.search.shared.DefaultSolrIndexDataLoader;
import de.justsoftware.search.shared.LoaderContext;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.JustSocialContentAtomicUpdateSolrDocument;
import de.justsoftware.search.shared.model.JustSocialFullUpdateSolrDocument;
import de.justsoftware.search.shared.model.JustSocialMetadataAtomicUpdateSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class DriveSolrIndexDataLoader
extends DefaultSolrIndexDataLoader {
    private final SearchIndexDataService _searchIndexDataService;
    private final SharesService _sharesService;
    private final DocumentService _documentService;
    private final SearchIndexPublisher _searchIndexPublisher;

    public DriveSolrIndexDataLoader(SearchIndexDataService searchIndexDataService, SolrIndexQueue solrIndexQueue, SharesService sharesService, DocumentService documentService, SearchIndexPublisher searchIndexPublisher) {
        super(JustApp.DRIVE, "24.12.8-4327", solrIndexQueue);
        this._searchIndexDataService = searchIndexDataService;
        this._sharesService = sharesService;
        this._documentService = documentService;
        this._searchIndexPublisher = searchIndexPublisher;
    }

    public Map<SearchableId, JustSocialFullUpdateSolrDocument> loadFullData(List<SearchableId> ids, LoaderContext context) {
        IndexerData indexData = this.loadIndexerData(ids);
        Map<SearchableId, JustSocialFullUpdateSolrDocument> result = this.loadMetaData(ids, indexData).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JustSocialMetadataAtomicUpdateSolrDocument)e.getValue()).toFullUpdateSolrDocument(null)));
        context.doAfterSendToSearchService(() -> result.values().forEach(document -> {
            DocumentId documentId = DriveSolrIndexDataLoader.toDocumentId((SearchableId)document.getId());
            DocumentVersionBO documentVersion = indexData.getCurrentDocumentVersion(documentId);
            if (documentVersion != null) {
                documentVersion.accept(file -> {
                    this._searchIndexPublisher.publishIndexContent(file.getDocumentId(), file.getStorageId(), file.getFileSize());
                    return this;
                }, folder -> this);
            }
        }));
        return result;
    }

    public Map<SearchableId, JustSocialMetadataAtomicUpdateSolrDocument> loadMetaData(List<SearchableId> ids, LoaderContext context) {
        IndexerData indexData = this.loadIndexerData(ids);
        return this.loadMetaData(ids, indexData);
    }

    public Map<SearchableId, JustSocialContentAtomicUpdateSolrDocument> loadContentData(List<SearchableId> ids, LoaderContext context) {
        return null;
    }

    @Transactional
    public void handleReindexForTypes(Set<? extends SearchType> types, de.justsoftware.search.shared.model.TenantId tenantId) {
        super.handleReindexForTypes(types, tenantId);
    }

    @Transactional
    public Stream<SearchableId> getAllSearchableIdForType(SearchType type, @Nullable de.justsoftware.search.shared.model.TenantId tenantId) {
        if (SearchType.DRIVE_FILE != type) {
            return Stream.empty();
        }
        if (tenantId != null) {
            throw new UnsupportedOperationException("Retrieving DocumentIds depending on tenantId is not supported.");
        }
        return this._documentService.streamAllDocumentId().map(documentId -> SearchableId.Companion.fromCanonicalId(documentId.toSearchId()));
    }

    @Nonnull
    private IndexerData loadIndexerData(List<SearchableId> ids) {
        ImmutableSetMultimap.Builder documents = ImmutableSetMultimap.builder();
        ids.forEach(id -> documents.put((Object)DriveSolrIndexDataLoader.toDocumentId((SearchableId)id), (Object)SearchIndexType.METADATA));
        return this._searchIndexDataService.getIndexData((SetMultimap)documents.build());
    }

    @Nonnull
    private Map<SearchableId, JustSocialMetadataAtomicUpdateSolrDocument> loadMetaData(List<SearchableId> ids, IndexerData indexData) {
        Set shareIds = ids.stream().map(id -> indexData.getCurrentDocumentVersion(DriveSolrIndexDataLoader.toDocumentId((SearchableId)id))).filter(version -> version != null && version.getItemId().getType().equals((Object)ItemType.SHARE)).map(DocumentVersionBO::getItemId).collect(Collectors.toSet());
        ImmutableMap rootFolderIds = this._sharesService.getRootFolderIds(shareIds);
        ImmutableMap.Builder result = ImmutableMap.builder();
        ids.forEach(id -> {
            JustSocialMetadataAtomicUpdateSolrDocument solrDocument = DriveSolrIndexDataLoader.createMetadataAtomicUpdateSolrDocument((SearchableId)id, (ImmutableMap)rootFolderIds, (IndexerData)indexData);
            if (solrDocument != null) {
                result.put(id, (Object)solrDocument);
            }
        });
        return result.build();
    }

    @Nonnull
    private static DocumentId toDocumentId(SearchableId searchableId) {
        if (!"DRIVE_DOCUMENT".equals(searchableId.getType())) {
            throw new IllegalStateException("Type of SearchableId is not a documentId: " + searchableId.toCanonicalId());
        }
        return new DocumentId(UUID.fromString(searchableId.getValue()));
    }

    @CheckForNull
    private static JustSocialMetadataAtomicUpdateSolrDocument createMetadataAtomicUpdateSolrDocument(SearchableId searchableId, ImmutableMap<ItemId, DocumentId> rootFolderIds, IndexerData indexData) {
        DocumentId documentId = DriveSolrIndexDataLoader.toDocumentId((SearchableId)searchableId);
        DocumentVersionBO documentVersion = indexData.getCurrentDocumentVersion(documentId);
        if (!SearchUtils.isSearchable((DocumentVersionBO)documentVersion)) {
            return null;
        }
        ItemId parentId = documentVersion.getItemId();
        boolean parentIsShare = parentId.getType().equals((Object)ItemType.SHARE);
        boolean isShare = documentVersion.isRoot() && parentIsShare;
        SearchableId searchableParentId = DriveSolrIndexDataLoader.toSearchableId((AbstractId)(parentIsShare ? (AbstractId)rootFolderIds.get((Object)parentId) : parentId));
        ItemBO parentItem = indexData.getItem(parentId);
        String name = DriveSolrIndexDataLoader.getName((DocumentVersionBO)documentVersion, (ItemBO)parentItem);
        SearchType searchType = isShare ? SearchType.DRIVE_SHARE : (SearchType)documentVersion.accept(file -> SearchType.DRIVE_FILE, folder -> SearchType.DRIVE_FOLDER);
        return new JustSocialMetadataAtomicUpdateSolrDocument(searchableId, name, DriveSolrIndexDataLoader.getApp((ItemId)parentId), searchType, documentVersion.getChangeDate(), DriveSolrIndexDataLoader.getPublicationDate((DocumentVersionBO)documentVersion, (IndexerData)indexData), isShare ? DriveSolrIndexDataLoader.getTenantId((ItemBO)parentItem) : null, isShare ? null : searchableParentId, isShare ? DriveSolrIndexDataLoader.getVisibleRoles((DocumentVersionBO)documentVersion, (IndexerData)indexData) : null, null, null, name, isShare ? null : searchableParentId, DriveSolrIndexDataLoader.getTags((DocumentVersionBO)documentVersion, (IndexerData)indexData), DriveSolrIndexDataLoader.getSearchableAdditionalData((DocumentVersionBO)documentVersion, (IndexerData)indexData), DriveSolrIndexDataLoader.getUnsearchableAdditionalData((DocumentVersionBO)documentVersion, (boolean)isShare));
    }

    @Nonnull
    private static Instant getPublicationDate(DocumentVersionBO documentVersion, IndexerData indexData) {
        ChangeBO firstPublicChange = indexData.getChange(documentVersion.getFirstPublicChange());
        return Optional.ofNullable(firstPublicChange != null ? firstPublicChange.getFirstPublishedDate() : null).orElseGet(() -> ((DocumentVersionBO)documentVersion).getChangeDate());
    }

    @Nonnull
    private static JustApp getApp(ItemId parentId) {
        if (ItemType.POST.equals((Object)parentId.getType())) {
            return JustApp.NEWS;
        }
        return JustApp.DRIVE;
    }

    @Nonnull
    private static String getName(DocumentVersionBO documentVersion, @Nullable ItemBO item) {
        if (documentVersion.isRoot() && item != null) {
            return item.getName();
        }
        return documentVersion.getName();
    }

    @Nonnull
    private static Set<String> getVisibleRoles(DocumentVersionBO documentVersion, IndexerData indexData) {
        ItemBO item = indexData.getItem(documentVersion.getItemId());
        if (item == null || item.isDeleted()) {
            return ImmutableSet.of();
        }
        ImmutableSet v = indexData.getVisibilities(documentVersion.getItemId(), DriveSolrIndexDataLoader.readActionForDocument((DocumentVersionBO)documentVersion));
        return v.stream().map(Role::getRoleString).collect(Collectors.toSet());
    }

    @CheckForNull
    private static de.justsoftware.search.shared.model.TenantId getTenantId(@Nullable ItemBO parentItem) {
        if (parentItem != null && !parentItem.isDeleted()) {
            TenantId tenantId = parentItem.getTenantId();
            if (tenantId == null) {
                return null;
            }
            return new de.justsoftware.search.shared.model.TenantId((UUID)tenantId.getId());
        }
        return null;
    }

    @Nonnull
    private static StaticAction readActionForDocument(DocumentVersionBO document) {
        return document.isPublic() ? StaticAction.DOCUMENT_READ : StaticAction.DOCUMENT_READ_PRIVATE;
    }

    @Nonnull
    private static List<String> getTags(DocumentVersionBO documentVersion, IndexerData indexData) {
        DocumentBO metadata = indexData.getDocument(documentVersion.getDocumentId());
        if (metadata == null) {
            return ImmutableList.of();
        }
        return Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)metadata.getTags()));
    }

    @Nonnull
    private static Map<String, List<String>> getSearchableAdditionalData(DocumentVersionBO documentVersion, IndexerData indexData) {
        DocumentBO metadata = indexData.getDocument(documentVersion.getDocumentId());
        if (metadata == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.of((Object)"description", (Object)ImmutableList.of((Object)metadata.getDescription()));
    }

    @Nonnull
    private static Map<String, String> getUnsearchableAdditionalData(DocumentVersionBO documentVersion, boolean isShare) {
        HashMap result = (HashMap)documentVersion.accept(file -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("file_size", String.valueOf(file.getFileSize()));
            map.put("mime_type", file.getMimeType());
            map.put("file_type", FileMetaInfoUtil.getFileType((String)file.getMimeType()).toSearchDriveFileType().toString());
            return map;
        }, folder -> new HashMap());
        if (isShare) {
            SearchableId searchableId = DriveSolrIndexDataLoader.toSearchableId((AbstractId)documentVersion.getItemId());
            result.put("share_id", searchableId != null ? searchableId.toString() : null);
        }
        return result;
    }

    @CheckForNull
    private static SearchableId toSearchableId(@Nullable AbstractId<?> id) {
        if (id instanceof ItemId) {
            ItemId itemId = (ItemId)id;
            return new SearchableId(itemId.getValue(), itemId.getType().name());
        }
        if (id instanceof DocumentId) {
            return SearchableId.Companion.fromCanonicalId(((DocumentId)id).toSearchId());
        }
        return null;
    }
}

