/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka;

import de.justsoftware.chat.kafka.KafkaTopicCleanupService;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/chat/kafka/KafkaTopicCleanupService;", "", "bootstrapServers", "", "<init>", "(Ljava/lang/String;)V", "deleteOldTopics", "", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nKafkaTopicCleanupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaTopicCleanupService.kt\nde/justsoftware/chat/kafka/KafkaTopicCleanupService\n+ 2 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,56:1\n9#2:57\n8#2,3:58\n*S KotlinDebug\n*F\n+ 1 KafkaTopicCleanupService.kt\nde/justsoftware/chat/kafka/KafkaTopicCleanupService\n*L\n53#1:57\n53#1:58,3\n*E\n"})
public class KafkaTopicCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String bootstrapServers;
    private static final int LISTING_TIMEOUT = 10;
    @NotNull
    private static final String TOPIC_TO_CLEANUP = "just.connect.pubSub.operations";
    @NotNull
    private static final Logger LOG;

    public KafkaTopicCleanupService(@Value(value="${spring.kafka.bootstrap-servers:localhost:9092}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={ApplicationReadyEvent.class})
    public void deleteOldTopics() {
        Map config = MapsKt.mapOf((Pair)TuplesKt.to((Object)"bootstrap.servers", (Object)this.bootstrapServers));
        try {
            AutoCloseable autoCloseable = (AutoCloseable)KafkaAdminClient.create((Map)config);
            Throwable throwable = null;
            try {
                AdminClient adminClient = (AdminClient)autoCloseable;
                boolean bl = false;
                ListTopicsResult listTopicsResult = adminClient.listTopics();
                Intrinsics.checkNotNullExpressionValue((Object)listTopicsResult, (String)"listTopics(...)");
                ListTopicsResult result = listTopicsResult;
                boolean topicStillExists = ((Collection)result.listings().get(10L, TimeUnit.SECONDS)).stream().map(arg_0 -> KafkaTopicCleanupService.deleteOldTopics$lambda$4$lambda$1(KafkaTopicCleanupService::deleteOldTopics$lambda$4$lambda$0, arg_0)).anyMatch(arg_0 -> KafkaTopicCleanupService.deleteOldTopics$lambda$4$lambda$3(KafkaTopicCleanupService::deleteOldTopics$lambda$4$lambda$2, arg_0));
                if (topicStillExists) {
                    LOG.info("Will delete the following old topic just.connect.pubSub.operations");
                    adminClient.deleteTopics((Collection)CollectionsKt.listOf((Object)TOPIC_TO_CLEANUP));
                    LOG.info("Topic deleted successfully");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error when trying to delete old topic", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.error("Error when trying to delete old topic", (Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.error("Error when trying to delete old topic", (Throwable)e);
        }
    }

    private static final String deleteOldTopics$lambda$4$lambda$0(TopicListing topic) {
        return topic.name();
    }

    private static final String deleteOldTopics$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final boolean deleteOldTopics$lambda$4$lambda$2(String topic) {
        return StringsKt.equals((String)topic, (String)TOPIC_TO_CLEANUP, (boolean)true);
    }

    private static final boolean deleteOldTopics$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

