/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageAttachment;
import de.justsoftware.chat.business.model.DeletedMessage;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.drive.DriveAttachment;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMarkedForDeletionEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.exception.ChatAlreadyExistsException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.DriveDocumentId;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.persistence.ChatDeletionRepository;
import de.justsoftware.chat.persistence.ChatMessageAttachmentRepository;
import de.justsoftware.chat.persistence.ChatMessageAttachmentSpecifications;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.model.DbChat;
import de.justsoftware.chat.persistence.model.DbChatDeletion;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 `2\u00020\u0001:\u0001`BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0017J4\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\"2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020 H\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00190/2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u00100\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0016J\"\u00101\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00190\u001c2\f\u00102\u001a\b\u0012\u0004\u0012\u00020'03H\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020'H\u0016J&\u00106\u001a\b\u0012\u0004\u0012\u00020\u0019072\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u000e\u0010=\u001a\b\u0012\u0004\u0012\u00020'0>H\u0017J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020'0>2\u0006\u0010@\u001a\u00020AH\u0017J$\u0010B\u001a\b\u0012\u0004\u0012\u00020'032\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d0D2\u0006\u0010E\u001a\u00020FH\u0016J\u001e\u0010G\u001a\b\u0012\u0004\u0012\u00020'032\u0006\u0010H\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0016J\u001e\u0010I\u001a\b\u0012\u0004\u0012\u00020'032\u0006\u0010H\u001a\u00020 2\u0006\u0010J\u001a\u00020FH\u0016J\u0018\u0010K\u001a\u00020L2\u0006\u0010&\u001a\u00020'2\u0006\u0010M\u001a\u00020 H\u0017J*\u0010N\u001a\b\u0012\u0004\u0012\u00020O072\u0006\u0010P\u001a\u00020'2\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\u0018\u0010S\u001a\u00020L2\u0006\u0010&\u001a\u00020'2\u0006\u0010T\u001a\u00020 H\u0017J\u0010\u0010U\u001a\u00020L2\u0006\u0010V\u001a\u00020WH\u0017J,\u0010X\u001a\b\u0012\u0004\u0012\u00020\u0019072\u0006\u00109\u001a\u00020:2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d032\u0006\u0010;\u001a\u00020<H\u0012J \u0010Y\u001a\u00020\u00192\u0006\u0010Z\u001a\u00020\u00192\u0006\u0010[\u001a\u00020\u00192\u0006\u0010*\u001a\u00020 H\u0012J(\u0010\\\u001a\u00020\u0019*\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0012J \u0010]\u001a\u00020\u00192\u0006\u0010P\u001a\u00020'2\u0006\u0010#\u001a\u00020$2\u0006\u0010*\u001a\u00020 H\u0016J\u0018\u0010^\u001a\u00020\u00192\u0006\u0010P\u001a\u00020'2\u0006\u0010_\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lde/justsoftware/chat/business/ChatService;", "", "permissionService", "Lde/justsoftware/chat/business/PermissionService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "driveService", "Lde/justsoftware/chat/business/DriveService;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "chatDeletionRepository", "Lde/justsoftware/chat/persistence/ChatDeletionRepository;", "chatMessageAttachmentRepository", "Lde/justsoftware/chat/persistence/ChatMessageAttachmentRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/chat/business/PermissionService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/DriveService;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/ChatDeletionRepository;Lde/justsoftware/chat/persistence/ChatMessageAttachmentRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "createChat", "Lde/justsoftware/chat/business/model/Chat;", "chat", "participants", "", "Lde/justsoftware/chat/model/ParticipantId;", "Lde/justsoftware/chat/model/PermissionType;", "creator", "Lde/justsoftware/chat/model/ProfileId;", "createChatWithIcon", "Lde/justsoftware/chat/business/model/MultiUserChat;", "icon", "Lorg/springframework/web/multipart/MultipartFile;", "updateUserGroupChatTitle", "id", "Lde/justsoftware/chat/model/ChatId;", "title", "", "updater", "updateOnNewMessage", "message", "Lde/justsoftware/chat/business/model/ChatMessage;", "findById", "Ljava/util/Optional;", "getById", "findByIds", "ids", "", "existsById", "", "getRecentChats", "Lorg/springframework/data/domain/Page;", "currentProfileId", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "offset", "Lde/justsoftware/chat/model/Offset;", "streamAllIds", "Ljava/util/stream/Stream;", "findIdsByType", "type", "Lde/justsoftware/chat/model/ChatType;", "findIdsByUpdatedSyncDate", "participantIds", "", "syncDate", "Ljava/time/Instant;", "findIdsOfProfile", "profileId", "findOneOnOneIdsWithUpdatedPartnerProfile", "updatedSince", "delete", "", "deletedBy", "findAttachmentsForChat", "Lde/justsoftware/chat/business/model/ChatMessageAttachment;", "chatId", "attachmentFilter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "restoreChat", "restoredBy", "onProfileUpdated", "profileUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "findByTenantIdAndParticipantIds", "updateChat", "oldChat", "newChat", "validatedForCreate", "updateChatIcon", "deleteChatIcon", "deleter", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatService.kt\nde/justsoftware/chat/business/ChatService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,409:1\n1557#2:410\n1628#2,3:411\n1368#2:414\n1454#2,5:415\n1557#2:420\n1628#2,3:421\n1202#2,2:424\n1230#2,4:426\n1557#2:430\n1628#2,3:431\n1628#2,3:435\n1628#2,3:439\n1628#2,3:443\n1557#2:446\n1628#2,3:447\n817#2,2:451\n295#2,2:453\n7#3:434\n7#3:438\n7#3:442\n22#3:450\n*S KotlinDebug\n*F\n+ 1 ChatService.kt\nde/justsoftware/chat/business/ChatService\n*L\n156#1:410\n156#1:411,3\n158#1:414\n158#1:415,5\n159#1:420\n159#1:421,3\n160#1:424,2\n160#1:426,4\n182#1:430\n182#1:431,3\n185#1:435,3\n190#1:439,3\n198#1:443,3\n280#1:446\n280#1:447,3\n325#1:451,2\n326#1:453,2\n185#1:434\n190#1:438\n198#1:442\n325#1:450\n*E\n"})
public class ChatService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ChatDeletionRepository chatDeletionRepository;
    @NotNull
    private final ChatMessageAttachmentRepository chatMessageAttachmentRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;

    public ChatService(@NotNull PermissionService permissionService, @NotNull ChatParticipantService chatParticipantService, @NotNull UserGroupService userGroupService, @NotNull DriveService driveService, @NotNull ChatRepository chatRepository, @NotNull ChatDeletionRepository chatDeletionRepository, @NotNull ChatMessageAttachmentRepository chatMessageAttachmentRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)chatDeletionRepository, (String)"chatDeletionRepository");
        Intrinsics.checkNotNullParameter((Object)chatMessageAttachmentRepository, (String)"chatMessageAttachmentRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.permissionService = permissionService;
        this.chatParticipantService = chatParticipantService;
        this.userGroupService = userGroupService;
        this.driveService = driveService;
        this.chatRepository = chatRepository;
        this.chatDeletionRepository = chatDeletionRepository;
        this.chatMessageAttachmentRepository = chatMessageAttachmentRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @Transactional
    @NotNull
    public Chat createChat(@NotNull Chat chat, @NotNull Map<ParticipantId, ? extends PermissionType> participants, @NotNull ProfileId creator) throws ValidationException {
        Chat chat2;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Object object = this.chatRepository.save((Object)DbChat.Companion.toDbChat(this.validatedForCreate(chat, participants, creator)));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        Chat savedChat = chat2 = DbChat.Companion.toChat((DbChat)object);
        boolean bl = false;
        this.chatParticipantService.setParticipants(savedChat.getId(), participants, creator, true);
        this.transactionUtils.afterCommit(() -> ChatService.createChat$lambda$1$lambda$0(this, savedChat, creator));
        return chat2;
    }

    @NotNull
    public Chat createChatWithIcon(@NotNull MultiUserChat chat, @NotNull Map<ParticipantId, ? extends PermissionType> participants, @NotNull ProfileId creator, @NotNull MultipartFile icon) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return (Chat)this.driveService.uploadFiles(CollectionsKt.listOf((Object)icon), chat.getId().toAssetPermissionId(), creator, arg_0 -> ChatService.createChatWithIcon$lambda$2(chat, this, participants, creator, arg_0));
    }

    @NotNull
    public Chat updateUserGroupChatTitle(@NotNull ChatId id, @NotNull String title, @NotNull ProfileId updater) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Chat oldChat = this.getById(id);
        if (!(oldChat instanceof MultiUserChat)) {
            throw new ValidationException("Update a chat title is only allowed for MULTI_USER_CHATs", null, 2, null);
        }
        if (Intrinsics.areEqual((Object)((MultiUserChat)oldChat).getTitle(), (Object)title)) {
            return oldChat;
        }
        MultiUserChat multiUserChat = (MultiUserChat)oldChat;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        MultiUserChat newChat = MultiUserChat.copy$default((MultiUserChat)multiUserChat, null, (String)title, null, null, null, (Instant)instant, null, null, null, (int)477, null);
        Companion.access$validateTitle((Companion)Companion, (Chat)((Chat)newChat));
        return this.updateChat(oldChat, (Chat)newChat, updater);
    }

    @NotNull
    public Chat updateOnNewMessage(@NotNull ChatMessage message) {
        Chat chat;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Chat oldChat = this.getById(message.getChatId());
        ChatMessage chatMessage = message;
        if (chatMessage instanceof UserMessage) {
            chat = Companion.access$copy((Companion)Companion, (Chat)oldChat, (ChatMessageId)((UserMessage)message).getId(), (Instant)((UserMessage)message).getCreatedAt(), (Instant)((UserMessage)message).getUpdatedAt());
        } else if (chatMessage instanceof SystemMessage || chatMessage instanceof DeletedMessage) {
            chat = Companion.copy$default((Companion)Companion, (Chat)oldChat, null, null, (Instant)message.getUpdatedAt(), (int)3, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Chat newChat = chat;
        return this.updateChat(oldChat, newChat, message.getAuthor());
    }

    @NotNull
    public Optional<Chat> findById(@NotNull ChatId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Optional<Chat> optional = this.chatRepository.findById((Object)id.getValue()).map(arg_0 -> ChatService.findById$lambda$4(ChatService::findById$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @NotNull
    public Chat getById(@NotNull ChatId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object t = this.findById(id).orElseThrow(() -> ChatService.getById$lambda$5(id));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (Chat)t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Chat> findByIds(@NotNull Set<ChatId> ids) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$map$iv = ids;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.getValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ChatRepository $i$f$map22 = this.chatRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllById(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        Iterable $i$f$flatMap22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (DbChat)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object.add(DbChat.Companion.toChat((DbChat)it));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Chat bl = (Chat)element$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv22;
    }

    public boolean existsById(@NotNull ChatId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.chatRepository.existsById((Object)id.getValue());
    }

    @NotNull
    public Page<Chat> getRecentChats(@NotNull ProfileId currentProfileId, @NotNull TenantId tenantId, @NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)currentProfileId, (String)"currentProfileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Set userGroupIds = this.userGroupService.getUserGroupIdsByProfileId(currentProfileId);
        Set participantIds = SetsKt.plus((Set)userGroupIds, (Object)currentProfileId);
        return this.findByTenantIdAndParticipantIds(tenantId, participantIds, offset);
    }

    @Transactional
    @NotNull
    public Stream<ChatId> streamAllIds() {
        Stream<ChatId> stream = this.chatRepository.streamAllIds().map(arg_0 -> ChatService.streamAllIds$lambda$9((Function1)streamAllIds.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    @Transactional
    @NotNull
    public Stream<ChatId> findIdsByType(@NotNull ChatType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Stream<ChatId> stream = this.chatRepository.findAllChatIdsByType(type).map(arg_0 -> ChatService.findIdsByType$lambda$10((Function1)findIdsByType.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findIdsByUpdatedSyncDate(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant syncDate) {
        UUID p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)syncDate, (String)"syncDate");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findChatsBySyncDateGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), syncDate);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (UUID)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new ChatId(p0));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findIdsOfProfile(@NotNull ProfileId profileId, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Iterable $this$mapToSet$iv = this.chatRepository.findChatIdsOfProfile(profileId.toCanonicalId(), tenantId.getValue());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId((UUID)p0));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findOneOnOneIdsWithUpdatedPartnerProfile(@NotNull ProfileId profileId, @NotNull Instant updatedSince) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        Iterable $this$mapToSet$iv = this.chatRepository.findOneOnOneChatsByOtherUserUpdatedAtGreaterThan(profileId.toCanonicalId(), updatedSince);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId((UUID)p0));
        }
        return (Set)destination$iv$iv;
    }

    @Transactional
    public void delete(@NotNull ChatId id, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        Chat deletedChat = this.getById(id);
        this.chatDeletionRepository.save((Object)new DbChatDeletion(id, deletedBy));
        List movedParticipants = this.chatParticipantService.moveParticipantsToDeleted(id, deletedBy);
        this.transactionUtils.afterCommit(() -> ChatService.delete$lambda$15(this, deletedChat, deletedBy, movedParticipants));
    }

    @NotNull
    public Page<ChatMessageAttachment> findAttachmentsForChat(@NotNull ChatId chatId, @NotNull Offset offset, @Nullable AttachmentFilter attachmentFilter) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Specification specification = ChatMessageAttachmentSpecifications.INSTANCE.withChatId(chatId.getValue()).and(ChatMessageAttachmentSpecifications.INSTANCE.withAttachmentType(attachmentFilter));
        Page page = this.chatMessageAttachmentRepository.findAll(specification, Offset.Companion.toPageable$default((Offset.Companion)Offset.Companion, (Offset)offset, null, (int)1, null)).map(arg_0 -> ChatService.findAttachmentsForChat$lambda$17(ChatService::findAttachmentsForChat$lambda$16, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    public static /* synthetic */ Page findAttachmentsForChat$default(ChatService chatService, ChatId chatId, Offset offset, AttachmentFilter attachmentFilter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findAttachmentsForChat");
        }
        if ((n & 4) != 0) {
            attachmentFilter = null;
        }
        return chatService.findAttachmentsForChat(chatId, offset, attachmentFilter);
    }

    @Transactional
    public void restoreChat(@NotNull ChatId id, @NotNull ProfileId restoredBy) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)restoredBy, (String)"restoredBy");
        if (!this.existsById(id)) {
            throw new NotFoundException("Can't restore chat with id: " + id + ". A Chat with this id does not exist.");
        }
        this.chatDeletionRepository.deleteById((Object)id.getValue());
        this.chatParticipantService.moveParticipantsFromDeleted(id, restoredBy);
    }

    @EventListener
    @Transactional
    public void onProfileUpdated(@NotNull ProfileUpdatedEvent profileUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileUpdatedEvent, (String)"profileUpdatedEvent");
        if (profileUpdatedEvent.isActivationUpdate()) {
            String string = profileUpdatedEvent.getProfileId().toCanonicalId();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            this.chatRepository.updateSyncDateForMultiUserChatsWithManagerOrWriterParticipant(string, instant);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Page<Chat> findByTenantIdAndParticipantIds(TenantId tenantId, Set<? extends ParticipantId> participantIds, Offset offset) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String[] stringArray = (String[])participantIds;
        UUID uUID = tenantId.getValue();
        ChatRepository chatRepository = this.chatRepository;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        stringArray = new String[]{"sortDate"};
        Page page = chatRepository.findChatHavingMessagesByTenantIdAndParticipantIdIn(uUID, (Iterable)collection, Offset.Companion.toPageable(offset, PagingUtilsKt.sortDesc((String[])stringArray))).map(arg_0 -> ChatService.findByTenantIdAndParticipantIds$lambda$20(ChatService::findByTenantIdAndParticipantIds$lambda$19, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"map(...)");
        return page;
    }

    private Chat updateChat(Chat oldChat, Chat newChat, ProfileId updater) throws ValidationException {
        Chat chat;
        Object object = this.chatRepository.save((Object)DbChat.Companion.toDbChat(newChat));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        Chat savedChat = chat = DbChat.Companion.toChat((DbChat)object);
        boolean bl = false;
        this.transactionUtils.afterCommit(() -> ChatService.updateChat$lambda$22$lambda$21(this, savedChat, oldChat, updater));
        return chat;
    }

    /*
     * WARNING - void declaration
     */
    private Chat validatedForCreate(Chat $this$validatedForCreate, Map<ParticipantId, ? extends PermissionType> participants, ProfileId creator) throws ValidationException {
        Chat chat;
        Chat $this$validatedForCreate_u24lambda_u2424 = chat = $this$validatedForCreate;
        boolean bl = false;
        if (this.existsById($this$validatedForCreate_u24lambda_u2424.getId())) {
            throw new ChatAlreadyExistsException($this$validatedForCreate_u24lambda_u2424.getId(), "Can't create chat with id: " + $this$validatedForCreate_u24lambda_u2424.getId() + ". A Chat with this id already exists.");
        }
        if (participants.isEmpty()) {
            throw new ValidationException("Create a new chat without participants is not allowed.", null, 2, null);
        }
        if ($this$validatedForCreate_u24lambda_u2424 instanceof OneOnOneChat) {
            Object v0;
            block9: {
                void $this$firstOrNull$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstanceToSet$iv;
                if (participants.size() != 2) {
                    throw new ValidationException("Creating ONE_ON_ONE chat without exactly 2 participants is not allowed.", null, 2, null);
                }
                if (!participants.containsKey(creator)) {
                    throw new ValidationException("Creating ONE_ON_ONE chat for other participants is not allowed.", null, 2, null);
                }
                Iterable iterable = participants.keySet();
                boolean $i$f$filterIsInstanceToSet = false;
                Iterator iterator = $this$filterIsInstanceToSet$iv;
                Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ProfileId)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstanceToSet$iv = (Set)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ProfileId it = (ProfileId)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)creator))) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            ProfileId profileId = v0;
            if (profileId == null) {
                throw new ValidationException("Creating ONE_ON_ONE chat without a single (profile) chat partner is not allowed.", null, 2, null);
            }
            ProfileId chatPartnerId = profileId;
            ChatId existingOneOnOneChatId = this.chatParticipantService.getOneOnOneChatIdByChatPartnerId(chatPartnerId, creator);
            if (existingOneOnOneChatId != null) {
                throw new ChatAlreadyExistsException(existingOneOnOneChatId, "A ONE_ON_ONE chat with this chat partner already exists.");
            }
        }
        Companion.access$validateTitle((Companion)Companion, (Chat)$this$validatedForCreate_u24lambda_u2424);
        return chat;
    }

    @NotNull
    public Chat updateChatIcon(@NotNull ChatId chatId, @NotNull MultipartFile icon, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Chat oldChat = this.getById(chatId);
        if (!(oldChat instanceof MultiUserChat)) {
            throw new ValidationException("Tried to set chat icon for non-multi-user-chat with id " + chatId, null, 2, null);
        }
        if (((MultiUserChat)oldChat).getIconId() != null) {
            this.driveService.deleteFiles(CollectionsKt.listOf((Object)new DriveDocumentId(((MultiUserChat)oldChat).getIconId().getValue())), updater);
        }
        return (Chat)this.driveService.uploadFiles(CollectionsKt.listOf((Object)icon), chatId.toAssetPermissionId(), updater, arg_0 -> ChatService.updateChatIcon$lambda$25(oldChat, this, updater, arg_0));
    }

    @NotNull
    public Chat deleteChatIcon(@NotNull ChatId chatId, @NotNull ProfileId deleter) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)deleter, (String)"deleter");
        Chat oldChat = this.getById(chatId);
        if (!(oldChat instanceof MultiUserChat)) {
            throw new ValidationException("Tried to delete chat icon for non-multi-user-chat with id " + chatId, null, 2, null);
        }
        if (((MultiUserChat)oldChat).getIconId() == null) {
            return oldChat;
        }
        this.driveService.deleteFiles(CollectionsKt.listOf((Object)new DriveDocumentId(((MultiUserChat)oldChat).getIconId().getValue())), deleter);
        MultiUserChat multiUserChat = (MultiUserChat)oldChat;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        Instant instant2 = instant;
        MultiUserChat newChat = MultiUserChat.copy$default((MultiUserChat)multiUserChat, null, null, null, null, null, (Instant)instant2, null, null, null, (int)415, null);
        return this.updateChat(oldChat, (Chat)newChat, deleter);
    }

    private static final Unit createChat$lambda$1$lambda$0(ChatService this$0, Chat $savedChat, ProfileId $creator) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$savedChat, (String)"$savedChat");
        Intrinsics.checkNotNullParameter((Object)$creator, (String)"$creator");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatCreatedEvent((Object)this$0, $savedChat.getId(), $savedChat, $creator));
        this$0.permissionService.addPermissionItemForNewChat($savedChat.getId(), $savedChat.getTenantId());
        return Unit.INSTANCE;
    }

    private static final Chat createChatWithIcon$lambda$2(MultiUserChat $chat, ChatService this$0, Map $participants, ProfileId $creator, List driveAttachments) {
        Intrinsics.checkNotNullParameter((Object)$chat, (String)"$chat");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$participants, (String)"$participants");
        Intrinsics.checkNotNullParameter((Object)$creator, (String)"$creator");
        Intrinsics.checkNotNullParameter((Object)driveAttachments, (String)"driveAttachments");
        DriveAttachment driveAttachment = (DriveAttachment)CollectionsKt.firstOrNull((List)driveAttachments);
        Companion.access$validateImage((Companion)Companion, (DriveAttachment)driveAttachment);
        DriveAttachment driveAttachment2 = driveAttachment;
        MultiUserChat newChat = MultiUserChat.copy$default((MultiUserChat)$chat, null, null, null, null, null, null, (DriveDocumentId)(driveAttachment2 != null ? driveAttachment2.getDriveDocumentId() : null), null, null, (int)447, null);
        return this$0.createChat((Chat)newChat, $participants, $creator);
    }

    private static final Chat findById$lambda$3(DbChat it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChat.Companion.toChat(it);
    }

    private static final Chat findById$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Chat)$tmp0.invoke(p0);
    }

    private static final NotFoundException getById$lambda$5(ChatId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("Chat with id " + $id + " does not exist.");
    }

    private static final ChatId streamAllIds$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatId)$tmp0.invoke(p0);
    }

    private static final ChatId findIdsByType$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatId)$tmp0.invoke(p0);
    }

    private static final Unit delete$lambda$15(ChatService this$0, Chat $deletedChat, ProfileId $deletedBy, List $movedParticipants) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$deletedChat, (String)"$deletedChat");
        Intrinsics.checkNotNullParameter((Object)$deletedBy, (String)"$deletedBy");
        Intrinsics.checkNotNullParameter((Object)$movedParticipants, (String)"$movedParticipants");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatMarkedForDeletionEvent((Object)this$0, $deletedChat, $deletedBy, $movedParticipants));
        return Unit.INSTANCE;
    }

    private static final ChatMessageAttachment findAttachmentsForChat$lambda$16(DbChatMessageAttachment it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChatMessageAttachment.Companion.toChatMessageAttachment(it);
    }

    private static final ChatMessageAttachment findAttachmentsForChat$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessageAttachment)$tmp0.invoke(p0);
    }

    private static final Chat findByTenantIdAndParticipantIds$lambda$19(DbChat it) {
        Intrinsics.checkNotNull((Object)it);
        return DbChat.Companion.toChat(it);
    }

    private static final Chat findByTenantIdAndParticipantIds$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Chat)$tmp0.invoke(p0);
    }

    private static final Unit updateChat$lambda$22$lambda$21(ChatService this$0, Chat $savedChat, Chat $oldChat, ProfileId $updater) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$savedChat, (String)"$savedChat");
        Intrinsics.checkNotNullParameter((Object)$oldChat, (String)"$oldChat");
        Intrinsics.checkNotNullParameter((Object)$updater, (String)"$updater");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatUpdatedEvent((Object)this$0, $savedChat.getId(), $oldChat, $savedChat, $updater));
        return Unit.INSTANCE;
    }

    private static final Chat updateChatIcon$lambda$25(Chat $oldChat, ChatService this$0, ProfileId $updater, List driveAttachments) {
        Intrinsics.checkNotNullParameter((Object)$oldChat, (String)"$oldChat");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$updater, (String)"$updater");
        Intrinsics.checkNotNullParameter((Object)driveAttachments, (String)"driveAttachments");
        DriveAttachment driveAttachment = (DriveAttachment)CollectionsKt.firstOrNull((List)driveAttachments);
        Companion.access$validateImage((Companion)Companion, (DriveAttachment)driveAttachment);
        MultiUserChat multiUserChat = (MultiUserChat)$oldChat;
        DriveAttachment driveAttachment2 = driveAttachment;
        DriveDocumentId driveDocumentId = driveAttachment2 != null ? driveAttachment2.getDriveDocumentId() : null;
        Instant instant = this$0.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        Instant instant2 = instant;
        MultiUserChat newChat = MultiUserChat.copy$default((MultiUserChat)multiUserChat, null, null, null, null, null, (Instant)instant2, (DriveDocumentId)driveDocumentId, null, null, (int)415, null);
        return this$0.updateChat($oldChat, (Chat)newChat, $updater);
    }
}

