/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.model.CoreAppSettings;
import de.justsoftware.admin.id.CoreAppId;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.model.HexColor;
import java.util.Set;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapper
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH'J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH'J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000eH'J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\nH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/CoreAppSettingsMapper;", "", "deleteByTenant", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "deleteLegacyAppById", "id", "Lde/justsoftware/admin/id/CoreAppId;", "findCoreApp", "Lde/justsoftware/admin/domain/appsettings/model/CoreAppSettings;", "getCoreAppsByApp", "", "coreApp", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "getCoreAppsByTenantId", "getIconIds", "Lde/justsoftware/admin/id/DocumentId;", "upsertCoreApp", "admin-service"})
public interface CoreAppSettingsMapper {
    @Insert(value={"\n        <script>\n            <if test=\"_databaseId == 'POSTGRES'\">\n                INSERT INTO app_settings (id, tenant_id, app, app_color, active, icon_id, name, home_screen_app_color)\n                    VALUES (#{id}, #{tenantId}, #{app}, #{appColor}, #{active}, #{iconId}, #{name}, #{homeScreenAppColor})\n                ON CONFLICT(id) DO UPDATE SET \n                    app_color = #{appColor},\n                    active = #{active},\n                    icon_id = #{iconId},\n                    name = #{name},\n                    home_screen_app_color = #{homeScreenAppColor}\n            </if>\n\n            <if test=\"_databaseId == 'ORACLE'\">\n                MERGE INTO app_settings a\n                    USING (SELECT #{id} as id from dual) s\n                        ON (s.id = a.id)\n                        WHEN MATCHED THEN UPDATE SET \n                            app_color = #{appColor}, \n                            active = #{active},\n                            icon_id = #{iconId},\n                            name = #{name},\n                            home_screen_app_color = #{homeScreenAppColor}\n                        WHEN NOT MATCHED THEN\n                            INSERT (id, tenant_id, app, app_color, active, icon_id, name, home_screen_app_color)\n                            VALUES (#{id}, #{tenantId}, #{app}, #{appColor}, #{active}, #{iconId}, #{name}, #{homeScreenAppColor})\n            </if>\n        </script>\n        "})
    public void upsertCoreApp(@NotNull CoreAppSettings var1);

    @Results(id="CoreAppSettingsResult")
    @ConstructorArgs(value={@Arg(id=true, column="id", javaType=CoreAppId.class), @Arg(column="active", javaType=boolean.class), @Arg(column="icon_id", javaType=DocumentId.class), @Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="name", javaType=String.class), @Arg(column="app", javaType=CoreApp.class), @Arg(column="app_color", javaType=HexColor.class), @Arg(column="home_screen_app_color", javaType=HexColor.class), @Arg(column="position", javaType=int.class)})
    @Select(value={"\n        SELECT app_settings.*, \n            app_home_screen_position.position \n            FROM app_settings\n        INNER JOIN app_home_screen_position ON app_settings.id = app_home_screen_position.app_id\n        WHERE id = #{id}\n        "})
    @Nullable
    public CoreAppSettings findCoreApp(@NotNull CoreAppId var1);

    @ResultMap(value={"CoreAppSettingsResult"})
    @Select(value={"\n          SELECT app_settings.*,\n            app_home_screen_position.position\n            FROM app_settings\n        INNER JOIN app_home_screen_position ON app_settings.id = app_home_screen_position.app_id\n        WHERE app_settings.app = #{coreApp}\n        "})
    @NotNull
    public Set<CoreAppSettings> getCoreAppsByApp(@NotNull CoreApp var1);

    @ResultMap(value={"CoreAppSettingsResult"})
    @Select(value={"\n        SELECT app_settings.*, \n            app_home_screen_position.position \n            FROM app_settings\n        INNER JOIN app_home_screen_position ON app_settings.id = app_home_screen_position.app_id\n        WHERE app_settings.tenant_id = #{tenantId}\n        "})
    @NotNull
    public Set<CoreAppSettings> getCoreAppsByTenantId(@NotNull TenantId var1);

    @Select(value={"SELECT icon_id FROM app_settings WHERE tenant_id = #{tenantId} AND icon_id IS NOT NULL"})
    @NotNull
    public Set<DocumentId> getIconIds(@NotNull TenantId var1);

    @Delete(value={"DELETE FROM app_settings WHERE id = #{id} AND app IN ('TASKS', 'CONNECT')"})
    public void deleteLegacyAppById(@NotNull CoreAppId var1);

    @Delete(value={"DELETE FROM app_settings WHERE tenant_id = #{tenantId}"})
    public void deleteByTenant(@NotNull TenantId var1);
}

