/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user;

import de.justsoftware.admin.domain.user.model.Grantee;
import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.domain.user.persistence.ProfileDao;
import de.justsoftware.admin.domain.user.persistence.UserGroupDao;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019H\u0016J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/admin/domain/user/UserService;", "", "profileDao", "Lde/justsoftware/admin/domain/user/persistence/ProfileDao;", "userGroupDao", "Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;", "(Lde/justsoftware/admin/domain/user/persistence/ProfileDao;Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;)V", "deleteProfile", "Lde/justsoftware/admin/id/ProfileId;", "profileId", "deleteUserGroup", "Lde/justsoftware/admin/id/UserGroupId;", "userGroupId", "existsUserGroup", "", "id", "findAllTenantUsersGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "findProfile", "Lde/justsoftware/admin/domain/user/model/Profile;", "findUserGroup", "getAllTenantUsersGroup", "getAllUserGroups", "", "getByIds", "Lde/justsoftware/admin/domain/user/model/Grantee;", "ids", "Lde/justsoftware/admin/id/UserId;", "saveProfile", "profile", "saveUserGroup", "userGroup", "admin-service"})
@SourceDebugExtension(value={"SMAP\nUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserService.kt\nde/justsoftware/admin/domain/user/UserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1855#2,2:97\n1045#2:99\n*S KotlinDebug\n*F\n+ 1 UserService.kt\nde/justsoftware/admin/domain/user/UserService\n*L\n74#1:97,2\n85#1:99\n*E\n"})
public class UserService {
    @NotNull
    private final ProfileDao profileDao;
    @NotNull
    private final UserGroupDao userGroupDao;

    public UserService(@NotNull ProfileDao profileDao, @NotNull UserGroupDao userGroupDao) {
        Intrinsics.checkNotNullParameter((Object)profileDao, (String)"profileDao");
        Intrinsics.checkNotNullParameter((Object)userGroupDao, (String)"userGroupDao");
        this.profileDao = profileDao;
        this.userGroupDao = userGroupDao;
    }

    @NotNull
    public Profile saveProfile(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profileDao.save(profile);
        return profile;
    }

    @NotNull
    public UserGroup saveUserGroup(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.userGroupDao.save$admin_service(userGroup);
        return userGroup;
    }

    @NotNull
    public ProfileId deleteProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileDao.delete(profileId);
        return profileId;
    }

    @NotNull
    public UserGroupId deleteUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        this.userGroupDao.delete(userGroupId);
        return userGroupId;
    }

    public boolean existsUserGroup(@NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.userGroupDao.findById(id) != null;
    }

    @Nullable
    public Profile findProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return (Profile)CollectionsKt.firstOrNull((Iterable)this.profileDao.getByIds((Collection)SetsKt.setOf((Object)profileId)));
    }

    @Nullable
    public UserGroup findUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        return (UserGroup)CollectionsKt.firstOrNull((Iterable)this.userGroupDao.getByIds((Collection)SetsKt.setOf((Object)userGroupId)));
    }

    @NotNull
    public List<UserGroup> getAllUserGroups() {
        return this.userGroupDao.getAll();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Grantee> getByIds(@NotNull List<? extends UserId> ids) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        List profileIds = new ArrayList();
        List groupIds = new ArrayList();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserId it = (UserId)element$iv;
            boolean bl = false;
            UserId userId = it;
            if (userId instanceof ProfileId) {
                profileIds.add(it);
                continue;
            }
            if (!(userId instanceof UserGroupId)) continue;
            groupIds.add(it);
        }
        Set profiles = this.profileDao.getByIds((Collection)profileIds);
        Set groups = this.userGroupDao.getByIds((Collection)groupIds);
        Iterable iterable = SetsKt.plus((Set)profiles, (Iterable)groups);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @Nullable
    public UserGroup findAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.userGroupDao.findAllTenantUsersGroup(tenantId);
    }

    @NotNull
    public UserGroup getAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        UserGroup userGroup = this.userGroupDao.findAllTenantUsersGroup(tenantId);
        if (userGroup == null) {
            throw new NotFoundException("No AllTenantUsersGroup found");
        }
        return userGroup;
    }
}

