/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.auth;

import de.justsoftware.admin.graphql.generated.types.ApiToken;
import de.justsoftware.admin.id.TenantId;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/admin/connector/auth/InternalAuthConnector;", "", "toroInternalUrl", "", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient$Builder;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "deleteScimToken", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "generateScimToken", "Lde/justsoftware/admin/graphql/generated/types/ApiToken;", "getScimToken", "admin-service"})
public class InternalAuthConnector {
    @NotNull
    private final RestClient restClient;

    public InternalAuthConnector(@Value(value="${just.auth.internal}") @NotNull String toroInternalUrl, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        RestClient restClient = restClientBuilder.baseUrl(toroInternalUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        this.restClient = restClient;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    @Nullable
    public ApiToken getScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return (ApiToken)this.getRestClient().get().uri(arg_0 -> InternalAuthConnector.getScimToken$lambda$0(tenantId, arg_0)).retrieve().toEntity(ApiToken.class).getBody();
    }

    @NotNull
    public ApiToken generateScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Object object = ((RestClient.RequestBodySpec)this.getRestClient().post().uri(arg_0 -> InternalAuthConnector.generateScimToken$lambda$1(tenantId, arg_0))).retrieve().toEntity(ApiToken.class).getBody();
        Intrinsics.checkNotNull((Object)object);
        return (ApiToken)object;
    }

    public boolean deleteScimToken(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.getRestClient().delete().uri(arg_0 -> InternalAuthConnector.deleteScimToken$lambda$2(tenantId, arg_0)).retrieve().toBodilessEntity();
        return true;
    }

    private static final URI getScimToken$lambda$0(TenantId $tenantId, UriBuilder it) {
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI generateScimToken$lambda$1(TenantId $tenantId, UriBuilder it) {
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }

    private static final URI deleteScimToken$lambda$2(TenantId $tenantId, UriBuilder it) {
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Object[] objectArray = new Object[]{$tenantId.toTypedString()};
        return it.path("/scim/token").queryParam("tenantId", objectArray).build(new Object[0]);
    }
}

