/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.model;

import com.google.common.collect.ImmutableList;
import de.justsoftware.people.business.search.model.SearchField;
import de.justsoftware.people.controller.model.PagedResultModel;
import de.justsoftware.people.model.PagedResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\t\u00a2\u0006\u0004\b\f\u0010\rB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\f\u0010\u000eJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0000\"\u0004\b\u0001\u0010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00190\u001bJ(\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0000\"\u0004\b\u0001\u0010\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/people/model/PagedResult;", "T", "", "offset", "", "totalCount", "rows", "", "facets", "", "Lde/justsoftware/people/business/search/model/SearchField;", "", "<init>", "(JJLjava/util/List;Ljava/util/Map;)V", "(JJLjava/util/List;)V", "getOffset", "()J", "getTotalCount", "getRows", "()Ljava/util/List;", "getFacets", "()Ljava/util/Map;", "toPagedResultModel", "Lde/justsoftware/people/controller/model/PagedResultModel;", "map", "R", "transform", "Lkotlin/Function1;", "mapNotNull", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nPagedResult.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagedResult.kt\nde/justsoftware/people/model/PagedResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1557#2:40\n1628#2,3:41\n1611#2,9:44\n1863#2:53\n1864#2:55\n1620#2:56\n1#3:54\n*S KotlinDebug\n*F\n+ 1 PagedResult.kt\nde/justsoftware/people/model/PagedResult\n*L\n22#1:40\n22#1:41,3\n27#1:44,9\n27#1:53\n27#1:55\n27#1:56\n27#1:54\n*E\n"})
public final class PagedResult<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long offset;
    private final long totalCount;
    @NotNull
    private final List<T> rows;
    @NotNull
    private final Map<SearchField, List<String>> facets;

    public PagedResult(long offset, long totalCount, @NotNull List<? extends T> rows, @NotNull Map<SearchField, ? extends List<String>> facets) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(facets, (String)"facets");
        this.offset = offset;
        this.totalCount = totalCount;
        this.rows = rows;
        this.facets = facets;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final long getTotalCount() {
        return this.totalCount;
    }

    @NotNull
    public final List<T> getRows() {
        return this.rows;
    }

    @NotNull
    public final Map<SearchField, List<String>> getFacets() {
        return this.facets;
    }

    public PagedResult(long offset, long totalCount, @NotNull List<? extends T> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        this(offset, totalCount, rows, MapsKt.emptyMap());
    }

    @NotNull
    public final PagedResultModel<T> toPagedResultModel() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.rows);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
        return new PagedResultModel(this.offset, this.totalCount, (List)immutableList, Companion.toImmutableMultimap(this.facets));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <R> PagedResult<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable iterable = this.rows;
        long l = this.totalCount;
        long l2 = this.offset;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(transform.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        Map map = this.facets;
        List list2 = list;
        long l3 = l;
        long l4 = l2;
        return new PagedResult(l4, l3, list2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <R> PagedResult<R> mapNotNull(@NotNull Function1<? super T, ? extends R> transform) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable iterable = this.rows;
        long l = this.totalCount;
        long l2 = this.offset;
        boolean $i$f$mapNotNull = false;
        void var4_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            if (transform.invoke(element$iv$iv) == null) continue;
            boolean bl2 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Map map = this.facets;
        List list2 = list;
        long l3 = l;
        long l4 = l2;
        return new PagedResult(l4, l3, list2, map);
    }
}

