/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import de.justsoftware.people.application.ConfigApplicationService;
import de.justsoftware.people.application.model.CreateLinkDto;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.config.FeatureConfig;
import de.justsoftware.people.config.FeatureToggleService;
import de.justsoftware.people.controller.model.Config;
import de.justsoftware.people.model.ExternalLinkId;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import io.swagger.v3.oas.annotations.Operation;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/config"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0012J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0017J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0017J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/people/controller/ConfigController;", "", "configApplicationService", "Lde/justsoftware/people/application/ConfigApplicationService;", "featureToggleService", "Lde/justsoftware/people/config/FeatureToggleService;", "<init>", "(Lde/justsoftware/people/application/ConfigApplicationService;Lde/justsoftware/people/config/FeatureToggleService;)V", "config", "Lde/justsoftware/people/controller/model/Config;", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "mayCreateUserGroups", "", "mayManageTenant", "mayExportUsers", "createExternalLink", "Lde/justsoftware/people/model/ExternalLinkId;", "createLinkDto", "Lde/justsoftware/people/application/model/CreateLinkDto;", "getExternalLinks", "", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "deleteExternalLinks", "", "linkIds", "people-api"})
public class ConfigController {
    @NotNull
    private final ConfigApplicationService configApplicationService;
    @NotNull
    private final FeatureToggleService featureToggleService;

    @Autowired
    public ConfigController(@NotNull ConfigApplicationService configApplicationService, @NotNull FeatureToggleService featureToggleService) {
        Intrinsics.checkNotNullParameter((Object)configApplicationService, (String)"configApplicationService");
        Intrinsics.checkNotNullParameter((Object)featureToggleService, (String)"featureToggleService");
        this.configApplicationService = configApplicationService;
        this.featureToggleService = featureToggleService;
    }

    @GetMapping
    @Operation(summary="Get the config object for the people webclient.")
    @NotNull
    public Config config(@NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        boolean hasConfiguredLinks = !((Collection)this.configApplicationService.getExternalLinks(tenantId, authCtx)).isEmpty();
        FeatureConfig featureConfig = this.configApplicationService.getFeatureConfig(authCtx);
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        boolean bl = this.mayCreateUserGroups(authCtx);
        String string = this.featureToggleService.getExternalSearchUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalSearchUrl(...)");
        String string2 = this.featureToggleService.getExternalSearchProfileFieldId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExternalSearchProfileFieldId(...)");
        return new Config(profileId, bl, string, string2, hasConfiguredLinks, this.mayManageTenant(authCtx), this.mayExportUsers(authCtx), featureConfig.isBirthdayListEnabled(), featureConfig.isAbsenceEnabled(), featureConfig.getAbsencePollingIntervalInMs());
    }

    private boolean mayCreateUserGroups(AuthorizationContext authCtx) {
        return authCtx.may(Role.writeApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)authCtx.getTenantId().getId())));
    }

    private boolean mayManageTenant(AuthorizationContext authCtx) {
        return authCtx.may(Role.manage((String)authCtx.getTenantId().toString()));
    }

    private boolean mayExportUsers(AuthorizationContext authCtx) {
        return authCtx.may(Role.exportApp((CoreApp)CoreApp.PEOPLE, (UUID)((UUID)authCtx.getTenantId().getId())));
    }

    @PostMapping(path={"/link"})
    @Operation(summary="Creates a link pointing to an external resource")
    @NotNull
    public ExternalLinkId createExternalLink(@NotNull AuthorizationContext authCtx, @RequestBody @NotNull CreateLinkDto createLinkDto) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)createLinkDto, (String)"createLinkDto");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        return this.configApplicationService.createExternalLink(tenantId, createLinkDto, authCtx);
    }

    @GetMapping(path={"/links"})
    @Operation(summary="List all configured external links on a tenant")
    @NotNull
    public List<ExternalLinkConfig> getExternalLinks(@NotNull AuthorizationContext authCtx) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        return this.configApplicationService.getExternalLinks(tenantId, authCtx);
    }

    @DeleteMapping(path={"/links"})
    @Operation(summary="Delete all the given external links on the given tenant")
    public void deleteExternalLinks(@NotNull AuthorizationContext authCtx, @RequestBody @NotNull List<ExternalLinkId> linkIds) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter(linkIds, (String)"linkIds");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        this.configApplicationService.deleteExternalLinks(tenantId, linkIds, authCtx);
    }
}

