/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config.search;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class SolrClientConfiguration {
    private final Logger _log = LoggerFactory.getLogger(this.getClass());
    private final SolrClient _solrClient;

    public SolrClientConfiguration(@Value(value="${SOLR.writePeopleUrl}") String solrUrl) {
        this._log.info("solrUrl: " + solrUrl);
        this._solrClient = new HttpSolrClient.Builder(solrUrl).build();
    }

    @Nonnull
    @Bean
    public SolrClient getSolrClient() {
        return this._solrClient;
    }
}

