/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import com.google.common.base.Enums;
import de.justsoftware.people.business.profile.AttributeNameValidator;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfigKafkaModel;
import de.justsoftware.people.business.search.model.SearchField;
import de.justsoftware.people.utils.KafkaUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eH\u0011\u00a2\u0006\u0002\b\u0011J\u0013\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013H\u0016J\u0013\u0010\u0016\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013H\u0016J\u001b\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00150\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016R6\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;", "Lde/justsoftware/people/business/profile/AttributeNameValidator;", "<init>", "()V", "value", "", "", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfig;", "configuration", "getConfiguration", "()Ljava/util/Map;", "listen", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfigKafkaModel;", "listen$people_api", "searchFields", "", "Lde/justsoftware/people/business/search/model/SearchField;", "Lkotlin/jvm/internal/EnhancedNullability;", "facetableFields", "configFor", "Ljava/util/Optional;", "searchField", "attributeNamesAreValid", "", "attributeNames", "attributeNameIsValid", "attributeName", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileAttributeConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileAttributeConfigService.kt\nde/justsoftware/people/business/profile/ProfileAttributeConfigService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n8443#2,2:115\n9125#2,4:117\n774#3:121\n865#3,2:122\n1557#3:124\n1628#3,3:125\n774#3:128\n865#3,2:129\n1557#3:131\n1628#3,3:132\n774#3:135\n865#3,2:136\n1557#3:138\n1628#3,3:139\n774#3:142\n865#3,2:143\n1557#3:145\n1628#3,3:146\n*S KotlinDebug\n*F\n+ 1 ProfileAttributeConfigService.kt\nde/justsoftware/people/business/profile/ProfileAttributeConfigService\n*L\n31#1:115,2\n31#1:117,4\n77#1:121\n77#1:122,2\n78#1:124\n78#1:125,3\n79#1:128\n79#1:129,2\n80#1:131\n80#1:132,3\n87#1:135\n87#1:136,2\n88#1:138\n88#1:139,3\n89#1:142\n89#1:143,2\n90#1:145\n90#1:146,3\n*E\n"})
public class ProfileAttributeConfigService
implements AttributeNameValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, ? extends ProfileAttributeConfig> configuration = MapsKt.emptyMap();
    @NotNull
    public static final String TOPIC = "just.persons.profileAttributesConfig";
    @NotNull
    private static final String DEFAULT_CONFIG_KEY = "DEFAULT";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileAttributeConfigService.class);

    @NotNull
    public final Map<String, ProfileAttributeConfig> getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(containerFactory="profileAttributeConfigurationListenerContainerFactory", topics={"just.persons.profileAttributesConfig"})
    public void listen$people_api(@NotNull ConsumerRecords<String, ProfileAttributeConfigKafkaModel[]> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        for (ConsumerRecord record : KafkaUtilsKt.filterAndLogDeserializationErrors(records)) {
            try {
                void $this$associateTo$iv$iv;
                if (!Intrinsics.areEqual((Object)DEFAULT_CONFIG_KEY, (Object)record.key())) continue;
                Object object = record.value();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
                Object[] $this$associate$iv = (Object[])object;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
                Object[] objectArray = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (void element$iv$iv : $this$associateTo$iv$iv) {
                    SearchField searchField;
                    Map map = destination$iv$iv;
                    ProfileAttributeConfigKafkaModel it = (ProfileAttributeConfigKafkaModel)element$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    ProfileAttributeConfig.AttributeType attributeType = (ProfileAttributeConfig.AttributeType)Enums.getIfPresent(ProfileAttributeConfig.AttributeType.class, (String)it.getType()).or((Object)ProfileAttributeConfig.AttributeType.UNKNOWN);
                    String string2 = it.getName();
                    boolean bl2 = it.isVisibleOnBadge();
                    boolean bl3 = it.isSearchable();
                    boolean bl4 = it.isFacetable();
                    boolean bl5 = it.isClickable();
                    boolean bl6 = it.isPhoneNumber();
                    if (it.isSearchable()) {
                        String string3 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                        searchField = SearchField.Companion.dynamic(string3, it.isPhoneNumber(), it.isSearchable());
                    } else {
                        searchField = null;
                    }
                    Pair pair = TuplesKt.to((Object)string, (Object)new ProfileAttributeConfig(attributeType, string2, bl2, bl3, bl4, bl5, bl6, searchField, it.getTranslatedValues()));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map newConfig = MapsKt.toMutableMap((Map)destination$iv$iv);
                newConfig.put(ProfileAttributeConfig.FIRST_NAME.getName(), ProfileAttributeConfig.FIRST_NAME);
                newConfig.put(ProfileAttributeConfig.LAST_NAME.getName(), ProfileAttributeConfig.LAST_NAME);
                newConfig.put(ProfileAttributeConfig.TITLE.getName(), ProfileAttributeConfig.TITLE);
                newConfig.put(ProfileAttributeConfig.ADDITIONAL_TITLE.getName(), ProfileAttributeConfig.ADDITIONAL_TITLE);
                this.configuration = MapsKt.toMap((Map)newConfig);
            }
            catch (RuntimeException e) {
                Object[] objectArray = new Object[]{record.key(), record.value(), e.getMessage()};
                LOG.error("Failed to process profile attribute config record with {} = {} - {}", objectArray);
            }
        }
    }

    @NotNull
    public List<SearchField> searchFields() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.configuration.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProfileAttributeConfig)element$iv$iv;
            boolean bl = false;
            if (!it.isSearchable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProfileAttributeConfig)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchField());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Optional)element$iv$iv;
            boolean bl = false;
            if (!((Optional)it).isPresent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Optional)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchField)((Optional)it).get());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<SearchField> facetableFields() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.configuration.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProfileAttributeConfig)element$iv$iv;
            boolean bl = false;
            if (!it.isFacetable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProfileAttributeConfig)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchField());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Optional)element$iv$iv;
            boolean bl = false;
            if (!((Optional)it).isPresent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Optional)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchField)((Optional)it).get());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Optional<ProfileAttributeConfig> configFor(@NotNull SearchField searchField) {
        Intrinsics.checkNotNullParameter((Object)searchField, (String)"searchField");
        Optional<ProfileAttributeConfig> optional = Optional.ofNullable(this.configuration.get(searchField.getAttributeName()));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public boolean attributeNamesAreValid(@NotNull List<String> attributeNames) {
        Intrinsics.checkNotNullParameter(attributeNames, (String)"attributeNames");
        return this.configuration.keySet().containsAll((Collection)attributeNames);
    }

    public boolean attributeNameIsValid(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return this.configuration.containsKey(attributeName);
    }
}

