/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.notificationservice.business.JunoRestClientService;
import de.justsoftware.notificationservice.business.MobilePushNotificationSendService;
import de.justsoftware.notificationservice.business.MobilePushTokenService;
import de.justsoftware.notificationservice.business.ScheduledMobilePushNotificationStore;
import de.justsoftware.notificationservice.model.MobilePushNotification;
import de.justsoftware.notificationservice.model.ScheduledMobilePushNotification;
import de.justsoftware.notificationservice.util.JunoUtilKt;
import de.justsoftware.notificationservice.util.TaskSchedulerUtilKt;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.TaskScheduler;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0002\"#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\r\u0010\u001b\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u001cJ\u0014\u0010\u001d\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017J\u0016\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/notificationservice/business/MobilePushNotificationSendService;", "", "mobilePushTokenService", "Lde/justsoftware/notificationservice/business/MobilePushTokenService;", "mobilePushTokeStore", "Lde/justsoftware/notificationservice/business/ScheduledMobilePushNotificationStore;", "junoClient", "Lde/justsoftware/notificationservice/business/JunoRestClientService;", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/notificationservice/business/MobilePushTokenService;Lde/justsoftware/notificationservice/business/ScheduledMobilePushNotificationStore;Lde/justsoftware/notificationservice/business/JunoRestClientService;Lorg/springframework/scheduling/TaskScheduler;Ljava/time/Clock;)V", "batchSize", "", "applySendResult", "", "result", "Lde/justsoftware/notificationservice/business/MobilePushNotificationSendService$SendResult;", "logJunoClientErrors", "error", "", "scheduledPushes", "", "Lde/justsoftware/notificationservice/model/ScheduledMobilePushNotification;", "durationMs", "", "process", "process$notification_service", "sendAll", "pushNotifications", "Lde/justsoftware/notificationservice/model/MobilePushNotification;", "sendToJuno", "scheduledPushNotifications", "Companion", "SendResult", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushNotificationSendService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushNotificationSendService.kt\nde/justsoftware/notificationservice/business/MobilePushNotificationSendService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1549#2:148\n1620#2,3:149\n1549#2:154\n1620#2,3:155\n1549#2:158\n1620#2,3:159\n1549#2:163\n1620#2,3:164\n3190#2,10:167\n1549#2:177\n1620#2,3:178\n1313#3,2:152\n1#4:162\n*S KotlinDebug\n*F\n+ 1 MobilePushNotificationSendService.kt\nde/justsoftware/notificationservice/business/MobilePushNotificationSendService\n*L\n38#1:148\n38#1:149,3\n53#1:154\n53#1:155,3\n54#1:158\n54#1:159,3\n79#1:163\n79#1:164,3\n82#1:167,10\n84#1:177\n84#1:178,3\n47#1:152,2\n*E\n"})
public final class MobilePushNotificationSendService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final ScheduledMobilePushNotificationStore mobilePushTokeStore;
    @NotNull
    private final JunoRestClientService junoClient;
    @NotNull
    private final Clock clock;
    private int batchSize;
    private static final Duration PROCESS_RATE = Duration.ofSeconds(5L);
    private static final Duration SCHEDULED_PUSH_TTL = Duration.ofHours(2L);
    private static final int EXPONENTIAL_DELAY_MS = 30000;
    private static final Logger LOG = LoggerFactory.getLogger(MobilePushNotificationSendService.class);

    public MobilePushNotificationSendService(@NotNull MobilePushTokenService mobilePushTokenService, @NotNull ScheduledMobilePushNotificationStore mobilePushTokeStore, @NotNull JunoRestClientService junoClient, @NotNull TaskScheduler taskScheduler, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)mobilePushTokeStore, (String)"mobilePushTokeStore");
        Intrinsics.checkNotNullParameter((Object)junoClient, (String)"junoClient");
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.mobilePushTokenService = mobilePushTokenService;
        this.mobilePushTokeStore = mobilePushTokeStore;
        this.junoClient = junoClient;
        this.clock = clock;
        this.batchSize = 50;
        Duration duration = PROCESS_RATE;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"PROCESS_RATE");
        TaskSchedulerUtilKt.scheduleAtFixedRateAndSkipMissed((TaskScheduler)taskScheduler, (Duration)duration, () -> this.process$notification_service());
    }

    /*
     * WARNING - void declaration
     */
    public final void sendAll(@NotNull List<MobilePushNotification> pushNotifications) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(pushNotifications, (String)"pushNotifications");
        Instant now = this.clock.instant();
        Iterable iterable = pushNotifications;
        ScheduledMobilePushNotificationStore scheduledMobilePushNotificationStore = this.mobilePushTokeStore;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushNotification mobilePushNotification = (MobilePushNotification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)now);
            collection.add(Companion.access$schedule((Companion)Companion, (MobilePushNotification)it, (Instant)now));
        }
        scheduledMobilePushNotificationStore.saveAll((List)destination$iv$iv);
    }

    @VisibleForTesting
    public final void process$notification_service() {
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)this.mobilePushTokeStore.findDue(instant), (int)this.batchSize), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SendResult p0 = (SendResult)element$iv;
            boolean bl = false;
            this.applySendResult(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SendResult sendToJuno(List<ScheduledMobilePushNotification> scheduledPushNotifications) {
        Object object;
        Object p0;
        MobilePushNotification p02;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        long startTimeMs = 0L;
        Object object2 = scheduledPushNotifications;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScheduledMobilePushNotification scheduledMobilePushNotification = (ScheduledMobilePushNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p02.getMobilePushNotification());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p02 = (MobilePushNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JunoUtilKt.toJunoPushNotification((MobilePushNotification)p02));
        }
        object2 = (List)destination$iv$iv;
        Iterable $i$f$map2 = object2;
        boolean bl = false;
        startTimeMs = System.currentTimeMillis();
        Object it = this.junoClient;
        try {
            p0 = object2;
            boolean bl2 = false;
            p0 = Result.constructor-impl((Object)it.sendPushNotifications((List)p0));
        }
        catch (Throwable bl2) {
            p0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        Companion companion2 = companion;
        object2 = p0;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            void e;
            it = throwable;
            p0 = it;
            companion = companion2;
            boolean bl3 = false;
            long durationMs = System.currentTimeMillis() - startTimeMs;
            this.logJunoClientErrors((Throwable)e, scheduledPushNotifications, durationMs);
            companion2 = companion;
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            it = throwable2;
            companion = companion2;
            boolean bl4 = false;
            object = JunoUtilKt.toFailedPushNotificationResults(scheduledPushNotifications, (int)this.batchSize);
            companion2 = companion;
        }
        return Companion.access$toSendResult((Companion)companion2, (PushNotificationResults)((PushNotificationResults)object), scheduledPushNotifications);
    }

    private final void logJunoClientErrors(Throwable error, List<ScheduledMobilePushNotification> scheduledPushes, long durationMs) {
        LOG.error("Error while sending " + scheduledPushes.size() + " push notifications to juno (after " + durationMs + "ms)", error);
    }

    /*
     * WARNING - void declaration
     */
    private final void applySendResult(SendResult result) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ScheduledMobilePushNotification it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        this.mobilePushTokeStore.deleteAll(Companion.access$toIds((Companion)Companion, (List)result.getSuccessfulScheduledPushes()));
        this.mobilePushTokeStore.deleteAll(Companion.access$toIds((Companion)Companion, (List)result.getInvalidScheduledPushes()));
        Iterable iterable = result.getInvalidScheduledPushes();
        MobilePushTokenService mobilePushTokenService = this.mobilePushTokenService;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            ScheduledMobilePushNotification scheduledMobilePushNotification = (ScheduledMobilePushNotification)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Companion.access$toTokenId((Companion)Companion, (ScheduledMobilePushNotification)it));
        }
        mobilePushTokenService.deletePushTokens((Collection)((List)destination$iv$iv));
        Iterable $this$partition$iv = result.getFailedScheduledPushes();
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (ScheduledMobilePushNotification)element$iv;
            boolean bl = false;
            if (Companion.access$shouldRetry((Companion)Companion, (ScheduledMobilePushNotification)it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        iterable = new Pair(first$iv, second$iv);
        List failedPushNotificationsToRetry = (List)iterable.component1();
        List failedPushNotificationsToAbandon = (List)iterable.component2();
        this.mobilePushTokeStore.deleteAll(Companion.access$toIds((Companion)Companion, (List)failedPushNotificationsToAbandon));
        first$iv = failedPushNotificationsToRetry;
        mobilePushTokenService = this.mobilePushTokeStore;
        boolean $i$f$map2 = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ScheduledMobilePushNotification scheduledMobilePushNotification = (ScheduledMobilePushNotification)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(Companion.access$scheduleRetry((Companion)Companion, (ScheduledMobilePushNotification)it2));
        }
        mobilePushTokenService.saveAll((List)destination$iv$iv2);
        this.batchSize = result.getNextBatchSize();
    }

    public static final /* synthetic */ SendResult access$sendToJuno(MobilePushNotificationSendService $this, List scheduledPushNotifications) {
        return $this.sendToJuno(scheduledPushNotifications);
    }

    public static final /* synthetic */ Duration access$getSCHEDULED_PUSH_TTL$cp() {
        return SCHEDULED_PUSH_TTL;
    }
}

