/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice;

import de.justsoftware.notificationservice.ExceptionHandlerConfiguration;
import de.justsoftware.notificationservice.exception.NotFoundException;
import de.justsoftware.notificationservice.exception.UnauthorizedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Configuration
@ControllerAdvice
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\tH\u0017\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/notificationservice/ExceptionHandlerConfiguration;", "", "()V", "handleAllExceptions", "", "handleNotFoundException", "e", "Lde/justsoftware/notificationservice/exception/NotFoundException;", "handleUnauthorizedException", "Lde/justsoftware/notificationservice/exception/UnauthorizedException;", "Companion", "notification-service"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public String handleAllExceptions() {
        return DEFAULT_ERROR;
    }

    @ExceptionHandler(value={NotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    @Nullable
    public String handleNotFoundException(@NotNull NotFoundException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @Nullable
    public String handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }
}

