/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search.update;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleCreatedEvent;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleUpdatedEvent;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.model.WikiPermissionModifiedEvent;
import de.justsoftware.wikiservice.search.update.UpdateSearchIndexProducer;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 $2\u00020\u0001:\u0001$B-\b\u0007\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0017J\u0016\u0010\u0017\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0012J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0012J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "<init>", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/wikiservice/business/AncestorService;Lde/justsoftware/search/shared/SolrIndexQueue;)V", "handleWikiModified", "", "evt", "Lde/justsoftware/wikiservice/model/WikiModifiedEvent;", "handleArticleCreated", "Lde/justsoftware/wikiservice/model/ArticleCreatedEvent;", "handleArticleUpdated", "Lde/justsoftware/wikiservice/model/ArticleUpdatedEvent;", "handleChapterModified", "Lde/justsoftware/wikiservice/model/ChapterModifiedEvent;", "handleWikiPermissionModified", "Lde/justsoftware/wikiservice/model/WikiPermissionModifiedEvent;", "reindex", "ids", "", "Lde/justsoftware/wikiservice/model/AbstractId;", "send", "id", "queueFullIndex", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nUpdateSearchIndexProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateSearchIndexProducer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1863#2,2:99\n1863#2,2:101\n*S KotlinDebug\n*F\n+ 1 UpdateSearchIndexProducer.kt\nde/justsoftware/wikiservice/search/update/UpdateSearchIndexProducer\n*L\n60#1:99,2\n67#1:101,2\n*E\n"})
public class UpdateSearchIndexProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;
    @NotNull
    public static final String TOPIC = "just.wiki-service.search.updateIndex";

    @Autowired
    public UpdateSearchIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull AncestorService ancestorService, @NotNull SolrIndexQueue solrIndexQueue) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        this.kafkaProducer = kafkaProducer;
        this.ancestorService = ancestorService;
        this.solrIndexQueue = solrIndexQueue;
    }

    @Async
    @EventListener
    public void handleWikiModified(@NotNull WikiModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.queueFullIndex(evt.getId());
    }

    @Async
    @EventListener
    public void handleArticleCreated(@NotNull ArticleCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.queueFullIndex(evt.getId());
    }

    @Async
    @EventListener
    public void handleArticleUpdated(@NotNull ArticleUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.queueFullIndex(evt.getId());
    }

    @Async
    @EventListener
    public void handleChapterModified(@NotNull ChapterModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send((AbstractId)evt.getId());
        this.queueFullIndex(evt.getId());
    }

    @Async
    @EventListener
    public void handleWikiPermissionModified(@NotNull WikiPermissionModifiedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = SetsKt.plus((Set)this.ancestorService.getDescendants(evt.getId()), (Object)evt.getId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractId it = (AbstractId)element$iv;
            boolean bl = false;
            this.send(it);
        }
        this.queueFullIndex(evt.getId());
    }

    public void reindex(@NotNull Set<? extends AbstractId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractId it = (AbstractId)element$iv;
            boolean bl = false;
            this.send(it);
        }
    }

    private void send(AbstractId id) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)id.toString(), (Object)id.toString()));
    }

    private void queueFullIndex(WikiId wikiId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)wikiId))), SearchType.WIKI_WIKI);
    }

    private void queueFullIndex(ChapterId chapterId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)chapterId))), SearchType.WIKI_CHAPTER);
    }

    private void queueFullIndex(ArticleId articleId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)IdUtilsKt.toSearchableId((AbstractId)((AbstractId)articleId))), SearchType.WIKI_ARTICLE);
    }
}

