/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.search;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.search.shared.DefaultSolrIndexDataLoader;
import de.justsoftware.search.shared.LoaderContext;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.JustApp;
import de.justsoftware.search.shared.model.JustSocialFullUpdateSolrDocument;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.TenantId;
import de.justsoftware.wikiservice.application.model.ArticleDto;
import de.justsoftware.wikiservice.application.model.ChapterDto;
import de.justsoftware.wikiservice.application.model.WikiDto;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.ChapterService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.search.WikiSolrIndexDataLoader;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&BK\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J,\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0017J \u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$2\u0006\u0010%\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/wikiservice/search/WikiSolrIndexDataLoader;", "Lde/justsoftware/search/shared/DefaultSolrIndexDataLoader;", "justVersion", "", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "chapterService", "Lde/justsoftware/wikiservice/business/ChapterService;", "articleService", "Lde/justsoftware/wikiservice/business/ArticleService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "<init>", "(Ljava/lang/String;Lde/justsoftware/search/shared/SolrIndexQueue;Lde/justsoftware/wikiservice/business/WikiService;Lde/justsoftware/wikiservice/business/ChapterService;Lde/justsoftware/wikiservice/business/ArticleService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Ljava/time/Clock;J)V", "loadFullData", "", "Lde/justsoftware/search/shared/model/SearchableId;", "Lde/justsoftware/search/shared/model/JustSocialFullUpdateSolrDocument;", "ids", "", "context", "Lde/justsoftware/search/shared/LoaderContext;", "handleReindexForTypes", "", "types", "", "Lde/justsoftware/search/shared/model/SearchType;", "tenantId", "Lde/justsoftware/search/shared/model/TenantId;", "getAllSearchableIdForType", "Ljava/util/stream/Stream;", "type", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nWikiSolrIndexDataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiSolrIndexDataLoader.kt\nde/justsoftware/wikiservice/search/WikiSolrIndexDataLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,141:1\n1557#2:142\n1628#2,3:143\n1246#2,4:148\n1246#2,4:154\n1557#2:158\n1628#2,3:159\n1557#2:162\n1628#2,3:163\n1557#2:166\n1628#2,3:167\n1557#2:170\n1628#2,3:171\n1202#2,2:174\n1230#2,4:176\n1279#2,2:180\n1293#2,4:182\n462#3:146\n412#3:147\n462#3:152\n412#3:153\n*S KotlinDebug\n*F\n+ 1 WikiSolrIndexDataLoader.kt\nde/justsoftware/wikiservice/search/WikiSolrIndexDataLoader\n*L\n50#1:142\n50#1:143,3\n61#1:148,4\n68#1:154,4\n71#1:158\n71#1:159,3\n74#1:162\n74#1:163,3\n75#1:166\n75#1:167,3\n76#1:170\n76#1:171,3\n77#1:174,2\n77#1:176,4\n79#1:180,2\n79#1:182,4\n61#1:146\n61#1:147\n68#1:152\n68#1:153\n*E\n"})
public class WikiSolrIndexDataLoader
extends DefaultSolrIndexDataLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String justVersion;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ChapterService chapterService;
    @NotNull
    private final ArticleService articleService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;

    public WikiSolrIndexDataLoader(@Value(value="${just.version}") @NotNull String justVersion, @NotNull SolrIndexQueue solrIndexQueue, @NotNull WikiService wikiService, @NotNull ChapterService chapterService, @NotNull ArticleService articleService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration) {
        Intrinsics.checkNotNullParameter((Object)justVersion, (String)"justVersion");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)chapterService, (String)"chapterService");
        Intrinsics.checkNotNullParameter((Object)articleService, (String)"articleService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(JustApp.WIKI, justVersion, solrIndexQueue);
        this.justVersion = justVersion;
        this.wikiService = wikiService;
        this.chapterService = chapterService;
        this.articleService = articleService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<SearchableId, JustSocialFullUpdateSolrDocument> loadFullData(@NotNull List<SearchableId> ids, @NotNull LoaderContext context) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        ArticleDto articleDto;
        Object v;
        Object object;
        Object object2;
        Map $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        void it;
        Object object3;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv2 = ids;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            SearchableId searchableId = (SearchableId)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object3.add(IdUtilsKt.toAbstractId((SearchableId)it));
        }
        List abstractIds = (List)destination$iv$iv;
        Set wikiIds = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)abstractIds, WikiId.class));
        Set chapterIds = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)abstractIds, ChapterId.class));
        Set articleIds = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)abstractIds, ArticleId.class));
        if (wikiIds.isEmpty() && chapterIds.isEmpty() && articleIds.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map articleVersions = this.articleService.getLatestArticleVersions(articleIds);
        Map map = this.articleService.readByIds(articleIds);
        boolean $i$f$mapValues = false;
        it = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            ArticleVersion version;
            Iterator it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            object2 = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            object3 = map2;
            boolean bl2 = false;
            v = (Article)object2.getValue();
            if ((ArticleVersion)articleVersions.get(v.getId()) == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            articleDto = ArticleDto.Companion.toDto(v, version, this.clock, this.maxEditingTokenDuration);
            object3.put(object, articleDto);
        }
        Map articles = destination$iv$iv2;
        Map chapters = this.chapterService.readByIds(chapterIds);
        $this$mapValuesTo$iv$iv2 = this.wikiService.readByIds(wikiIds);
        boolean $i$f$mapValues2 = false;
        void $i$f$mapValuesTo22 = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo32 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it2;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv3;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            v = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            object3 = object2;
            boolean bl3 = false;
            articleDto = WikiDto.Companion.toDto((Wiki)it2.getValue());
            object3.put(object, articleDto);
        }
        Map wikis = destination$iv$iv3;
        $this$mapValuesTo$iv$iv = wikiIds;
        object3 = this.permissionRequestConnector;
        boolean $i$f$map2 = false;
        void $i$f$mapValuesTo32 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            WikiId it$iv$iv = (WikiId)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            object.add((String)it3.toString());
        }
        ImmutableSetMultimap immutableSetMultimap = object3.visibility((Iterable)((List)destination$iv$iv4));
        Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"visibility(...)");
        ImmutableSetMultimap permissions = immutableSetMultimap;
        $this$map$iv = wikis.values();
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WikiDto it3 = (WikiDto)item$iv$iv;
            object3 = destination$iv$iv4;
            boolean bl = false;
            ImmutableSet immutableSet = permissions.get((Object)it3.getId().toString());
            Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"get(...)");
            object3.add(Companion.access$toSolrDocument((Companion)Companion, (WikiDto)it3, (Set)((Set)immutableSet)));
        }
        $this$map$iv = chapters.values();
        object3 = (List)destination$iv$iv4;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChapterDto it4 = (ChapterDto)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            object.add(Companion.access$toSolrDocument((Companion)Companion, (ChapterDto)it4));
        }
        $this$map$iv = articles.values();
        object3 = CollectionsKt.plus((Collection)object3, (Iterable)((List)destination$iv$iv4));
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleDto it5 = (ArticleDto)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            object.add(Companion.access$toSolrDocument((Companion)Companion, (ArticleDto)it5));
        }
        $this$map$iv = CollectionsKt.plus((Collection)object3, (Iterable)((List)destination$iv$iv4));
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv4 = $this$associateBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo3 = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it6;
            JustSocialFullUpdateSolrDocument bl = (JustSocialFullUpdateSolrDocument)element$iv$iv2;
            object3 = destination$iv$iv5;
            boolean bl4 = false;
            object3.put(it6.getId(), element$iv$iv2);
        }
        Map documents = destination$iv$iv5;
        Iterable $this$associateWith$iv = ids;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void id;
            SearchableId element$iv$iv2 = (SearchableId)element$iv$iv;
            object = element$iv$iv;
            object3 = result$iv;
            boolean bl = false;
            articleDto = (JustSocialFullUpdateSolrDocument)documents.get(id);
            object3.put(object, articleDto);
        }
        return result$iv;
    }

    @Transactional(readOnly=true)
    public void handleReindexForTypes(@NotNull Set<? extends SearchType> types, @Nullable TenantId tenantId) {
        Intrinsics.checkNotNullParameter(types, (String)"types");
        super.handleReindexForTypes(types, tenantId);
    }

    @NotNull
    protected Stream<SearchableId> getAllSearchableIdForType(@NotNull SearchType type, @Nullable TenantId tenantId) {
        Stream<SearchableId> stream;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Stream<SearchableId> stream2 = this.wikiService.streamAllIds().map(arg_0 -> WikiSolrIndexDataLoader.getAllSearchableIdForType$lambda$10(WikiSolrIndexDataLoader::getAllSearchableIdForType$lambda$9, arg_0));
                stream = stream2;
                Intrinsics.checkNotNullExpressionValue(stream2, (String)"map(...)");
                break;
            }
            case 2: {
                Stream<SearchableId> stream3 = this.chapterService.streamAllIds().map(arg_0 -> WikiSolrIndexDataLoader.getAllSearchableIdForType$lambda$12(WikiSolrIndexDataLoader::getAllSearchableIdForType$lambda$11, arg_0));
                stream = stream3;
                Intrinsics.checkNotNullExpressionValue(stream3, (String)"map(...)");
                break;
            }
            case 3: {
                Stream<SearchableId> stream4 = this.articleService.streamAllIds().map(arg_0 -> WikiSolrIndexDataLoader.getAllSearchableIdForType$lambda$14(WikiSolrIndexDataLoader::getAllSearchableIdForType$lambda$13, arg_0));
                stream = stream4;
                Intrinsics.checkNotNullExpressionValue(stream4, (String)"map(...)");
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported searchType " + type + " for " + this.handlerTypes()).toString());
            }
        }
        return stream;
    }

    private static final SearchableId getAllSearchableIdForType$lambda$9(WikiId it) {
        Intrinsics.checkNotNull((Object)it);
        return IdUtilsKt.toSearchableId((AbstractId)((AbstractId)it));
    }

    private static final SearchableId getAllSearchableIdForType$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SearchableId)$tmp0.invoke(p0);
    }

    private static final SearchableId getAllSearchableIdForType$lambda$11(ChapterId it) {
        Intrinsics.checkNotNull((Object)it);
        return IdUtilsKt.toSearchableId((AbstractId)((AbstractId)it));
    }

    private static final SearchableId getAllSearchableIdForType$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SearchableId)$tmp0.invoke(p0);
    }

    private static final SearchableId getAllSearchableIdForType$lambda$13(ArticleId it) {
        Intrinsics.checkNotNull((Object)it);
        return IdUtilsKt.toSearchableId((AbstractId)((AbstractId)it));
    }

    private static final SearchableId getAllSearchableIdForType$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SearchableId)$tmp0.invoke(p0);
    }
}

