/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import de.justsoftware.wikiservice.application.model.GroupGranteeDto;
import de.justsoftware.wikiservice.application.model.ProfileGranteeDto;
import de.justsoftware.wikiservice.business.model.TableOfContentsArticle;
import de.justsoftware.wikiservice.business.model.TableOfContentsChapter;
import de.justsoftware.wikiservice.graphql.GraphQLScalar;
import de.justsoftware.wikiservice.graphql.SimpleComplexityCalculator;
import de.justsoftware.wikiservice.graphql.error.CustomGraphQLErrorHandler;
import de.justsoftware.wikiservice.graphql.fetchers.AncestorFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.ArticleFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.ChapterFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.GlobalUserInfoFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.PermissionFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.ProfileInfoFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.SubscriptionFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.TableOfContentsFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.UserInfoFetcher;
import de.justsoftware.wikiservice.graphql.fetchers.WikiFetcher;
import de.justsoftware.wikiservice.graphql.generated.PermissionType;
import de.justsoftware.wikiservice.graphql.generated.WikiOverviewDirection;
import de.justsoftware.wikiservice.graphql.generated.WikiOverviewDisplay;
import de.justsoftware.wikiservice.graphql.generated.WikiOverviewSort;
import graphql.GraphQL;
import graphql.TypeResolutionEnvironment;
import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.analysis.MaxQueryDepthInstrumentation;
import graphql.execution.DataFetcherResult;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.scalars.ExtendedScalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.EnumValuesProvider;
import graphql.schema.idl.NaturalEnumValuesProvider;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001Bu\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0001\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0001\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\b\u0010%\u001a\u00020&H\u0017J\b\u0010'\u001a\u00020(H\u0017J\u0010\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020&H\u0017J\u0010\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0012J\"\u0010.\u001a\u00020/2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020301\u00a2\u0006\u0002\b4H\u0092\bJ.\u00105\u001a\u000202*\u0002022\u0006\u00106\u001a\u00020-2\u0017\u00100\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020301\u00a2\u0006\u0002\b4H\u0092\bJ\b\u0010E\u001a\u00020/H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u001e8\u0016@\u0016X\u0097.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$Rn\u00108\u001a\\\u0012X\u0012V\u0012$\u0012\"\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0001 <*\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0001\u0018\u00010;0; <**\u0012$\u0012\"\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0001 <*\u0010\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u0001\u0018\u00010;0;\u0018\u00010:0:09X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0014\u0010?\u001a\u00020@X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020@X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010B\u00a8\u0006F"}, d2={"Lde/justsoftware/wikiservice/graphql/GraphQLProvider;", "", "wikiFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/WikiFetcher;", "tableOfContentsFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/TableOfContentsFetcher;", "articleFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/ArticleFetcher;", "chapterFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/ChapterFetcher;", "ancestorFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/AncestorFetcher;", "permissionFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/PermissionFetcher;", "subscriptionFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/SubscriptionFetcher;", "userInfoFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/UserInfoFetcher;", "profileInfoFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/ProfileInfoFetcher;", "globalUserInfoFetcher", "Lde/justsoftware/wikiservice/graphql/fetchers/GlobalUserInfoFetcher;", "simpleComplexityCalculator", "Lde/justsoftware/wikiservice/graphql/SimpleComplexityCalculator;", "maxQueryDepth", "", "maxQueryComplexity", "<init>", "(Lde/justsoftware/wikiservice/graphql/fetchers/WikiFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/TableOfContentsFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/ArticleFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/ChapterFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/AncestorFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/PermissionFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/SubscriptionFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/UserInfoFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/ProfileInfoFetcher;Lde/justsoftware/wikiservice/graphql/fetchers/GlobalUserInfoFetcher;Lde/justsoftware/wikiservice/graphql/SimpleComplexityCalculator;II)V", "graphQL", "Lgraphql/GraphQL;", "getGraphQL$annotations", "()V", "getGraphQL", "()Lgraphql/GraphQL;", "setGraphQL", "(Lgraphql/GraphQL;)V", "instrumentation", "Lgraphql/execution/instrumentation/Instrumentation;", "graphQLErrorHandler", "Lgraphql/kickstart/execution/error/GraphQLErrorHandler;", "schema", "Lgraphql/schema/GraphQLSchema;", "buildSchema", "sdl", "", "newRuntimeWiring", "Lgraphql/schema/idl/RuntimeWiring;", "block", "Lkotlin/Function1;", "Lgraphql/schema/idl/RuntimeWiring$Builder;", "", "Lkotlin/ExtensionFunctionType;", "addType", "typeName", "Lgraphql/schema/idl/TypeRuntimeWiring$Builder;", "genericFetcher", "Lgraphql/schema/DataFetcher;", "Lgraphql/execution/DataFetcherResult;", "", "kotlin.jvm.PlatformType", "getGenericFetcher", "()Lgraphql/schema/DataFetcher;", "tableOfContentsElementResolver", "Lgraphql/schema/TypeResolver;", "getTableOfContentsElementResolver", "()Lgraphql/schema/TypeResolver;", "granteeResolver", "getGranteeResolver", "buildWiring", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nGraphQLProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphQLProvider.kt\nde/justsoftware/wikiservice/graphql/GraphQLProvider\n*L\n1#1,251:1\n107#1:252\n112#1:253\n112#1:254\n112#1:255\n112#1:256\n112#1:257\n112#1:258\n112#1:259\n112#1:260\n112#1:261\n112#1:262\n112#1:263\n112#1:264\n112#1:265\n112#1:266\n112#1:267\n*S KotlinDebug\n*F\n+ 1 GraphQLProvider.kt\nde/justsoftware/wikiservice/graphql/GraphQLProvider\n*L\n146#1:252\n147#1:253\n158#1:254\n174#1:255\n186#1:256\n195#1:257\n200#1:258\n204#1:259\n213#1:260\n217#1:261\n220#1:262\n223#1:263\n226#1:264\n229#1:265\n232#1:266\n235#1:267\n*E\n"})
public class GraphQLProvider {
    @NotNull
    private final WikiFetcher wikiFetcher;
    @NotNull
    private final TableOfContentsFetcher tableOfContentsFetcher;
    @NotNull
    private final ArticleFetcher articleFetcher;
    @NotNull
    private final ChapterFetcher chapterFetcher;
    @NotNull
    private final AncestorFetcher ancestorFetcher;
    @NotNull
    private final PermissionFetcher permissionFetcher;
    @NotNull
    private final SubscriptionFetcher subscriptionFetcher;
    @NotNull
    private final UserInfoFetcher userInfoFetcher;
    @NotNull
    private final ProfileInfoFetcher profileInfoFetcher;
    @NotNull
    private final GlobalUserInfoFetcher globalUserInfoFetcher;
    @NotNull
    private final SimpleComplexityCalculator simpleComplexityCalculator;
    private final int maxQueryDepth;
    private final int maxQueryComplexity;
    public GraphQL graphQL;
    @NotNull
    private final DataFetcher<DataFetcherResult<Map<String, Object>>> genericFetcher;
    @NotNull
    private final TypeResolver tableOfContentsElementResolver;
    @NotNull
    private final TypeResolver granteeResolver;

    @Autowired
    public GraphQLProvider(@NotNull WikiFetcher wikiFetcher, @NotNull TableOfContentsFetcher tableOfContentsFetcher, @NotNull ArticleFetcher articleFetcher, @NotNull ChapterFetcher chapterFetcher, @NotNull AncestorFetcher ancestorFetcher, @NotNull PermissionFetcher permissionFetcher, @NotNull SubscriptionFetcher subscriptionFetcher, @NotNull UserInfoFetcher userInfoFetcher, @NotNull ProfileInfoFetcher profileInfoFetcher, @NotNull GlobalUserInfoFetcher globalUserInfoFetcher, @NotNull SimpleComplexityCalculator simpleComplexityCalculator, @Value(value="${service.graphql.maxQueryDepth:7}") int maxQueryDepth, @Value(value="${service.graphql.maxQueryComplexity:10}") int maxQueryComplexity) {
        Intrinsics.checkNotNullParameter((Object)wikiFetcher, (String)"wikiFetcher");
        Intrinsics.checkNotNullParameter((Object)tableOfContentsFetcher, (String)"tableOfContentsFetcher");
        Intrinsics.checkNotNullParameter((Object)articleFetcher, (String)"articleFetcher");
        Intrinsics.checkNotNullParameter((Object)chapterFetcher, (String)"chapterFetcher");
        Intrinsics.checkNotNullParameter((Object)ancestorFetcher, (String)"ancestorFetcher");
        Intrinsics.checkNotNullParameter((Object)permissionFetcher, (String)"permissionFetcher");
        Intrinsics.checkNotNullParameter((Object)subscriptionFetcher, (String)"subscriptionFetcher");
        Intrinsics.checkNotNullParameter((Object)userInfoFetcher, (String)"userInfoFetcher");
        Intrinsics.checkNotNullParameter((Object)profileInfoFetcher, (String)"profileInfoFetcher");
        Intrinsics.checkNotNullParameter((Object)globalUserInfoFetcher, (String)"globalUserInfoFetcher");
        Intrinsics.checkNotNullParameter((Object)simpleComplexityCalculator, (String)"simpleComplexityCalculator");
        this.wikiFetcher = wikiFetcher;
        this.tableOfContentsFetcher = tableOfContentsFetcher;
        this.articleFetcher = articleFetcher;
        this.chapterFetcher = chapterFetcher;
        this.ancestorFetcher = ancestorFetcher;
        this.permissionFetcher = permissionFetcher;
        this.subscriptionFetcher = subscriptionFetcher;
        this.userInfoFetcher = userInfoFetcher;
        this.profileInfoFetcher = profileInfoFetcher;
        this.globalUserInfoFetcher = globalUserInfoFetcher;
        this.simpleComplexityCalculator = simpleComplexityCalculator;
        this.maxQueryDepth = maxQueryDepth;
        this.maxQueryComplexity = maxQueryComplexity;
        this.genericFetcher = GraphQLProvider::genericFetcher$lambda$0;
        this.tableOfContentsElementResolver = GraphQLProvider::tableOfContentsElementResolver$lambda$1;
        this.granteeResolver = GraphQLProvider::granteeResolver$lambda$2;
    }

    @NotNull
    public GraphQL getGraphQL() {
        GraphQL graphQL = this.graphQL;
        if (graphQL != null) {
            return graphQL;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"graphQL");
        return null;
    }

    public void setGraphQL(@NotNull GraphQL graphQL) {
        Intrinsics.checkNotNullParameter((Object)graphQL, (String)"<set-?>");
        this.graphQL = graphQL;
    }

    @VisibleForTesting
    public static /* synthetic */ void getGraphQL$annotations() {
    }

    @Bean
    @NotNull
    public Instrumentation instrumentation() {
        return (Instrumentation)new ChainedInstrumentation((List)ImmutableList.of((Object)new DataLoaderDispatcherInstrumentation(), (Object)new MaxQueryDepthInstrumentation(this.maxQueryDepth), (Object)new MaxQueryComplexityInstrumentation(this.maxQueryComplexity, (FieldComplexityCalculator)this.simpleComplexityCalculator)));
    }

    @Bean
    @NotNull
    public GraphQLErrorHandler graphQLErrorHandler() {
        return (GraphQLErrorHandler)new CustomGraphQLErrorHandler();
    }

    @Bean
    @NotNull
    public GraphQLSchema schema(@NotNull Instrumentation instrumentation) throws IOException {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        URL url = Resources.getResource((String)"schema.graphql");
        String sdl = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Intrinsics.checkNotNull((Object)sdl);
        GraphQLSchema graphQLSchema = this.buildSchema(sdl);
        this.setGraphQL(GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).instrumentation(instrumentation).build());
        return graphQLSchema;
    }

    private GraphQLSchema buildSchema(String sdl) {
        TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(sdl);
        RuntimeWiring runtimeWiring = this.buildWiring();
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        GraphQLSchema graphQLSchema = schemaGenerator.makeExecutableSchema(typeRegistry, runtimeWiring);
        Intrinsics.checkNotNullExpressionValue((Object)graphQLSchema, (String)"makeExecutableSchema(...)");
        return graphQLSchema;
    }

    private RuntimeWiring newRuntimeWiring(Function1<? super RuntimeWiring.Builder, Unit> block) {
        boolean $i$f$newRuntimeWiring = false;
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        block.invoke((Object)builder);
        RuntimeWiring runtimeWiring = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeWiring, (String)"build(...)");
        return runtimeWiring;
    }

    private RuntimeWiring.Builder addType(RuntimeWiring.Builder $this$addType, String typeName, Function1<? super TypeRuntimeWiring.Builder, Unit> block) {
        boolean $i$f$addType = false;
        TypeRuntimeWiring.Builder builder = TypeRuntimeWiring.newTypeWiring((String)typeName);
        block.invoke((Object)builder);
        RuntimeWiring.Builder builder2 = $this$addType.type(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"type(...)");
        return builder2;
    }

    @NotNull
    public DataFetcher<DataFetcherResult<Map<String, Object>>> getGenericFetcher() {
        return this.genericFetcher;
    }

    @NotNull
    public TypeResolver getTableOfContentsElementResolver() {
        return this.tableOfContentsElementResolver;
    }

    @NotNull
    public TypeResolver getGranteeResolver() {
        return this.granteeResolver;
    }

    /*
     * WARNING - void declaration
     */
    private RuntimeWiring buildWiring() {
        void $this$buildWiring_u24lambda_u2418_u24lambda_u2417;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2416;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2415;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2414;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2413;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2412;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2411;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u2410;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u249;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u248;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u247;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u246;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u245;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u244;
        TypeRuntimeWiring.Builder $this$buildWiring_u24lambda_u2418_u24lambda_u243;
        RuntimeWiring.Builder $this$addType$iv;
        TypeRuntimeWiring.Builder builder;
        RuntimeWiring.Builder builder2;
        GraphQLProvider this_$iv = this;
        boolean $i$f$newRuntimeWiring = false;
        RuntimeWiring.Builder $this$buildWiring_u24lambda_u2418 = builder2 = RuntimeWiring.newRuntimeWiring();
        boolean bl = false;
        GraphQLProvider graphQLProvider = this;
        RuntimeWiring.Builder builder3 = $this$buildWiring_u24lambda_u2418;
        String typeName$iv = "Query";
        boolean $i$f$addType = false;
        TypeRuntimeWiring.Builder builder4 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        RuntimeWiring.Builder builder5 = $this$addType$iv;
        boolean bl2 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("wiki", this.wikiFetcher.getById());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("wikis", this.wikiFetcher.getWikis());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("tableOfContents", this.tableOfContentsFetcher.getById());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("article", this.articleFetcher.getById());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("subscribedArticles", this.articleFetcher.getSubscribedArticles());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("articleVersion", this.articleFetcher.getByVersionId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("chapter", this.chapterFetcher.getById());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("subscribedChapters", this.chapterFetcher.getSubscribedChapters());
        $this$buildWiring_u24lambda_u2418_u24lambda_u243.dataFetcher("globalUserInfo", this.getGenericFetcher());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        GraphQLProvider this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "Mutation";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u243 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl3 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("createWiki", this.wikiFetcher.getCreate());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("updateWiki", this.wikiFetcher.getUpdate());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("deleteWiki", this.wikiFetcher.getDelete());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("createArticle", this.articleFetcher.create());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("updateArticle", this.articleFetcher.update());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("deleteArticle", this.articleFetcher.delete());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("updateArticleEditingToken", this.articleFetcher.updateEditingToken());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("deleteArticleEditingToken", this.articleFetcher.deleteEditingToken());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("updateTableOfContents", this.tableOfContentsFetcher.update());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("createChapter", this.chapterFetcher.create());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("updateChapter", this.chapterFetcher.update());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("deleteChapter", this.chapterFetcher.delete());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("setSubscription", this.subscriptionFetcher.getSetSubscription());
        $this$buildWiring_u24lambda_u2418_u24lambda_u244.dataFetcher("setWikiOverview", this.globalUserInfoFetcher.setWikiOverview());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "Wiki";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u244 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl4 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("articles", this.articleFetcher.getAllByWiki());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("articleCount", this.articleFetcher.getCountByWiki());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("chapterCount", this.chapterFetcher.getCountByWiki());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("chapters", this.chapterFetcher.getAllByWiki());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("tableOfContents", this.tableOfContentsFetcher.getByWikiId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("permissions", this.permissionFetcher.getPermissions());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("userInfo", this.getGenericFetcher());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("subscription", this.subscriptionFetcher.getByWikiIds());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("contactPerson", this.profileInfoFetcher.getGetContactPerson());
        $this$buildWiring_u24lambda_u2418_u24lambda_u245.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "Chapter";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u245 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl5 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("articles", this.articleFetcher.getAllByChapter());
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("chapters", this.chapterFetcher.getAllByChapter());
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("ancestors", this.ancestorFetcher.getByChapterId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("tableOfContents", this.tableOfContentsFetcher.getByChapterId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("wiki", this.wikiFetcher.getByChapterId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u246.dataFetcher("subscription", this.subscriptionFetcher.getByChapterId());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "UserInfo";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u246 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl6 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u247.dataFetcher("isManager", this.userInfoFetcher.isManager());
        $this$buildWiring_u24lambda_u2418_u24lambda_u247.dataFetcher("isWriter", this.userInfoFetcher.isWriter());
        $this$buildWiring_u24lambda_u2418_u24lambda_u247.dataFetcher("mayReadArticleVersionHistory", this.userInfoFetcher.getMayReadArticleVersionHistory());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "GlobalUserInfo";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u247 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl7 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u248.dataFetcher("mayCreateWiki", this.globalUserInfoFetcher.getMayCreateWiki());
        $this$buildWiring_u24lambda_u2418_u24lambda_u248.dataFetcher("overview", this.globalUserInfoFetcher.getWikiOverview());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "Article";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u248 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl8 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("ancestors", this.ancestorFetcher.getByArticleId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("wiki", this.wikiFetcher.getByArticleId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("articleVersions", this.articleFetcher.getArticleVersionsByArticleId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("contactPerson", this.profileInfoFetcher.getGetContactPerson());
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("subscription", this.subscriptionFetcher.getByArticleId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u249.dataFetcher("headings", this.articleFetcher.getHeadingsByArticleId());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "ArticleWithTitle";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u249 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl9 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2410.dataFetcher("ancestors", this.ancestorFetcher.getByArticleWithTitleId());
        $this$buildWiring_u24lambda_u2418_u24lambda_u2410.dataFetcher("subscription", this.subscriptionFetcher.getByArticleWithTitleId());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "PermissionType";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2410 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl10 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2411.enumValues((EnumValuesProvider)new NaturalEnumValuesProvider(PermissionType.class));
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "WikiOverviewDirection";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2411 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl11 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2412.enumValues((EnumValuesProvider)new NaturalEnumValuesProvider(WikiOverviewDirection.class));
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "WikiOverviewDisplay";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2412 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl12 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2413.enumValues((EnumValuesProvider)new NaturalEnumValuesProvider(WikiOverviewDisplay.class));
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "WikiOverviewSort";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2413 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl13 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2414.enumValues((EnumValuesProvider)new NaturalEnumValuesProvider(WikiOverviewSort.class));
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "TableOfContentsElement";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2414 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl14 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2415.typeResolver(this.getTableOfContentsElementResolver());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "Grantee";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2415 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl15 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2416.typeResolver(this.getGranteeResolver());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        this_$iv2 = this;
        $this$addType$iv = $this$buildWiring_u24lambda_u2418;
        typeName$iv = "ArticleVersion";
        $i$f$addType = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2416 = builder = TypeRuntimeWiring.newTypeWiring((String)typeName$iv);
        builder5 = $this$addType$iv;
        boolean bl16 = false;
        $this$buildWiring_u24lambda_u2418_u24lambda_u2417.dataFetcher("updatedBy", this.profileInfoFetcher.getGetUpdatedBy());
        Intrinsics.checkNotNullExpressionValue((Object)builder5.type(builder), (String)"type(...)");
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getWIKI_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getARTICLE_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getARTICLE_VERSION_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getCHAPTER_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getPARENT_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getTENANT_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getPERMISSION_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getITEM_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getGRANTEE_ID());
        $this$buildWiring_u24lambda_u2418.scalar(GraphQLScalar.INSTANCE.getPROFILE_ID());
        $this$buildWiring_u24lambda_u2418.scalar(ExtendedScalars.DateTime);
        RuntimeWiring runtimeWiring = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)runtimeWiring, (String)"build(...)");
        return runtimeWiring;
    }

    private static final DataFetcherResult genericFetcher$lambda$0(DataFetchingEnvironment env) {
        return DataFetcherResult.newResult().data((Object)MapsKt.emptyMap()).localContext(env.getSource()).build();
    }

    private static final GraphQLObjectType tableOfContentsElementResolver$lambda$1(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
        Object object2 = object;
        return object2 instanceof TableOfContentsArticle ? env.getSchema().getObjectType("TableOfContentsArticle") : (object2 instanceof TableOfContentsChapter ? env.getSchema().getObjectType("TableOfContentsChapter") : null);
    }

    private static final GraphQLObjectType granteeResolver$lambda$2(TypeResolutionEnvironment env) {
        Object object = env.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
        Object object2 = object;
        return object2 instanceof ProfileGranteeDto ? env.getSchema().getObjectType("ProfileGrantee") : (object2 instanceof GroupGranteeDto ? env.getSchema().getObjectType("GroupGrantee") : null);
    }
}

