/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.wikiservice.config.ExceptionHandlerConfiguration;
import de.justsoftware.wikiservice.exception.BadRequestException;
import de.justsoftware.wikiservice.exception.UnauthorizedException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\nH\u0017\u00a8\u0006\f"}, d2={"Lde/justsoftware/wikiservice/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "", "handleBadRequestException", "e", "Lde/justsoftware/wikiservice/exception/BadRequestException;", "handleUnauthorizedException", "Lde/justsoftware/wikiservice/exception/UnauthorizedException;", "Companion", "wiki-service"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public String handleAllExceptions() {
        return DEFAULT_ERROR;
    }

    @ExceptionHandler(value={BadRequestException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @Nullable
    public String handleBadRequestException(@NotNull BadRequestException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @Nullable
    public String handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }
}

