/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.TableOfContentsService$update$;
import de.justsoftware.wikiservice.business.UpdateItem;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.model.TableOfContentsArticle;
import de.justsoftware.wikiservice.business.model.TableOfContentsChapter;
import de.justsoftware.wikiservice.business.model.TableOfContentsElement;
import de.justsoftware.wikiservice.graphql.generated.UpdateTableOfContentsElementInput;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.DeletionFlagModel;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u00002\u00020\u0001B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00142\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001a0\u0019H\u0012J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u000e*\b\u0012\u0004\u0012\u00020\u000e0\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J.\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0017J:\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00142\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00142\u0006\u0010#\u001a\u00020$H\u0012J\u0016\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020)0\rH\u0012J,\u00100\u001a\u00020'2\f\u00101\u001a\b\u0012\u0004\u0012\u00020)0\u00142\f\u00102\u001a\b\u0012\u0004\u0012\u00020)0\u00142\u0006\u0010#\u001a\u00020$H\u0012J\u001e\u00103\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020)0\rH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/justsoftware/wikiservice/business/TableOfContentsService;", "", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "<init>", "(Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/business/AncestorService;)V", "getSortedTOCElements", "", "Lde/justsoftware/wikiservice/business/model/TableOfContentsElement;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "wikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "getChaptersForParentId", "", "Lde/justsoftware/wikiservice/business/model/TableOfContentsChapter;", "getArticlesForParentIds", "Lde/justsoftware/wikiservice/business/model/TableOfContentsArticle;", "parentIdsAndLevel", "", "", "sortTableOfContentsElementList", "unsortedList", "", "popNextNodeOrNull", "update", "", "items", "Lde/justsoftware/wikiservice/graphql/generated/UpdateTableOfContentsElementInput;", "updater", "Lde/justsoftware/wikiservice/model/ProfileId;", "maxChapterDepth", "updatePositionAndPersist", "", "allSitemapItems", "Lde/justsoftware/wikiservice/business/UpdateItem;", "allArticles", "Lde/justsoftware/wikiservice/persistence/model/Article;", "allChapters", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "persistUpdates", "itemsToUpdate", "updateModifiedDate", "chaptersToUpdate", "articlesToUpdate", "getMaxChapterDepth", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTableOfContentsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableOfContentsService.kt\nde/justsoftware/wikiservice/business/TableOfContentsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,321:1\n1557#2:322\n1628#2,3:323\n774#2:326\n865#2,2:327\n1557#2:329\n1628#2,3:330\n1557#2:333\n1628#2,3:334\n1557#2:337\n1628#2,3:338\n1557#2:341\n1628#2,3:342\n774#2:345\n865#2,2:346\n2341#2,14:348\n1557#2:363\n1628#2,3:364\n1053#2:367\n1863#2:368\n295#2,2:369\n295#2,2:371\n1864#2:373\n1485#2:374\n1510#2,3:375\n1513#2,3:385\n1557#2:388\n1628#2,2:389\n1567#2:391\n1598#2,4:392\n1630#2:396\n774#2:397\n865#2:398\n295#2,2:399\n295#2,2:401\n866#2:403\n1863#2,2:404\n1611#2,9:406\n1863#2:415\n1864#2:417\n1620#2:418\n1611#2,9:419\n1863#2:428\n1864#2:430\n1620#2:431\n1557#2:432\n1628#2,3:433\n1557#2:436\n1628#2,3:437\n774#2:440\n865#2,2:441\n1557#2:443\n1628#2,3:444\n295#2,2:447\n1#3:362\n1#3:416\n1#3:429\n381#4,7:378\n*S KotlinDebug\n*F\n+ 1 TableOfContentsService.kt\nde/justsoftware/wikiservice/business/TableOfContentsService\n*L\n37#1:322\n37#1:323,3\n55#1:326\n55#1:327,2\n56#1:329\n56#1:330,3\n57#1:333\n57#1:334,3\n67#1:337\n67#1:338,3\n69#1:341\n69#1:342,3\n95#1:345\n95#1:346,2\n96#1:348,14\n108#1:363\n108#1:364,3\n116#1:367\n122#1:368\n126#1:369,2\n136#1:371,2\n122#1:373\n186#1:374\n186#1:375,3\n186#1:385,3\n188#1:388\n188#1:389,2\n189#1:391\n189#1:392,4\n188#1:396\n192#1:397\n192#1:398\n196#1:399,2\n212#1:401,2\n192#1:403\n238#1:404,2\n267#1:406,9\n267#1:415\n267#1:417\n267#1:418\n274#1:419,9\n274#1:428\n274#1:430\n274#1:431\n280#1:432\n280#1:433,3\n286#1:436\n286#1:437,3\n305#1:440\n305#1:441,2\n307#1:443\n307#1:444,3\n174#1:447,2\n267#1:416\n274#1:429\n186#1:378,7\n*E\n"})
public class TableOfContentsService {
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final AncestorService ancestorService;

    @Autowired
    public TableOfContentsService(@NotNull ArticleRepository articleRepository, @NotNull ArticleVersionRepository articleVersionRepository, @NotNull ChapterRepository chapterRepository, @NotNull AncestorService ancestorService) {
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        this.articleRepository = articleRepository;
        this.articleVersionRepository = articleVersionRepository;
        this.chapterRepository = chapterRepository;
        this.ancestorService = ancestorService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TableOfContentsElement> getSortedTOCElements(@NotNull ParentId parentId, @NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Set chapters = this.getChaptersForParentId(wikiId, parentId);
        Iterable $this$map$iv = chapters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TableOfContentsChapter tableOfContentsChapter = (TableOfContentsChapter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getId(), (Object)it.getLevel()));
        }
        Map chaptersLevels = MapsKt.plus((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)parentId, (Object)-1)));
        Set articles = this.getArticlesForParentIds(chaptersLevels);
        return this.sortTableOfContentsElementList(CollectionsKt.toMutableList((Collection)SetsKt.plus((Set)chapters, (Iterable)articles)), parentId);
    }

    /*
     * WARNING - void declaration
     */
    private Set<TableOfContentsChapter> getChaptersForParentId(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        int level = 0;
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Chapter it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Chapter)element$iv$iv;
                boolean bl = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            $this$filter$iv = children;
            Set set = result;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Chapter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TableOfContentsChapter.Companion.toTableOfContentsChapter(it, level));
            }
            set.addAll((List)destination$iv$iv);
            $this$map$iv = children;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Chapter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId().getId());
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            int n = level;
            level = n + 1;
        }
        return result;
    }

    private Set<TableOfContentsArticle> getArticlesForParentIds(Map<ParentId, Integer> parentIdsAndLevel) {
        Article it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Map articles = this.articleRepository.findByParentIds(parentIdsAndLevel.keySet());
        Iterable iterable = CollectionsKt.flatten((Iterable)articles.values());
        Object object = this.articleVersionRepository;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Article article = (Article)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Map articleVersions = object.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $this$map$iv = CollectionsKt.flatten((Iterable)articles.values());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleVersion articleVersion;
            it = (Article)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            if ((ArticleVersion)articleVersions.get(it.getId()) == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            Integer n = parentIdsAndLevel.get(IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType()));
            if (n == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            object.add(TableOfContentsArticle.Companion.toTableOfContentsArticle(it, articleVersion, ((Number)n).intValue() + 1));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private List<TableOfContentsElement> sortTableOfContentsElementList(List<TableOfContentsElement> unsortedList, ParentId parentId) {
        List result = new ArrayList();
        TableOfContentsElement next = this.popNextNodeOrNull(unsortedList, parentId);
        while (next != null) {
            result.add(next);
            if (next instanceof TableOfContentsChapter) {
                result.addAll(this.sortTableOfContentsElementList(unsortedList, (ParentId)((TableOfContentsChapter)next).getId()));
            }
            next = this.popNextNodeOrNull(unsortedList, parentId);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private TableOfContentsElement popNextNodeOrNull(List<TableOfContentsElement> $this$popNextNodeOrNull, ParentId parentId) {
        TableOfContentsElement tableOfContentsElement;
        Object v0;
        void $this$minByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$popNextNodeOrNull;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TableOfContentsElement it = (TableOfContentsElement)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getParentId(), (Object)parentId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                TableOfContentsElement it = (TableOfContentsElement)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getRelativePosition();
                do {
                    Object e$iv = iterator$iv.next();
                    TableOfContentsElement it2 = (TableOfContentsElement)e$iv;
                    $i$a$-minByOrNull-TableOfContentsService$popNextNodeOrNull$2 = false;
                    int v$iv = it2.getRelativePosition();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        TableOfContentsElement tableOfContentsElement2 = v0;
        if (tableOfContentsElement2 != null) {
            TableOfContentsElement tableOfContentsElement3;
            TableOfContentsElement it = tableOfContentsElement3 = tableOfContentsElement2;
            boolean bl = false;
            $this$popNextNodeOrNull.remove(it);
            tableOfContentsElement = tableOfContentsElement3;
        } else {
            tableOfContentsElement = null;
        }
        return tableOfContentsElement;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean update(@NotNull WikiId wikiId, @NotNull List<UpdateTableOfContentsElementInput> items, @NotNull ProfileId updater, int maxChapterDepth) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Iterable iterable = items;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void item;
            UpdateTableOfContentsElementInput updateTableOfContentsElementInput = (UpdateTableOfContentsElementInput)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UpdateItem(item.getId(), item.getParentId(), null, false, 12, null));
        }
        List allSitemapItems = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Set allArticles = this.articleRepository.findAllByWikiId(wikiId);
        Set allChapters = this.chapterRepository.findAllByWikiId(wikiId);
        Iterable $this$sortedBy$iv = SetsKt.plus((Set)allArticles, (Iterable)allChapters);
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new update$$inlined$sortedBy$1()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object v2;
            ArticleId id;
            DeletionFlagModel it;
            block7: {
                UpdateTableOfContentsElementInput item;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                it = (DeletionFlagModel)element$iv;
                boolean bl = false;
                DeletionFlagModel deletionFlagModel = it;
                if (deletionFlagModel instanceof Article) {
                    Object object2;
                    Object v0;
                    block6: {
                        id = ((Article)it).getId();
                        $this$firstOrNull$iv = items;
                        $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            item = (UpdateTableOfContentsElementInput)element$iv2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)item.getId(), (Object)id)) continue;
                            v0 = element$iv2;
                            break block6;
                        }
                        v0 = null;
                    }
                    if ((object2 = (UpdateTableOfContentsElementInput)v0) != null) continue;
                    object2 = allSitemapItems.add(new UpdateItem((ItemId)id, IdUtilsKt.parentIdOf((UUID)((Article)it).getParentId(), (IdType)((Article)it).getParentType()), null, it.getDeletionId() != null, 4, null));
                    continue;
                }
                if (!(deletionFlagModel instanceof Chapter)) continue;
                id = ((Chapter)it).getId();
                $this$firstOrNull$iv = items;
                $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    item = (UpdateTableOfContentsElementInput)element$iv2;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)item.getId(), (Object)id)) continue;
                    v2 = element$iv2;
                    break block7;
                }
                v2 = null;
            }
            if ((object = (UpdateTableOfContentsElementInput)v2) != null) continue;
            object = allSitemapItems.add(new UpdateItem((ItemId)id, IdUtilsKt.parentIdOf((UUID)((Chapter)it).getParentId(), (IdType)((Chapter)it).getParentType()), null, it.getDeletionId() != null, 4, null));
        }
        int newMaxChapterDepth = this.getMaxChapterDepth(wikiId, allSitemapItems);
        if (!(newMaxChapterDepth <= maxChapterDepth)) {
            boolean bl = false;
            String string = "Maximum chapter depth exceeded (" + newMaxChapterDepth + " > " + maxChapterDepth + ").";
            throw new IllegalStateException(string.toString());
        }
        this.updatePositionAndPersist(allSitemapItems, CollectionsKt.toSet((Iterable)allArticles), CollectionsKt.toSet((Iterable)allChapters), updater);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void updatePositionAndPersist(List<UpdateItem> allSitemapItems, Set<Article> allArticles, Set<Chapter> allChapters, ProfileId updater) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list$iv$iv;
        UpdateItem it;
        void $this$groupByTo$iv$iv;
        Set modifiedChapters = new LinkedHashSet();
        Set modifiedArticles = new LinkedHashSet();
        Iterable $this$groupBy$iv = allSitemapItems;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (UpdateItem)element$iv$iv;
            boolean bl = false;
            ParentId key$iv$iv = it.getParentId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv;
            list$iv$iv = (List)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Iterable $this$mapIndexed$iv = (Iterable)it;
            boolean $i$f$mapIndexed = false;
            Iterable $i$f$getOrPut = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                void index;
                void item;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                UpdateItem updateItem = (UpdateItem)item$iv$iv2;
                int n2 = n;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(UpdateItem.copy$default((UpdateItem)item, null, null, (Integer)((int)index), (boolean)false, (int)11, null));
            }
            object.add((List)destination$iv$iv2);
        }
        $this$map$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            UpdateItem item = (UpdateItem)element$iv$iv;
            boolean bl4 = false;
            ItemId itemId = item.getId();
            if (itemId instanceof ArticleId) {
                Article article;
                Object v1;
                block23: {
                    $this$firstOrNull$iv = allArticles;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (Article)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)item.getId())) continue;
                        v1 = element$iv;
                        break block23;
                    }
                    v1 = null;
                }
                if ((Article)v1 == null) {
                    bl = false;
                } else if (!Intrinsics.areEqual((Object)item.getParentId().getId(), (Object)article.getParentId())) {
                    modifiedArticles.add(item);
                    if (TableOfContentsService.updatePositionAndPersist$getParentChapterIfPresent(allChapters, (UUID)article.getParentId()) != null) {
                        UpdateItem it2;
                        boolean bl6 = false;
                        modifiedChapters.add(it2);
                    }
                    bl = true;
                } else {
                    bl = !Intrinsics.areEqual((Object)item.getRelativePosition(), (Object)article.getRelativePosition());
                }
            } else if (itemId instanceof ChapterId) {
                Chapter chapter;
                Object v3;
                block24: {
                    $this$firstOrNull$iv = allChapters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (Chapter)element$iv;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)item.getId())) continue;
                        v3 = element$iv;
                        break block24;
                    }
                    v3 = null;
                }
                if ((Chapter)v3 == null) {
                    bl = false;
                } else if (!Intrinsics.areEqual((Object)item.getParentId().getId(), (Object)chapter.getParentId())) {
                    modifiedChapters.add(item);
                    if (TableOfContentsService.updatePositionAndPersist$getParentChapterIfPresent(allChapters, (UUID)chapter.getParentId()) != null) {
                        UpdateItem it3;
                        boolean bl8 = false;
                        modifiedChapters.add(it3);
                    }
                    bl = true;
                } else {
                    bl = !Intrinsics.areEqual((Object)item.getRelativePosition(), (Object)chapter.getRelativePosition());
                }
            } else {
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List itemsToUpdate = (List)destination$iv$iv;
        this.persistUpdates(itemsToUpdate);
        this.updateModifiedDate(modifiedChapters, modifiedArticles, updater);
    }

    private void persistUpdates(List<UpdateItem> itemsToUpdate) {
        Iterable $this$forEach$iv = itemsToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UpdateItem item = (UpdateItem)element$iv;
            boolean bl = false;
            ItemId itemId = item.getId();
            if (itemId instanceof ArticleId) {
                ArticleRepository articleRepository = this.articleRepository;
                UUID uUID = item.getParentId().getId();
                IdType idType = item.getParentId().type();
                Integer n = item.getRelativePosition();
                if (n == null) {
                    IdType idType2 = idType;
                    UUID uUID2 = uUID;
                    ArticleRepository articleRepository2 = articleRepository;
                    boolean $i$a$-checkNotNull-TableOfContentsService$persistUpdates$1$32 = false;
                    String string = "relativePosition must not be null";
                    ArticleRepository articleRepository3 = articleRepository2;
                    UUID uUID3 = uUID2;
                    IdType idType3 = idType2;
                    String $i$a$-checkNotNull-TableOfContentsService$persistUpdates$1$32 = string;
                    throw new IllegalStateException($i$a$-checkNotNull-TableOfContentsService$persistUpdates$1$32.toString());
                }
                articleRepository.updateParentIdAndPosition(uUID, idType, ((Number)n).intValue(), (ArticleId)item.getId());
                continue;
            }
            if (!(itemId instanceof ChapterId)) continue;
            ChapterRepository chapterRepository = this.chapterRepository;
            UUID uUID = item.getParentId().getId();
            IdType idType = item.getParentId().type();
            Integer n = item.getRelativePosition();
            if (n == null) {
                IdType idType4 = idType;
                UUID uUID4 = uUID;
                ChapterRepository chapterRepository2 = chapterRepository;
                boolean bl2 = false;
                String string = "relativePosition must not be null";
                ChapterRepository chapterRepository3 = chapterRepository2;
                UUID uUID5 = uUID4;
                IdType idType5 = idType4;
                String string2 = string;
                throw new IllegalStateException(string2.toString());
            }
            chapterRepository.updateParentIdAndPosition(uUID, idType, ((Number)n).intValue(), (ChapterId)item.getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateModifiedDate(Set<UpdateItem> chaptersToUpdate, Set<UpdateItem> articlesToUpdate, ProfileId updater) {
        UpdateItem it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object element$iv$iv$iv22;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Instant updatedAt = Instant.now();
        Iterable iterable = chaptersToUpdate;
        boolean $i$f$mapNotNull22 = false;
        void var8_8 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv22 : $this$forEach$iv$iv$iv) {
            ChapterId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv22;
            boolean bl = false;
            UpdateItem it2 = (UpdateItem)element$iv$iv;
            boolean bl2 = false;
            ItemId itemId = it2.getId();
            if ((itemId instanceof ChapterId ? (ChapterId)itemId : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set modifiedChapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)modifiedChapters).isEmpty()) {
            Intrinsics.checkNotNull((Object)updatedAt);
            this.chapterRepository.setUpdatedStatus(modifiedChapters, updater, updatedAt);
        }
        Iterable $i$f$mapNotNull22 = articlesToUpdate;
        boolean $i$f$mapNotNull3 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv22 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv22.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = element$iv$iv$iv22.next();
            boolean bl = false;
            UpdateItem it3 = (UpdateItem)element$iv$iv;
            boolean bl4 = false;
            ItemId itemId = it3.getId();
            if ((itemId instanceof ArticleId ? (ArticleId)itemId : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set modifiedArticles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        if (!((Collection)modifiedArticles).isEmpty()) {
            void $this$map$iv;
            Iterable $i$f$mapNotNull3 = this.articleVersionRepository.findLatestArticleVersionsByArticleIds(modifiedArticles).values();
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv$iv$iv = (ArticleVersion)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(it.getId());
            }
            Set articleVersions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            Intrinsics.checkNotNull((Object)updatedAt);
            this.articleVersionRepository.setModifiedStatus(articleVersions, updater, updatedAt);
        }
        Iterable $this$map$iv = SetsKt.plus(chaptersToUpdate, (Iterable)articlesToUpdate);
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UpdateItem)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            collection.add(it.getParentId());
        }
        Set parentIdsToUpdate = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
        if (!((Collection)parentIdsToUpdate).isEmpty()) {
            Intrinsics.checkNotNull((Object)updatedAt);
            this.ancestorService.updateEditedStatusForAncestors(parentIdsToUpdate, updatedAt, updater);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxChapterDepth(WikiId wikiId, List<UpdateItem> items) {
        int level = 0;
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)wikiId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            void $this$mapTo$iv$iv;
            UpdateItem it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = items;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (UpdateItem)element$iv$iv;
                boolean bl = false;
                if (!(nextParentIds.contains(it.getParentId().getId()) && it.getId() instanceof ChapterId && !it.isDeleted())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            result.addAll(children);
            Iterable $this$map$iv = children;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (UpdateItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId().getId());
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            ++level;
        }
        return level - 1;
    }

    private static final UpdateItem updatePositionAndPersist$getParentChapterIfPresent(Set<Chapter> $allChapters, UUID parentId) {
        UpdateItem updateItem;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = $allChapters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Chapter it = (Chapter)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)parentId, (Object)it.getId().getId())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Chapter chapter = v0;
        if (chapter != null) {
            Chapter it = chapter;
            boolean bl = false;
            updateItem = new UpdateItem((ItemId)it.getId(), IdUtilsKt.parentIdOf((UUID)it.getParentId(), (IdType)it.getParentType()), null, false, 12, null);
        } else {
            updateItem = null;
        }
        return updateItem;
    }
}

