/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.application.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.ArticleService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.EmptyArticleTitleException;
import de.justsoftware.wikiservice.drive.DriveService;
import de.justsoftware.wikiservice.model.ArticleCreatedEvent;
import de.justsoftware.wikiservice.model.ArticleDeletedEvent;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleUpdatedEvent;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.MigrationStatus;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleHeadingMigrationRepository;
import de.justsoftware.wikiservice.persistence.ArticleHeadingRepository;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleHeading;
import de.justsoftware.wikiservice.persistence.model.ArticleHeadingMigrationStatus;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.prosemirror.ArticleHeadingInfo;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 _2\u00020\u0001:\u0001_Bk\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0001\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001a\u0010\u001bJJ\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010'H\u0017J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0017J\"\u0010/\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020,002\f\u00101\u001a\b\u0012\u0004\u0012\u00020.02H\u0017J&\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u00020'2\u0006\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020)H\u0017J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0017J\u0010\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020<H\u0017J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020,042\f\u00101\u001a\b\u0012\u0004\u0012\u00020.02H\u0017J(\u0010>\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020?04002\f\u00101\u001a\b\u0012\u0004\u0012\u00020.02H\u0017J\"\u0010@\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001d002\f\u00101\u001a\b\u0012\u0004\u0012\u00020.02H\u0017J(\u0010A\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d04002\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001f02H\u0016J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020.02H\u0016J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020.0EH\u0016J\"\u0010F\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020)002\f\u0010G\u001a\b\u0012\u0004\u0012\u00020!02H\u0016JJ\u0010H\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#2\b\u0010%\u001a\u0004\u0018\u00010#2\u0006\u0010I\u001a\u00020'2\b\u0010*\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010J\u001a\u00020KH\u0017J \u0010L\u001a\u00020M2\u0006\u0010-\u001a\u00020.2\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020'H\u0017J\u001e\u0010Q\u001a\u00020M2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001f022\u0006\u0010N\u001a\u00020OH\u0017J\u0018\u0010R\u001a\u00020M2\u0006\u0010S\u001a\u00020!2\u0006\u0010N\u001a\u00020OH\u0017J\u0018\u0010T\u001a\u00020K2\u0006\u0010-\u001a\u00020.2\u0006\u0010I\u001a\u00020'H\u0017J\u0018\u0010U\u001a\u00020K2\u0006\u0010-\u001a\u00020.2\u0006\u0010I\u001a\u00020'H\u0017J\u0016\u0010V\u001a\u00020M2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020O02H\u0017J\b\u0010X\u001a\u00020MH\u0017J\b\u0010Y\u001a\u00020KH\u0016J\u001d\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020[2\u0006\u0010]\u001a\u00020,H\u0011\u00a2\u0006\u0002\b^R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lde/justsoftware/wikiservice/business/ArticleService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "articleHeadingRepository", "Lde/justsoftware/wikiservice/persistence/ArticleHeadingRepository;", "headingMigrationRepository", "Lde/justsoftware/wikiservice/persistence/ArticleHeadingMigrationRepository;", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/wikiservice/drive/DriveService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "entityManager", "Ljakarta/persistence/EntityManager;", "<init>", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/ArticleHeadingRepository;Lde/justsoftware/wikiservice/persistence/ArticleHeadingMigrationRepository;Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/drive/DriveService;Lde/justsoftware/wikiservice/business/AncestorService;Ljava/time/Clock;JLjakarta/persistence/EntityManager;)V", "create", "Lde/justsoftware/wikiservice/persistence/model/Article;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "wiki", "Lde/justsoftware/wikiservice/model/WikiId;", "title", "", "content", "textContent", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "position", "", "contactPerson", "getLatestArticleVersion", "Lde/justsoftware/wikiservice/persistence/model/ArticleVersion;", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "getLatestArticleVersions", "", "articleIds", "", "readBySubscriber", "", "Lde/justsoftware/wikiservice/application/model/ArticleWithTitleDto;", "subscriber", "page", "limit", "read", "getArticleVersion", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readVersions", "readHeadings", "Lde/justsoftware/wikiservice/persistence/model/ArticleHeading;", "readByIds", "readByParentIds", "parentIds", "readAllIds", "streamAllIds", "Ljava/util/stream/Stream;", "countByWikiIds", "wikiIds", "update", "updater", "articleWasMoved", "", "delete", "", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deletedBy", "deleteByParentIds", "deleteWikiArticles", "wikiId", "updateEditingToken", "deleteEditingToken", "removeDeletedArticles", "deletionIds", "migrateArticlesHeaders", "articlesHeadersFullyMigrated", "migrateArticleHeaders", "Lde/justsoftware/wikiservice/persistence/model/ArticleHeadingMigrationStatus;", "toMigrate", "articleVersion", "migrateArticleHeaders$wiki_service", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,499:1\n1557#2:500\n1628#2,3:501\n1368#2:504\n1454#2,5:505\n2642#2:510\n1279#2,2:512\n1293#2,2:514\n1557#2:516\n1628#2,3:517\n1296#2:520\n1202#2,2:521\n1230#2,4:523\n1279#2,2:527\n1293#2,4:529\n1611#2,9:533\n1863#2:542\n1864#2:544\n1620#2:545\n1279#2,2:546\n1293#2,4:548\n1557#2:553\n1628#2,3:554\n1863#2,2:557\n1863#2,2:559\n1557#2:561\n1628#2,3:562\n1557#2:565\n1628#2,3:566\n1557#2:569\n1628#2,3:570\n1863#2,2:573\n1863#2,2:575\n1863#2,2:577\n1#3:511\n1#3:543\n1#3:552\n*S KotlinDebug\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n*L\n105#1:500\n105#1:501,3\n164#1:504\n164#1:505,5\n166#1:510\n173#1:512,2\n173#1:514,2\n176#1:516\n176#1:517,3\n173#1:520\n187#1:521,2\n187#1:523,4\n194#1:527,2\n194#1:529,4\n199#1:533,9\n199#1:542\n199#1:544\n199#1:545\n205#1:546,2\n205#1:548,4\n280#1:553\n280#1:554,3\n329#1:557,2\n344#1:559,2\n405#1:561\n405#1:562,3\n436#1:565\n436#1:566,3\n477#1:569\n477#1:570,3\n333#1:573,2\n350#1:575,2\n413#1:577,2\n166#1:511\n199#1:543\n*E\n"})
public class ArticleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ArticleHeadingRepository articleHeadingRepository;
    @NotNull
    private final ArticleHeadingMigrationRepository headingMigrationRepository;
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;
    @PersistenceContext
    @NotNull
    private final EntityManager entityManager;
    private static final Logger LOG = LoggerFactory.getLogger(ArticleService.class);
    private static boolean articlesHeadersMigrationFinished;

    @Autowired
    public ArticleService(@NotNull PermissionService permissionService, @NotNull ArticleRepository articleRepository, @NotNull ArticleHeadingRepository articleHeadingRepository, @NotNull ArticleHeadingMigrationRepository headingMigrationRepository, @NotNull ArticleVersionRepository articleVersionRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull AncestorService ancestorService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)articleHeadingRepository, (String)"articleHeadingRepository");
        Intrinsics.checkNotNullParameter((Object)headingMigrationRepository, (String)"headingMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.permissionService = permissionService;
        this.articleRepository = articleRepository;
        this.articleHeadingRepository = articleHeadingRepository;
        this.headingMigrationRepository = headingMigrationRepository;
        this.articleVersionRepository = articleVersionRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.ancestorService = ancestorService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
        this.entityManager = entityManager;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Article create(@NotNull ParentId parentId, @NotNull WikiId wiki, @NotNull String title, @NotNull String content, @NotNull String textContent, @NotNull ProfileId creator, int position, @Nullable ProfileId contactPerson) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds((String)content);
        Article article = (Article)this.articleRepository.save((Object)new Article(new ArticleId(), wiki, parentId, null, null, null, Integer.valueOf(position), contactPerson, 56, null));
        ArticleVersionId articleVersionId = new ArticleVersionId();
        ArticleId articleId = article.getId();
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(...)");
        ArticleVersion version = (ArticleVersion)this.articleVersionRepository.save((Object)new ArticleVersion(articleVersionId, articleId, string, content, textContent, creator));
        Iterable iterable = ProseMirrorContentParserKt.getHeadings((String)content);
        boolean $i$f$map = false;
        String string2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void heading;
            ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ArticleHeading(heading.getId(), article.getId(), heading.getText(), heading.getSortOrder()));
        }
        List headings = (List)destination$iv$iv;
        this.articleHeadingRepository.saveAll((Iterable)headings);
        Set tempDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)content);
        if (!((Collection)tempDriveMediaIds).isEmpty()) {
            this.driveService.persistFiles(tempDriveMediaIds, article.getId(), creator);
        }
        this.transactionUtils.afterCommit(() -> ArticleService.create$lambda$1(this, article));
        this.permissionService.addPermissionItemForNewArticle(article.getId(), wiki);
        Instant updatedAt = version.getUpdatedAt();
        if (updatedAt == null) {
            string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(parentId, updatedAt, version.getModifiedBy());
        Intrinsics.checkNotNull((Object)article);
        return article;
    }

    @Transactional
    @NotNull
    public ArticleVersion getLatestArticleVersion(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        ArticleVersion articleVersion = (ArticleVersion)this.articleVersionRepository.findLatestArticleVersionsByArticleIds(SetsKt.setOf((Object)articleId)).get(articleId);
        if (articleVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleVersion;
    }

    @Transactional
    @NotNull
    public Map<ArticleId, ArticleVersion> getLatestArticleVersions(@NotNull Set<ArticleId> articleIds) {
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        return this.articleVersionRepository.findLatestArticleVersionsByArticleIds(articleIds);
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<ArticleWithTitleDto> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
        List<ArticleWithTitleDto> list = this.articleRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    @Transactional
    @NotNull
    public Article read(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Object object = this.articleRepository.getReferenceById((Object)articleId);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getReferenceById(...)");
        return (Article)object;
    }

    @Transactional
    @NotNull
    public ArticleVersion getArticleVersion(@NotNull ArticleVersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        Object t = this.articleVersionRepository.findById((Object)versionId).orElseThrow(() -> ArticleService.getArticleVersion$lambda$2(versionId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (ArticleVersion)t;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public List<ArticleVersion> readVersions(@NotNull Set<ArticleId> articleIds) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$flatMap$iv = articleIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ArticleId article = (ArticleId)element$iv$iv;
            boolean bl = false;
            List list = this.articleVersionRepository.findByArticleIdOrderByCreatedAtDesc(article).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$onEach$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2419$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            ArticleVersion it = (ArticleVersion)element$iv;
            boolean bl2 = false;
            this.entityManager.detach((Object)it);
        }
        return (List)iterable;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, List<ArticleHeading>> readHeadings(@NotNull Set<ArticleId> articleIds) {
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$associateWith$iv = articleIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void id;
            ArticleId articleId = (ArticleId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable iterable = this.articleHeadingRepository.findByArticleIdOrderBySortOrderAsc(id.getId());
            boolean $i$f$map = false;
            void var13_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeading articleHeading = (ArticleHeading)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                this.entityManager.detach((Object)heading);
                collection.add(heading);
            }
            List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            map.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, Article> readByIds(@NotNull Set<ArticleId> articleIds) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$associateBy$iv = this.articleRepository.findByIds(articleIds);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Article article = (Article)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<Article>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Map parentArticles = this.articleRepository.findByParentIds(parentIds);
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List list = parentArticles.getOrDefault(it, CollectionsKt.emptyList());
            map.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ArticleId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.articleRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAll(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public Stream<ArticleId> streamAllIds() {
        return this.articleRepository.streamAllIds();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map countsByWiki = this.articleRepository.countByWikiIds(wikiIds);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it, 0L)).longValue();
            map.put(t, n);
        }
        return MapsKt.toMap((Map)result$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Article update(@NotNull ArticleId articleId, @Nullable String title, @Nullable String content, @Nullable String textContent, @NotNull ProfileId updater, @Nullable ProfileId contactPerson, boolean articleWasMoved) {
        Object object;
        String newTextContent;
        String string;
        String newTitle;
        ArticleVersion oldArticleVersion;
        Article article;
        block14: {
            String string2;
            block13: {
                boolean contentIsValidForUpdate;
                Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
                Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                if (title != null && StringsKt.isBlank((CharSequence)title)) {
                    throw new EmptyArticleTitleException();
                }
                boolean bl = contentIsValidForUpdate = content == null && textContent == null || content != null && textContent != null;
                if (!contentIsValidForUpdate) {
                    boolean $i$a$-require-ArticleService$update$22 = false;
                    String $i$a$-require-ArticleService$update$22 = "You cannot save content without textContent or vice versa";
                    throw new IllegalArgumentException($i$a$-require-ArticleService$update$22.toString());
                }
                if (content != null) {
                    ProseMirrorContentParserKt.verifyAllHeadingsHaveUniqueIds((String)content);
                }
                if (!Intrinsics.areEqual((Object)contactPerson, (Object)(article = (Article)this.articleRepository.getReferenceById((Object)articleId)).getContactPerson())) {
                    article.setContactPerson(contactPerson);
                    this.articleRepository.save((Object)article);
                }
                oldArticleVersion = this.getLatestArticleVersion(articleId);
                string2 = title;
                if (string2 == null) break block13;
                String it = string2;
                boolean bl2 = false;
                String string3 = StringUtils.normalizeSpace((String)title);
                string2 = string3;
                if (string3 != null) break block14;
            }
            string2 = newTitle = oldArticleVersion.getTitle();
        }
        if ((string = content) == null) {
            string = oldArticleVersion.getContent();
        }
        String newContent = string;
        String string4 = newTextContent = !Intrinsics.areEqual((Object)content, (Object)oldArticleVersion.getContent()) && textContent != null ? textContent : oldArticleVersion.getTextContent();
        if (Intrinsics.areEqual((Object)oldArticleVersion.getContent(), (Object)newContent) && Intrinsics.areEqual((Object)oldArticleVersion.getTitle(), (Object)newTitle) && !articleWasMoved) {
            Intrinsics.checkNotNull((Object)article);
            return article;
        }
        ArticleVersion newArticleVersion = (ArticleVersion)this.articleVersionRepository.save((Object)new ArticleVersion(new ArticleVersionId(), articleId, newTitle, newContent, newTextContent, updater));
        Set oldDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)oldArticleVersion.getContent());
        Set newDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)newContent);
        Set driveMediaIdsToSave = SetsKt.minus((Set)newDriveMediaIds, (Iterable)oldDriveMediaIds);
        if (!((Collection)driveMediaIdsToSave).isEmpty()) {
            this.driveService.persistFiles(driveMediaIdsToSave, articleId, updater);
        }
        if (content != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.articleHeadingRepository.deleteAllByArticleId(articleId.getId());
            object = ProseMirrorContentParserKt.getHeadings((String)content);
            boolean $i$f$map = false;
            void var21_23 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ArticleHeading(heading.getId(), articleId, heading.getText(), heading.getSortOrder()));
            }
            List headings = (List)destination$iv$iv;
            this.articleHeadingRepository.saveAll((Iterable)headings);
        }
        this.transactionUtils.afterCommit(() -> ArticleService.update$lambda$14(this, articleId));
        Instant updatedAt = newArticleVersion.getUpdatedAt();
        if (updatedAt == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(IdUtilsKt.parentIdOf((UUID)article.getParentId(), (IdType)article.getParentType()), updatedAt, newArticleVersion.getModifiedBy());
        Intrinsics.checkNotNull((Object)article);
        return article;
    }

    public static /* synthetic */ Article update$default(ArticleService articleService, ArticleId articleId, String string, String string2, String string3, ProfileId profileId, ProfileId profileId2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return articleService.update(articleId, string, string2, string3, profileId, profileId2, bl);
    }

    @Transactional
    public void delete(@NotNull ArticleId articleId, @NotNull DeletionId deletionId, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        UUID deletedArticleParentId = article.getParentId();
        IdType deletedArticleParentType = article.getParentType();
        this.articleRepository.deleteById((Object)articleId, deletionId);
        this.transactionUtils.afterCommit(() -> ArticleService.delete$lambda$15(this, articleId));
        this.permissionService.removePermissionsForDeletedArticle(articleId);
        ParentId parentId = IdUtilsKt.parentIdOf((UUID)deletedArticleParentId, (IdType)deletedArticleParentType);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deletedBy);
    }

    @Transactional
    public void deleteByParentIds(@NotNull Set<? extends ParentId> parentIds, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByParentIds(parentIds, deletionId);
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticleId it = (ArticleId)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(it);
        }
        this.transactionUtils.afterCommit(() -> ArticleService.deleteByParentIds$lambda$18(deletedArticles, this));
    }

    @Transactional
    public void deleteWikiArticles(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByWikiId(wikiId, deletionId);
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(it.getId());
        }
        this.transactionUtils.afterCommit(() -> ArticleService.deleteWikiArticles$lambda$21(deletedArticles, this));
    }

    @Transactional
    public boolean updateEditingToken(@NotNull ArticleId articleId, @NotNull ProfileId updater) {
        boolean canUpdateToken;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        Intrinsics.checkNotNull((Object)article);
        boolean tokenExpired = Article.Companion.isEditTokenExpired(article, this.clock, this.maxEditingTokenDuration);
        boolean bl = canUpdateToken = tokenExpired || Intrinsics.areEqual((Object)article.getEditingStartedBy(), (Object)updater);
        if (!canUpdateToken) {
            return false;
        }
        Instant now = Instant.ofEpochMilli(this.clock.millis());
        article.setEditingStartedAt(now);
        article.setEditingStartedBy(updater);
        this.articleRepository.save((Object)article);
        return true;
    }

    @Transactional
    public boolean deleteEditingToken(@NotNull ArticleId articleId, @NotNull ProfileId updater) {
        boolean canDeleteToken;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        Intrinsics.checkNotNull((Object)article);
        boolean tokenExpired = Article.Companion.isEditTokenExpired(article, this.clock, this.maxEditingTokenDuration);
        boolean bl = canDeleteToken = tokenExpired || Intrinsics.areEqual((Object)article.getEditingStartedBy(), (Object)updater);
        if (!canDeleteToken) {
            return false;
        }
        article.setEditingStartedAt(null);
        article.setEditingStartedBy(null);
        this.articleRepository.save((Object)article);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedArticles(@NotNull Set<DeletionId> deletionIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$map$iv = this.articleRepository.findAllByDeletionIds(deletionIds);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article article = (Article)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set articlesToDelete = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.articleVersionRepository.deleteAllByArticleIds(articlesToDelete);
        this.articleRepository.deleteAllByDeletionIds(deletionIds);
        this.transactionUtils.afterCommit(() -> ArticleService.removeDeletedArticles$lambda$24(articlesToDelete, this));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void migrateArticlesHeaders() {
        do {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{"id"};
            PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])object));
            Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(...)");
            List articlesToMigrateBatch = this.headingMigrationRepository.findByStatusIsPending((Pageable)pageRequest);
            object = articlesToMigrateBatch;
            ArticleVersionRepository articleVersionRepository = this.articleVersionRepository;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArticleHeadingMigrationStatus articleHeadingMigrationStatus = (ArticleHeadingMigrationStatus)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getArticleId());
            }
            Map versions = articleVersionRepository.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            for (ArticleHeadingMigrationStatus migration : articlesToMigrateBatch) {
                ArticleVersion version = (ArticleVersion)versions.get(migration.getArticleId());
                if (version == null) {
                    LOG.warn("Could not find article version for article '" + migration.getArticleId() + "'");
                    migration.setStatus(MigrationStatus.FAILED);
                    this.headingMigrationRepository.save((Object)migration);
                    continue;
                }
                ArticleHeadingMigrationStatus updatedMigration = this.migrateArticleHeaders$wiki_service(migration, version);
                this.headingMigrationRepository.save((Object)updatedMigration);
            }
            this.articleHeadingRepository.flush();
            this.headingMigrationRepository.flush();
            this.articleVersionRepository.flush();
        } while (!this.articlesHeadersFullyMigrated());
    }

    public boolean articlesHeadersFullyMigrated() {
        if (!articlesHeadersMigrationFinished) {
            articlesHeadersMigrationFinished = this.headingMigrationRepository.countByStatus(MigrationStatus.PENDING) == 0;
        }
        return articlesHeadersMigrationFinished;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ArticleHeadingMigrationStatus migrateArticleHeaders$wiki_service(@NotNull ArticleHeadingMigrationStatus toMigrate, @NotNull ArticleVersion articleVersion) {
        Intrinsics.checkNotNullParameter((Object)toMigrate, (String)"toMigrate");
        Intrinsics.checkNotNullParameter((Object)articleVersion, (String)"articleVersion");
        String migratedContent = null;
        List headings = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            migratedContent = ProseMirrorContentParserKt.addIdsToHeadings((String)articleVersion.getContent());
            Iterable iterable = ProseMirrorContentParserKt.getHeadings((String)migratedContent);
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void heading;
                ArticleHeadingInfo articleHeadingInfo = (ArticleHeadingInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ArticleHeading(heading.getId(), articleVersion.getArticleId(), heading.getText(), heading.getSortOrder()));
            }
            headings = (List)destination$iv$iv;
        }
        catch (Exception e) {
            LOG.warn("Failed to migrate headings of article version '" + articleVersion.getId() + "'", (Throwable)e);
            toMigrate.setStatus(MigrationStatus.FAILED);
            return toMigrate;
        }
        articleVersion.setContent(migratedContent);
        this.articleHeadingRepository.saveAll((Iterable)headings);
        toMigrate.setStatus(MigrationStatus.MIGRATED);
        return toMigrate;
    }

    private static final Unit create$lambda$1(ArticleService this$0, Article $article) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleCreatedEvent($article.getId()));
        return Unit.INSTANCE;
    }

    private static final ArticleVersionNotFoundException getArticleVersion$lambda$2(ArticleVersionId $versionId) {
        Intrinsics.checkNotNullParameter((Object)$versionId, (String)"$versionId");
        return new ArticleVersionNotFoundException($versionId);
    }

    private static final Unit update$lambda$14(ArticleService this$0, ArticleId $articleId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$articleId, (String)"$articleId");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$15(ArticleService this$0, ArticleId $articleId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$articleId, (String)"$articleId");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }

    private static final Unit deleteByParentIds$lambda$18(Set $deletedArticles, ArticleService this$0) {
        Intrinsics.checkNotNullParameter((Object)$deletedArticles, (String)"$deletedArticles");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticleId it = (ArticleId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent(it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit deleteWikiArticles$lambda$21(Set $deletedArticles, ArticleService this$0) {
        Intrinsics.checkNotNullParameter((Object)$deletedArticles, (String)"$deletedArticles");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent(it.getId()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit removeDeletedArticles$lambda$24(Set $articlesToDelete, ArticleService this$0) {
        Intrinsics.checkNotNullParameter((Object)$articlesToDelete, (String)"$articlesToDelete");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $articlesToDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticleId it = (ArticleId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleDeletedEvent(it));
        }
        return Unit.INSTANCE;
    }
}

