/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ChapterNestingException;
import de.justsoftware.wikiservice.business.exceptions.ChapterNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.CircularyAncestryException;
import de.justsoftware.wikiservice.business.exceptions.ParentNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.WikiNotFoundException;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleUpdatedEvent;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.ChapterModifiedEvent;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.model.WikiModifiedEvent;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ChapterRepository;
import de.justsoftware.wikiservice.persistence.WikiRepository;
import de.justsoftware.wikiservice.persistence.model.Ancestor;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.Chapter;
import de.justsoftware.wikiservice.persistence.model.Wiki;
import de.justsoftware.wikiservice.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00130\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u0013H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u0015H\u0016J(\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u00172\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0016J\u000e\u0010!\u001a\u0004\u0018\u00010\u0015*\u00020\u001fH\u0012J\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001f0\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0012J*\u0010$\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00190%*\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0012J \u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0017J&\u0010'\u001a\u00020(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0017J\"\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020&2\b\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u00101\u001a\u00020,H\u0017J\"\u00102\u001a\u00020.2\u0006\u00103\u001a\u0002042\b\u00100\u001a\u0004\u0018\u00010\u00152\u0006\u00101\u001a\u00020,H\u0017J\u001d\u00105\u001a\u00020(2\u0006\u00100\u001a\u00020\u00152\u0006\u00106\u001a\u00020\u001bH\u0010\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u001bH\u0012J\u0010\u0010:\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020\u000bH\u0012J\u001e\u0010>\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u00106\u001a\u00020\u001bH\u0012J\u0010\u0010@\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010A\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\u00192\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lde/justsoftware/wikiservice/business/AncestorService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "chapterRepository", "Lde/justsoftware/wikiservice/persistence/ChapterRepository;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "wikiRepository", "Lde/justsoftware/wikiservice/persistence/WikiRepository;", "maxChapterDepth", "", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "<init>", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ChapterRepository;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/WikiRepository;ILde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "getAncestorWikiId", "Lde/justsoftware/wikiservice/model/WikiId;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "getAncestorWikiIds", "", "parentIds", "", "getDescendants", "Lde/justsoftware/wikiservice/model/AbstractId;", "wikiId", "getAncestors", "", "Lde/justsoftware/wikiservice/persistence/model/Ancestor;", "firstAncestor", "getParentId", "loadAncestors", "firstAncestors", "groupByType", "Lkotlin/Pair;", "Lde/justsoftware/wikiservice/model/ChapterId;", "updateEditedStatusForAncestors", "", "updatedAt", "Ljava/time/Instant;", "updatedBy", "Lde/justsoftware/wikiservice/model/ProfileId;", "moveChapter", "", "chapterId", "toParent", "updater", "moveArticle", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "checkValidMove", "movedElement", "checkValidMove$wiki_service", "getMaxChildrenChaptersNestingDepth", "childrenId", "checkMaxNestingDepthOfNewChapter", "checkMaxNestingDepth", "parentChaptersNestingDepth", "childrenChaptersNestingDepth", "checkCircularAncestry", "parentAncestors", "getNextPositionForParent", "getPreviousPositionForParent", "getDescendantChapters", "Lde/justsoftware/wikiservice/persistence/model/Chapter;", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAncestorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AncestorService.kt\nde/justsoftware/wikiservice/business/AncestorService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,428:1\n1187#2,2:429\n1261#2,4:431\n1863#2,2:435\n1202#2,2:437\n1230#2,4:439\n1557#2:443\n1628#2,3:444\n1557#2:447\n1628#2,3:448\n1279#2,2:451\n1293#2,4:453\n1202#2,2:457\n1230#2,4:459\n774#2:468\n865#2,2:469\n1246#2,4:473\n1863#2,2:477\n1557#2:479\n1628#2,3:480\n1557#2:483\n1628#2,3:484\n1557#2:487\n1628#2,3:488\n1557#2:491\n1628#2,3:492\n1863#2,2:495\n1557#2:497\n1628#2,3:498\n1755#2,3:501\n1611#2,9:510\n1863#2:519\n1864#2:521\n1620#2:522\n1611#2,9:529\n1863#2:538\n1864#2:540\n1620#2:541\n1611#2,9:548\n1863#2:557\n1864#2:559\n1620#2:560\n1611#2,9:567\n1863#2:576\n1864#2:578\n1620#2:579\n774#2:580\n865#2,2:581\n1557#2:583\n1628#2,3:584\n1863#2,2:587\n1863#2,2:589\n1863#2,2:591\n1#3:463\n1#3:520\n1#3:539\n1#3:558\n1#3:577\n126#4:464\n153#4,3:465\n77#4:504\n97#4,5:505\n77#4:523\n97#4,5:524\n77#4:542\n97#4,5:543\n77#4:561\n97#4,5:562\n462#5:471\n412#5:472\n*S KotlinDebug\n*F\n+ 1 AncestorService.kt\nde/justsoftware/wikiservice/business/AncestorService\n*L\n52#1:429,2\n52#1:431,4\n57#1:435,2\n63#1:437,2\n63#1:439,4\n70#1:443\n70#1:444,3\n72#1:447\n72#1:448,3\n82#1:451,2\n82#1:453,4\n111#1:457,2\n111#1:459,4\n114#1:468\n114#1:469,2\n122#1:473,4\n130#1:477,2\n156#1:479\n156#1:480,3\n194#1:483\n194#1:484,3\n199#1:487\n199#1:488,3\n202#1:491\n202#1:492,3\n209#1:495,2\n347#1:497\n347#1:498,3\n377#1:501,3\n387#1:510,9\n387#1:519\n387#1:521\n387#1:522\n392#1:529,9\n392#1:538\n392#1:540\n392#1:541\n402#1:548,9\n402#1:557\n402#1:559\n402#1:560\n407#1:567,9\n407#1:576\n407#1:578\n407#1:579\n420#1:580\n420#1:581,2\n422#1:583\n422#1:584,3\n167#1:587,2\n221#1:589,2\n245#1:591,2\n387#1:520\n392#1:539\n402#1:558\n407#1:577\n113#1:464\n113#1:465,3\n386#1:504\n386#1:505,5\n391#1:523\n391#1:524,5\n401#1:542\n401#1:543,5\n406#1:561\n406#1:562,5\n122#1:471\n122#1:472\n*E\n"})
public class AncestorService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChapterRepository chapterRepository;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final WikiRepository wikiRepository;
    private final int maxChapterDepth;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public AncestorService(@NotNull PermissionService permissionService, @NotNull ChapterRepository chapterRepository, @NotNull ArticleRepository articleRepository, @NotNull WikiRepository wikiRepository, @Value(value="${service.maxChapterNestingDepth:5}") int maxChapterDepth, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chapterRepository, (String)"chapterRepository");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)wikiRepository, (String)"wikiRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.permissionService = permissionService;
        this.chapterRepository = chapterRepository;
        this.articleRepository = articleRepository;
        this.wikiRepository = wikiRepository;
        this.maxChapterDepth = maxChapterDepth;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @NotNull
    public WikiId getAncestorWikiId(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        WikiId wikiId = (WikiId)this.getAncestorWikiIds(SetsKt.setOf((Object)parentId)).get(parentId);
        if (wikiId == null) {
            throw new WikiNotFoundException((WikiId)parentId);
        }
        return wikiId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, WikiId> getAncestorWikiIds(@NotNull Set<? extends ParentId> parentIds) {
        void $this$associateByTo$iv$iv;
        Object it;
        Chapter it2;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Pair pair = this.groupByType(parentIds);
        Set chapterIds = (Set)pair.component1();
        Set wikiIds = (Set)pair.component2();
        Iterable $this$associate$iv = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            it2 = (Chapter)element$iv$iv;
            boolean bl = false;
            it2 = TuplesKt.to((Object)it2.getId(), (Object)it2.getWikiId());
            map.put(it2.getFirst(), it2.getSecond());
        }
        Map chapterAncestor = destination$iv$iv;
        Iterable $this$forEach$iv = chapterIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ChapterId)element$iv;
            boolean bl = false;
            boolean bl2 = chapterAncestor.containsKey(it);
            if (!_Assertions.ENABLED || bl2) continue;
            boolean bl3 = false;
            throw new ChapterNotFoundException(it);
        }
        Iterable $this$associateBy$iv = wikiIds;
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        it = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void wikiId;
            it2 = (WikiId)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            map.put(wikiId, element$iv$iv);
        }
        Map wikiAncestor = destination$iv$iv2;
        return MapsKt.plus((Map)wikiAncestor, (Map)chapterAncestor);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<AbstractId> getDescendants(@NotNull WikiId wikiId) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Iterable $this$map$iv = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Chapter chapter = (Chapter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Set chapters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.articleRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article bl = (Article)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getId());
        }
        Set articles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return SetsKt.plus((Set)chapters, (Iterable)articles);
    }

    @NotNull
    public List<Ancestor> getAncestors(@NotNull ParentId firstAncestor) {
        Intrinsics.checkNotNullParameter((Object)firstAncestor, (String)"firstAncestor");
        return this.getAncestors(SetsKt.setOf((Object)firstAncestor)).getOrDefault(firstAncestor, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<Ancestor>> getAncestors(@NotNull Set<? extends ParentId> firstAncestor) {
        Intrinsics.checkNotNullParameter(firstAncestor, (String)"firstAncestor");
        Map loadedAncestors = this.loadAncestors(firstAncestor);
        Iterable $this$associateWith$iv = firstAncestor;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ParentId parentId = (ParentId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            ParentId ancestorId = it;
            List ancestors = new ArrayList();
            while (ancestorId != null) {
                Ancestor ancestor;
                if ((Ancestor)loadedAncestors.get(ancestorId) == null) {
                    throw new ParentNotFoundException(ancestorId);
                }
                ancestors.add(0, ancestor);
                ancestorId = this.getParentId(ancestor);
            }
            List list = ancestors;
            map.put(t, list);
        }
        return result$iv;
    }

    private ParentId getParentId(Ancestor $this$getParentId) {
        return $this$getParentId instanceof Chapter ? Chapter.Companion.getParent((Chapter)$this$getParentId) : null;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ParentId, Ancestor> loadAncestors(Set<? extends ParentId> firstAncestors) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Set wikiIds;
        Object object2;
        if (firstAncestors.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map loadedAncestors = new LinkedHashMap();
        Set parentWikiIds = new LinkedHashSet();
        Set nextParentIds = firstAncestors;
        while (!((Collection)nextParentIds).isEmpty()) {
            Set set;
            object2 = this.groupByType(nextParentIds);
            Set chapterIds = (Set)object2.component1();
            wikiIds = (Set)object2.component2();
            parentWikiIds.addAll(wikiIds);
            if (chapterIds.isEmpty()) {
                set = SetsKt.emptySet();
            } else {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                ParentId it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$associateByTo$iv$iv;
                Map $this$associateBy$iv;
                Iterable iterable = ChapterRepository.findByIds$default((ChapterRepository)this.chapterRepository, (Set)chapterIds, null, (int)2, null);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
                void var11_14 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it2;
                    Chapter chapter = (Chapter)element$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.put(it2.getId(), element$iv$iv);
                }
                Map it3 = $this$associateBy$iv = destination$iv$iv;
                boolean $i$a$-also-AncestorService$loadAncestors$32 = false;
                loadedAncestors.putAll(it3);
                boolean $i$f$map = false;
                void $i$a$-also-AncestorService$loadAncestors$32 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    Object element$iv$iv;
                    element$iv$iv = item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    object.add(Chapter.Companion.getParent((Chapter)it.getValue()));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
                    it = (ParentId)element$iv$iv;
                    boolean bl = false;
                    if (!(!loadedAncestors.containsKey(it))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
            }
            nextParentIds = set;
        }
        object2 = this.wikiRepository.findByIds(parentWikiIds);
        object = loadedAncestors;
        boolean $i$f$mapValues = false;
        wikiIds = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Wiki wiki;
            void it$iv$iv;
            Map.Entry element$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            Wiki wiki2 = wiki = (Wiki)entry.getValue();
            map2.put(k, wiki2);
        }
        object.putAll(destination$iv$iv);
        return loadedAncestors;
    }

    private Pair<Set<ChapterId>, Set<WikiId>> groupByType(Set<? extends ParentId> $this$groupByType) {
        Set chapterIds = new LinkedHashSet();
        Set wikiIds = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$groupByType;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            ParentId it = (ParentId)element$iv;
            boolean bl2 = false;
            ParentId parentId = it;
            if (parentId instanceof WikiId) {
                bl = wikiIds.add(it);
                continue;
            }
            if (parentId instanceof ChapterId) {
                bl = chapterIds.add(it);
                continue;
            }
            throw new IllegalArgumentException("Unsupported parent type: " + it.type());
        }
        return new Pair((Object)chapterIds, (Object)wikiIds);
    }

    @Transactional
    public void updateEditedStatusForAncestors(@NotNull ParentId parentId, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        this.updateEditedStatusForAncestors(SetsKt.setOf((Object)parentId), updatedAt, updatedBy);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateEditedStatusForAncestors(@NotNull Set<? extends ParentId> parentIds, @NotNull Instant updatedAt, @NotNull ProfileId updatedBy) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)updatedBy, (String)"updatedBy");
        Iterable iterable = CollectionsKt.flatten((Iterable)this.getAncestors(parentIds).values());
        AncestorService ancestorService = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Ancestor ancestor = (Ancestor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        Pair pair = ancestorService.groupByType(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Set parentChaptersIds = (Set)pair.component1();
        Set parentWikiIds = (Set)pair.component2();
        WikiId parentWikiId = (WikiId)CollectionsKt.first((Iterable)parentWikiIds);
        this.chapterRepository.setUpdatedStatus(parentChaptersIds, updatedBy, updatedAt);
        this.wikiRepository.setUpdatedStatus(parentWikiId, updatedBy, updatedAt);
        this.transactionUtils.afterCommit(() -> AncestorService.updateEditedStatusForAncestors$lambda$15(this, parentWikiId, parentChaptersIds));
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public boolean moveChapter(@NotNull ChapterId chapterId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        List updatedChapters;
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Chapter chapter = (Chapter)this.chapterRepository.getReferenceById((Object)chapterId);
        Intrinsics.checkNotNull((Object)chapter);
        ParentId oldParentId = Chapter.Companion.getParent(chapter);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)chapter.getParentId()) && toParent.type() == chapter.getParentType()) {
            return false;
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)chapter.getId());
        WikiId toWikiId = this.getAncestorWikiId(toParent);
        Set chaptersToUpdate = new LinkedHashSet();
        if (!Intrinsics.areEqual((Object)toWikiId, (Object)chapter.getWikiId())) {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            Collection collection;
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv = this.getDescendantChapters(chapter.getWikiId(), (ParentId)chapterId);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void childChapter;
                void var18_29;
                Chapter chapter2 = (Chapter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2417_u24lambda_u2416 = var18_29 = childChapter;
                boolean bl2 = false;
                $this$moveChapter_u24lambda_u2417_u24lambda_u2416.setWikiId(toWikiId);
                collection.add(var18_29);
            }
            updatedChapters = (List)destination$iv$iv;
            chaptersToUpdate.addAll(updatedChapters);
            Iterable $this$map$iv2 = updatedChapters;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                Chapter bl = (Chapter)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it.getId());
            }
            Set parentIds = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)), (Iterable)SetsKt.setOf((Object)chapterId));
            Iterable $this$map$iv3 = CollectionsKt.flatten((Iterable)this.articleRepository.findByParentIds(parentIds).values());
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void article;
                void var20_35;
                Article bl3 = (Article)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                void $this$moveChapter_u24lambda_u2420_u24lambda_u2419 = var20_35 = article;
                boolean bl4 = false;
                $this$moveChapter_u24lambda_u2420_u24lambda_u2419.setWikiId(toWikiId);
                collection.add(var20_35);
            }
            List updatedArticles = (List)destination$iv$iv3;
            if (!((Collection)updatedArticles).isEmpty()) {
                this.articleRepository.saveAll((Iterable)updatedArticles);
                Iterable $this$forEach$iv = updatedArticles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Article it = (Article)element$iv;
                    boolean bl = false;
                    this.permissionService.removePermissionsForDeletedArticle(it.getId());
                    this.permissionService.addPermissionItemForNewArticle(it.getId(), toWikiId);
                }
                this.transactionUtils.afterCommit(() -> AncestorService.moveChapter$lambda$23(updatedArticles, this));
            }
            chapter.setWikiId(toWikiId);
            chapter.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
        } else {
            chapter.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        chapter.setParentId(toParent.getId());
        chapter.setParentType(toParent.type());
        chaptersToUpdate.add(chapter);
        updatedChapters = this.chapterRepository.saveAll((Iterable)chaptersToUpdate);
        Intrinsics.checkNotNull((Object)updatedChapters);
        Instant instant = ((Chapter)CollectionsKt.last((List)updatedChapters)).getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit(() -> AncestorService.moveChapter$lambda$25(chaptersToUpdate, this));
        return true;
    }

    @Transactional
    public boolean moveArticle(@NotNull ArticleId articleId, @Nullable ParentId toParent, @NotNull ProfileId updater) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        Intrinsics.checkNotNull((Object)article);
        ParentId oldParentId = Article.Companion.getParent(article);
        if (toParent == null || Intrinsics.areEqual((Object)toParent.getId(), (Object)article.getParentId()) && toParent.type() == article.getParentType()) {
            return false;
        }
        this.checkValidMove$wiki_service(toParent, (AbstractId)article.getId());
        WikiId $this$moveArticle_u24lambda_u2426 = this.getAncestorWikiId(toParent);
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)$this$moveArticle_u24lambda_u2426, (Object)article.getWikiId())) {
            article.setWikiId($this$moveArticle_u24lambda_u2426);
            article.setRelativePosition(Integer.valueOf(this.getPreviousPositionForParent(toParent)));
            this.permissionService.removePermissionsForDeletedArticle(articleId);
            this.permissionService.addPermissionItemForNewArticle(articleId, (WikiId)toParent);
        } else {
            article.setRelativePosition(Integer.valueOf(this.getNextPositionForParent(toParent)));
        }
        article.setParentId(toParent.getId());
        article.setParentType(toParent.type());
        Article updatedArticle = (Article)this.articleRepository.save((Object)article);
        Instant instant = updatedArticle.getUpdatedAt();
        if (instant == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Instant updatedAt = instant;
        this.updateEditedStatusForAncestors(oldParentId, updatedAt, updater);
        this.transactionUtils.afterCommit(() -> AncestorService.moveArticle$lambda$27(this, articleId));
        return true;
    }

    public void checkValidMove$wiki_service(@NotNull ParentId toParent, @NotNull AbstractId movedElement) {
        Intrinsics.checkNotNullParameter((Object)toParent, (String)"toParent");
        Intrinsics.checkNotNullParameter((Object)movedElement, (String)"movedElement");
        ParentId parentId = toParent;
        if (parentId instanceof ChapterId) {
            if (!this.chapterRepository.existsById((Object)toParent)) {
                throw new ChapterNotFoundException((ChapterId)toParent);
            }
            if (movedElement.type() == IdType.WIKI_CHAPTER) {
                List parentAncestors = this.getAncestors(toParent);
                int parentChaptersNestingDepth = parentAncestors.size() - 1;
                int childrenChaptersNestingDepth = this.getMaxChildrenChaptersNestingDepth(movedElement);
                this.checkMaxNestingDepth(parentChaptersNestingDepth, childrenChaptersNestingDepth);
                this.checkCircularAncestry(parentAncestors, movedElement);
            }
        } else if (parentId instanceof WikiId) {
            if (!this.wikiRepository.existsById((Object)toParent)) {
                throw new WikiNotFoundException((WikiId)toParent);
            }
        } else {
            throw new IllegalArgumentException(toParent.type() + " is not a known parent type");
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getMaxChildrenChaptersNestingDepth(AbstractId childrenId) {
        int n;
        if (childrenId instanceof ParentId) {
            void var2_2;
            int depth = 0;
            Set nextParentIds = SetsKt.setOf((Object)childrenId);
            while (!((Collection)nextParentIds).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Map children = ChapterRepository.findByParentIds$default((ChapterRepository)this.chapterRepository, (Set)nextParentIds, null, (int)2, null);
                Iterable iterable = CollectionsKt.flatten((Iterable)children.values());
                boolean $i$f$map = false;
                void var7_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Chapter chapter = (Chapter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ParentId parentId = (ParentId)it.getId();
                    if (parentId == null) {
                        throw new ParentNotFoundException(null, 1, null);
                    }
                    collection.add(parentId);
                }
                nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                ++depth;
            }
            n = var2_2;
        } else {
            n = 0;
        }
        return n;
    }

    public void checkMaxNestingDepthOfNewChapter(@NotNull ParentId parentId) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        int parentChaptersNestingDepth = this.getAncestors(parentId).size() - 1;
        this.checkMaxNestingDepth(parentChaptersNestingDepth, 1);
    }

    private void checkMaxNestingDepth(int parentChaptersNestingDepth, int childrenChaptersNestingDepth) {
        if (parentChaptersNestingDepth + childrenChaptersNestingDepth > this.maxChapterDepth) {
            throw new ChapterNestingException("Maximum chapter nesting level " + this.maxChapterDepth + " reached");
        }
    }

    private void checkCircularAncestry(List<? extends Ancestor> parentAncestors, AbstractId movedElement) {
        boolean hasCircularAncestry;
        block4: {
            Iterable $this$any$iv = parentAncestors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Ancestor it = (Ancestor)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)movedElement)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = hasCircularAncestry = false;
            }
        }
        if (hasCircularAncestry) {
            throw new CircularyAncestryException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getNextPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMax = n != null ? n : -1;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMax = n2 != null ? n2 : -1;
        return Math.max(chapterPositionMax, articlePositionMax) + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public int getPreviousPositionForParent(@NotNull ParentId parentId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNull$iv2;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2;
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Map map = this.chapterRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv2 = (List)destination$iv$iv;
        boolean $i$f$mapNotNull22 = false;
        $this$flatMapTo$iv$iv2 = $this$mapNotNull$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach22 = false;
        list$iv$iv = $this$forEach$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
            boolean bl = false;
            Chapter it = (Chapter)element$iv$iv;
            boolean bl2 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv));
        int chapterPositionMin = n != null ? n : 0;
        Map $i$f$mapNotNull22 = this.articleRepository.findAllByParentIds(SetsKt.setOf((Object)parentId));
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        Iterator $i$f$forEach22 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while ($i$f$forEach22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$forEach22.next();
            boolean bl = false;
            Iterable list$iv$iv2 = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl4 = false;
            if (it.getRelativePosition() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Integer n2 = (Integer)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv2));
        int articlePositionMin = n2 != null ? n2 : 0;
        return Math.min(chapterPositionMin, articlePositionMin) - 1;
    }

    /*
     * WARNING - void declaration
     */
    private Set<Chapter> getDescendantChapters(WikiId wikiId, ParentId parentId) {
        Set allChapters = this.chapterRepository.findAllByWikiIdAndDeletionIdIsNull(wikiId);
        Set result = new LinkedHashSet();
        Set nextParentIds = null;
        nextParentIds = SetsKt.setOf((Object)parentId.getId());
        while (!((Collection)nextParentIds).isEmpty()) {
            void $this$mapTo$iv$iv;
            Chapter it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allChapters;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Chapter)element$iv$iv;
                boolean bl = false;
                if (!nextParentIds.contains(it.getParentId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            result.addAll(children);
            Iterable $this$map$iv = children;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Chapter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId().getId());
            }
            nextParentIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result;
    }

    private static final Unit updateEditedStatusForAncestors$lambda$15(AncestorService this$0, WikiId $parentWikiId, Set $parentChaptersIds) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$parentWikiId, (String)"$parentWikiId");
        Intrinsics.checkNotNullParameter((Object)$parentChaptersIds, (String)"$parentChaptersIds");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new WikiModifiedEvent($parentWikiId));
        Iterable $this$forEach$iv = $parentChaptersIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChapterId it = (ChapterId)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveChapter$lambda$23(List $updatedArticles, AncestorService this$0) {
        Intrinsics.checkNotNullParameter((Object)$updatedArticles, (String)"$updatedArticles");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $updatedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent(it.getId()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveChapter$lambda$25(Set $chaptersToUpdate, AncestorService this$0) {
        Intrinsics.checkNotNullParameter((Object)$chaptersToUpdate, (String)"$chaptersToUpdate");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $chaptersToUpdate;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Chapter it = (Chapter)element$iv;
            boolean bl = false;
            this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ChapterModifiedEvent(it.getId()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit moveArticle$lambda$27(AncestorService this$0, ArticleId $articleId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$articleId, (String)"$articleId");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new ArticleUpdatedEvent($articleId));
        return Unit.INSTANCE;
    }
}

