/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.training;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.searchltr.config.SearchLTRConfigProperties;
import de.justsoftware.searchltr.config.ZookeeperService;
import de.justsoftware.searchltr.persistence.DBSearchResult;
import de.justsoftware.searchltr.persistence.SearchResultRepository;
import de.justsoftware.searchltr.solr.LTRFeatureDefinition;
import de.justsoftware.searchltr.solr.LTRLinearModelWeightsParams;
import de.justsoftware.searchltr.solr.LTRModel;
import de.justsoftware.searchltr.solr.LTRModelFeature;
import de.justsoftware.searchltr.solr.Solrs;
import de.justsoftware.searchltr.training.TrainingService;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 22\u00020\u0001:\u00012B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u001e\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0012J\b\u0010\u001c\u001a\u00020\u0013H\u0012J\u0016\u0010\u001d\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0012J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0012J,\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0012J6\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020#2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0012J\b\u0010(\u001a\u00020\u0013H\u0012J\u0016\u0010)\u001a\u00020\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\u001aH\u0012J$\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010-0,2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001aH\u0012J,\u0010.\u001a\u00020\u00132\f\u0010*\u001a\b\u0012\u0004\u0012\u00020#0\u001a2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010-0,H\u0012J\b\u00100\u001a\u000201H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0092\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/searchltr/training/TrainingService;", "", "searchResultRepository", "Lde/justsoftware/searchltr/persistence/SearchResultRepository;", "searchLTRConfigProperties", "Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;", "zookeeperService", "Lde/justsoftware/searchltr/config/ZookeeperService;", "solr", "Lde/justsoftware/searchltr/solr/Solrs;", "outputPath", "", "<init>", "(Lde/justsoftware/searchltr/persistence/SearchResultRepository;Lde/justsoftware/searchltr/config/SearchLTRConfigProperties;Lde/justsoftware/searchltr/config/ZookeeperService;Lde/justsoftware/searchltr/solr/Solrs;Ljava/lang/String;)V", "trainingSamplesFile", "trainingModelFile", "trainingThread", "Ljava/lang/Thread;", "train", "", "prepareTraining", "uploadSolrLTRModel", "model", "Lde/justsoftware/searchltr/solr/LTRModel;", "createSolrLTRModel", "featureNames", "", "upcomingFeatureStoreName", "performTraining", "generateTrainingFile", "writeTrainingSamples", "out", "Ljava/io/PrintWriter;", "writeTrainingSamplesByQueryId", "results", "Lde/justsoftware/searchltr/persistence/DBSearchResult;", "writeTrainingSample", "sign", "result1", "result2", "calculateRelevances", "calculateRelevancesForQuery", "queryResults", "calculateRelativeRelevances", "", "", "updateSearchResultsRelevanceAndProcessed", "relavances", "isTraining", "", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nTrainingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrainingService.kt\nde/justsoftware/searchltr/training/TrainingService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 LoggerUtils.kt\nde/justsoftware/searchltr/util/LoggerUtilsKt\n*L\n1#1,310:1\n1557#2:311\n1628#2,3:312\n1863#2,2:316\n1872#2,3:318\n1485#2:321\n1510#2,3:322\n1513#2,3:332\n1863#2,2:335\n388#2,7:337\n1187#2,2:344\n1261#2,4:346\n1863#2,2:350\n1557#2:352\n1628#2,3:353\n1#3:315\n381#4,7:325\n9#5:356\n8#5,3:357\n*S KotlinDebug\n*F\n+ 1 TrainingService.kt\nde/justsoftware/searchltr/training/TrainingService\n*L\n118#1:311\n118#1:312,3\n154#1:316,2\n204#1:318,3\n228#1:321\n228#1:322,3\n228#1:332,3\n230#1:335,2\n253#1:337,7\n265#1:344,2\n265#1:346,4\n282#1:350,2\n60#1:352\n60#1:353,3\n228#1:325,7\n305#1:356\n305#1:357,3\n*E\n"})
public class TrainingService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SearchResultRepository searchResultRepository;
    @NotNull
    private final SearchLTRConfigProperties searchLTRConfigProperties;
    @NotNull
    private final ZookeeperService zookeeperService;
    @NotNull
    private final Solrs solr;
    @NotNull
    private final String outputPath;
    @NotNull
    private final String trainingSamplesFile;
    @NotNull
    private final String trainingModelFile;
    @Nullable
    private Thread trainingThread;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final ObjectMapper mapper;
    private static final DateTimeFormatter DATE_FORMATTER;

    public TrainingService(@NotNull SearchResultRepository searchResultRepository, @NotNull SearchLTRConfigProperties searchLTRConfigProperties, @NotNull ZookeeperService zookeeperService, @NotNull Solrs solr, @Value(value="${search-ltr.training.outputPath}") @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)searchResultRepository, (String)"searchResultRepository");
        Intrinsics.checkNotNullParameter((Object)searchLTRConfigProperties, (String)"searchLTRConfigProperties");
        Intrinsics.checkNotNullParameter((Object)zookeeperService, (String)"zookeeperService");
        Intrinsics.checkNotNullParameter((Object)solr, (String)"solr");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.searchResultRepository = searchResultRepository;
        this.searchLTRConfigProperties = searchLTRConfigProperties;
        this.zookeeperService = zookeeperService;
        this.solr = solr;
        this.outputPath = outputPath;
        this.trainingSamplesFile = this.outputPath + "/trainingSamples.txt";
        this.trainingModelFile = this.outputPath + "/trainingModel.txt";
    }

    public void train() {
        if (this.isTraining()) {
            throw new IllegalStateException("Training is already in progress".toString());
        }
        this.trainingThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> TrainingService.train$lambda$2(this), (int)31, null);
    }

    public void prepareTraining() {
        Instant instant = Instant.now().minusMillis(31536000000L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minusMillis(...)");
        this.searchResultRepository.deleteBySearchTimeBefore(instant);
        this.calculateRelevances();
    }

    private void uploadSolrLTRModel(LTRModel model) {
        block0: {
            LOG.info("Uploading Solr LTR model: " + model.getName());
            LOG.debug(mapper.writeValueAsString((Object)model));
            this.solr.uploadLTRModel(model);
            String modelNameBeforeUpdate = this.searchLTRConfigProperties.getModelName();
            LOG.info("Persisting new trained model name " + model.getName() + " into Zookeeper");
            this.zookeeperService.storeModelName(model.getName());
            String string = modelNameBeforeUpdate;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            LOG.info("Deleting old Solr LTR model: " + modelNameBeforeUpdate);
            this.solr.deleteLTRModel(modelNameBeforeUpdate);
        }
    }

    /*
     * WARNING - void declaration
     */
    private LTRModel createSolrLTRModel(List<String> featureNames, String upcomingFeatureStoreName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = DATE_FORMATTER.format(LocalDateTime.now());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String timeString = string;
        String solrModelName = "justSearchModel_" + timeString;
        LOG.info("Generating Solr LTR model: " + solrModelName);
        Ref.IntRef i = new Ref.IntRef();
        Ref.BooleanRef readingWeights = new Ref.BooleanRef();
        Map featureWeights = new LinkedHashMap();
        FilesKt.forEachLine$default((File)new File(this.trainingModelFile), null, arg_0 -> TrainingService.createSolrLTRModel$lambda$4(readingWeights, featureWeights, featureNames, i, arg_0), (int)1, null);
        Iterable iterable = featureWeights.keySet();
        boolean $i$f$map = false;
        void var11_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LTRModelFeature((String)it));
        }
        List modelFeatures = (List)destination$iv$iv;
        LTRLinearModelWeightsParams params = new LTRLinearModelWeightsParams(featureWeights);
        return new LTRModel(upcomingFeatureStoreName, solrModelName, modelFeatures, params);
    }

    private void performTraining() {
        LOG.info("Generating trained model: " + this.trainingModelFile);
        String[] stringArray = new String[]{"./bin/train", "-q", this.trainingSamplesFile, this.trainingModelFile};
        new ProcessBuilder(stringArray).start().waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTrainingFile(List<String> featureNames) {
        LOG.info("Generating training file: " + this.trainingSamplesFile);
        File folder = new File(this.outputPath);
        folder.mkdirs();
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IOException("Could not create training directory.");
        }
        File file = new File(this.trainingSamplesFile);
        Object object = file;
        Object object2 = Charsets.UTF_8;
        File file2 = object;
        int n = 8192;
        Object object3 = file2;
        object = new PrintWriter((object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter out = (PrintWriter)object;
            boolean bl = false;
            this.writeTrainingSamples(out, featureNames);
            file2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private void writeTrainingSamples(PrintWriter out, List<String> featureNames) {
        Page relevantResults;
        String[] stringArray = new String[]{"queryId", "resultPosition"};
        PageRequest page = PageRequest.of((int)0, (int)1000, (Sort)Sort.by((String[])stringArray));
        ArrayList<DBSearchResult> queryResults = null;
        queryResults = new ArrayList<DBSearchResult>();
        UUID currentQueryId = null;
        do {
            PageRequest pageRequest = page;
            Intrinsics.checkNotNull((Object)pageRequest);
            relevantResults = this.searchResultRepository.findByProcessedTrueAndRelevanceNotNull((Pageable)pageRequest);
            Iterable $this$forEach$iv = (Iterable)relevantResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DBSearchResult searchResult = (DBSearchResult)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(currentQueryId, (Object)searchResult.getQueryId())) {
                    this.writeTrainingSamplesByQueryId(out, (List)queryResults, featureNames);
                    currentQueryId = searchResult.getQueryId();
                    queryResults = new ArrayList();
                    continue;
                }
                queryResults.add(searchResult);
            }
            page = page.next();
        } while (relevantResults.hasNext());
        this.writeTrainingSamplesByQueryId(out, (List)queryResults, featureNames);
    }

    private void writeTrainingSamplesByQueryId(PrintWriter out, List<DBSearchResult> results, List<String> featureNames) {
        if (results.isEmpty()) {
            return;
        }
        int n = ((Collection)results).size();
        for (int r1 = 0; r1 < n; ++r1) {
            int n2 = results.size();
            for (int r2 = r1 + 1; r2 < n2; ++r2) {
                DBSearchResult result1 = results.get(r1);
                DBSearchResult result2 = results.get(r2);
                Float f = result1.getRelevance();
                Intrinsics.checkNotNull((Object)f);
                float f2 = f.floatValue();
                Float f3 = result2.getRelevance();
                Intrinsics.checkNotNull((Object)f3);
                if (f2 > f3.floatValue()) {
                    this.writeTrainingSample(out, "+1", result1, result2, featureNames);
                    this.writeTrainingSample(out, "-1", result2, result1, featureNames);
                    continue;
                }
                Float f4 = result1.getRelevance();
                Intrinsics.checkNotNull((Object)f4);
                float f5 = f4.floatValue();
                Float f6 = result2.getRelevance();
                Intrinsics.checkNotNull((Object)f6);
                if (!(f5 < f6.floatValue())) continue;
                this.writeTrainingSample(out, "+1", result2, result1, featureNames);
                this.writeTrainingSample(out, "-1", result1, result2, featureNames);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeTrainingSample(PrintWriter out, String sign, DBSearchResult result1, DBSearchResult result2, List<String> featureNames) {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator(',');
        DecimalFormat decimalFormat = new DecimalFormat("#.########", otherSymbols);
        Object featuresString = null;
        featuresString = "";
        Iterable $this$forEachIndexed$iv = featureNames;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void name;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            if (!result1.getFeatures().containsKey(name) && !result2.getFeatures().containsKey(name)) continue;
            Object v = result1.getFeatures().get(name);
            Intrinsics.checkNotNull(v);
            float f1 = ((Number)v).floatValue();
            Object v2 = result2.getFeatures().get(name);
            Intrinsics.checkNotNull(v2);
            float f2 = ((Number)v2).floatValue();
            if (f1 - f2 == 0.0f) continue;
            featuresString = featuresString + " " + (index + 1) + ":" + decimalFormat.format(Float.valueOf(f1 - f2));
        }
        if (!Intrinsics.areEqual((Object)featuresString, (Object)"")) {
            out.println(sign + featuresString + " # qid=" + result1.getQueryId() + " r1=" + result1.getResultId() + " r2=" + result2.getResultId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calculateRelevances() {
        Page unprocessedQueryIds;
        LOG.info("Calculate and update document relevances in database");
        Instant minAgeTimestamp = Instant.now().minusSeconds(3600L);
        do {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNull((Object)minAgeTimestamp);
            Pageable pageable = Pageable.ofSize((int)100);
            Intrinsics.checkNotNullExpressionValue((Object)pageable, (String)"ofSize(...)");
            unprocessedQueryIds = this.searchResultRepository.findUnprocessedQueryId(minAgeTimestamp, pageable);
            if (!unprocessedQueryIds.hasContent()) continue;
            Iterable $this$groupBy$iv = this.searchResultRepository.findByQueryIds((Iterable)unprocessedQueryIds);
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DBSearchResult p0 = (DBSearchResult)element$iv$iv;
                boolean bl = false;
                UUID key$iv$iv = p0.getQueryId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = destination$iv$iv.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List p0 = (List)element$iv;
                boolean bl = false;
                this.calculateRelevancesForQuery(p0);
            }
        } while (unprocessedQueryIds.hasNext());
    }

    private void calculateRelevancesForQuery(List<DBSearchResult> queryResults) {
        if (queryResults.isEmpty()) {
            return;
        }
        Map relavances = this.calculateRelativeRelevances(queryResults);
        this.updateSearchResultsRelevanceAndProcessed(queryResults, relavances);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Float> calculateRelativeRelevances(List<DBSearchResult> results) {
        void $this$associateTo$iv$iv;
        int n;
        block3: {
            if (results.size() < 2) {
                LOG.debug("Skip calculating relevances for query " + results.get(0).getQueryId() + ", not enough comparable documents (" + results.size() + "), calculating relative relevances not possible");
                return MapsKt.emptyMap();
            }
            List<DBSearchResult> $this$indexOfLast$iv = results;
            boolean $i$f$indexOfLast = false;
            ListIterator<DBSearchResult> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                DBSearchResult result = iterator$iv.previous();
                boolean bl = false;
                if (!result.getClicked()) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = -1;
        }
        int lastClickedResult = n;
        int assumedMinNumberViewed = Math.min(3, results.size());
        int numberOfComparableResults = Math.max(assumedMinNumberViewed, lastClickedResult + 1);
        List<DBSearchResult> comparableResults = results.subList(0, numberOfComparableResults);
        LOG.debug("Calculating relevances from clicks for " + comparableResults.size() + " results of query " + results.get(0).getQueryId());
        Iterable $this$associate$iv = comparableResults;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            DBSearchResult it = (DBSearchResult)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getResultId(), (Object)Float.valueOf(it.getClicked() ? 1.0f + (float)it.getResultPosition() : 0.0f));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private void updateSearchResultsRelevanceAndProcessed(List<DBSearchResult> queryResults, Map<String, Float> relavances) {
        ArrayList<DBSearchResult> relevantResults = new ArrayList<DBSearchResult>();
        ArrayList<DBSearchResult> irrelevantResults = new ArrayList<DBSearchResult>();
        Iterable $this$forEach$iv = queryResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            DBSearchResult it = (DBSearchResult)element$iv;
            boolean bl2 = false;
            Float calculatedRelevance = relavances.get(it.getResultId());
            if (calculatedRelevance != null) {
                it.setProcessed(true);
                it.setRelevance(calculatedRelevance);
                bl = relevantResults.add(it);
                continue;
            }
            bl = irrelevantResults.add(it);
        }
        if (!((Collection)relevantResults).isEmpty()) {
            this.searchResultRepository.saveAllAndFlush((Iterable)relevantResults);
        }
        if (!((Collection)irrelevantResults).isEmpty()) {
            this.searchResultRepository.deleteAll((Iterable)irrelevantResults);
        }
    }

    public boolean isTraining() {
        Thread thread = this.trainingThread;
        return thread != null ? thread.isAlive() : false;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit train$lambda$2(TrainingService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            void $this$mapTo$iv$iv;
            Instant startTime = Instant.now();
            this$0.prepareTraining();
            String string = this$0.searchLTRConfigProperties.getUpcomingFeaturesStoreName();
            if (string == null) {
                boolean $i$a$-checkNotNull-TrainingService$train$1$upcomingFeatureStoreName$22 = false;
                String $i$a$-checkNotNull-TrainingService$train$1$upcomingFeatureStoreName$22 = "Failed to train - could not load upcoming feature store name from Zookeeper";
                throw new IllegalStateException($i$a$-checkNotNull-TrainingService$train$1$upcomingFeatureStoreName$22.toString());
            }
            String upcomingFeatureStoreName = string;
            List featureDefinitions = this$0.solr.getLeaderSolrClient().ltrFeatureDefinitions(upcomingFeatureStoreName);
            Iterable $this$map$iv = featureDefinitions;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LTRFeatureDefinition lTRFeatureDefinition = (LTRFeatureDefinition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            List featureNames = (List)destination$iv$iv;
            this$0.generateTrainingFile(featureNames);
            this$0.performTraining();
            LTRModel model = this$0.createSolrLTRModel(featureNames, upcomingFeatureStoreName);
            this$0.uploadSolrLTRModel(model);
            Instant endTime = Instant.now();
            LOG.info("Successfully trained in " + (endTime.toEpochMilli() - startTime.toEpochMilli()) + " ms");
        }
        catch (Exception ex) {
            LOG.error("Error while train new store model. Exception thrown:", (Throwable)ex);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createSolrLTRModel$lambda$4(Ref.BooleanRef $readingWeights, Map $featureWeights, List $featureNames, Ref.IntRef $i, String it) {
        Intrinsics.checkNotNullParameter((Object)$readingWeights, (String)"$readingWeights");
        Intrinsics.checkNotNullParameter((Object)$featureWeights, (String)"$featureWeights");
        Intrinsics.checkNotNullParameter((Object)$featureNames, (String)"$featureNames");
        Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($readingWeights.element) {
            if (!(Double.parseDouble(it) == 0.0)) {
                $featureWeights.put($featureNames.get($i.element), Double.parseDouble(it));
            }
            int n = $i.element;
            $i.element = n + 1;
        } else if (Intrinsics.areEqual((Object)it, (Object)"w")) {
            $readingWeights.element = true;
        }
        return Unit.INSTANCE;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        mapper = new ObjectMapper();
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    }
}

