/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.searchltr.solr;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import de.justsoftware.searchltr.solr.LTRFeatureDefinition;
import de.justsoftware.searchltr.solr.LTRModel;
import de.justsoftware.searchltr.solr.SolrClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0003J\u0014\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\tJ\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\tJ\u0006\u0010\u0017\u001a\u00020\rJ\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\rH\u0002J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/searchltr/solr/SolrClient;", "", "commonCoreUrl", "", "<init>", "(Ljava/lang/String;)V", "getCommonCoreUrl", "()Ljava/lang/String;", "ltrFeatureDefinitions", "", "Lde/justsoftware/searchltr/solr/LTRFeatureDefinition;", "storeName", "uploadLTRModel", "", "model", "Lde/justsoftware/searchltr/solr/LTRModel;", "deleteLTRModel", "modelName", "deleteLTRFeatureDefinitions", "uploadLTRFeatureDefinitions", "featureDefinitions", "getAllLTRModels", "getAllLTRFeatureStores", "deleteAllLTRModelsAndFeatures", "deleteAllLTRModels", "deleteAllLTRFeatures", "ping", "", "Companion", "search-ltr"})
@SourceDebugExtension(value={"SMAP\nSolrClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrClient.kt\nde/justsoftware/searchltr/solr/SolrClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1557#2:97\n1628#2,3:98\n1557#2:101\n1628#2,3:102\n1557#2:105\n1628#2,3:106\n1863#2,2:109\n1863#2,2:111\n*S KotlinDebug\n*F\n+ 1 SolrClient.kt\nde/justsoftware/searchltr/solr/SolrClient\n*L\n18#1:97\n18#1:98,3\n44#1:101\n44#1:102,3\n56#1:105\n56#1:106,3\n68#1:109,2\n75#1:111,2\n*E\n"})
public final class SolrClient {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String commonCoreUrl;
    @NotNull
    private static final ObjectMapper mapper;
    @NotNull
    private static final RestTemplate restTemplate;

    public SolrClient(@NotNull String commonCoreUrl) {
        Intrinsics.checkNotNullParameter((Object)commonCoreUrl, (String)"commonCoreUrl");
        this.commonCoreUrl = commonCoreUrl;
    }

    @NotNull
    public final String getCommonCoreUrl() {
        return this.commonCoreUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LTRFeatureDefinition> ltrFeatureDefinitions(@NotNull String storeName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        ResponseEntity response = restTemplate.getForEntity(this.commonCoreUrl + "/schema/feature-store/" + storeName, String.class, new Object[0]);
        JsonNode jsonNode = mapper.readTree((String)response.getBody()).path("features");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"path(...)");
        Iterable $this$map$iv = (Iterable)jsonNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((LTRFeatureDefinition)mapper.readValue(it.toPrettyString(), LTRFeatureDefinition.class));
        }
        return (List)destination$iv$iv;
    }

    public final void uploadLTRModel(@NotNull LTRModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        restTemplate.put(this.commonCoreUrl + "/schema/model-store", (Object)mapper.writeValueAsString((Object)model), new Object[0]);
    }

    public final void deleteLTRModel(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        restTemplate.delete(this.commonCoreUrl + "/schema/model-store/" + modelName, new Object[0]);
    }

    public final void deleteLTRFeatureDefinitions(@NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        restTemplate.delete(this.commonCoreUrl + "/schema/feature-store/" + storeName, new Object[0]);
    }

    public final void uploadLTRFeatureDefinitions(@NotNull List<LTRFeatureDefinition> featureDefinitions) {
        Intrinsics.checkNotNullParameter(featureDefinitions, (String)"featureDefinitions");
        restTemplate.put(this.commonCoreUrl + "/schema/feature-store", (Object)mapper.writeValueAsString(featureDefinitions), new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllLTRModels() {
        void $this$mapTo$iv$iv;
        ResponseEntity response = restTemplate.getForEntity(this.commonCoreUrl + "/schema/model-store", String.class, new Object[0]);
        JsonNode jsonNode = mapper.readTree((String)response.getBody()).path("models");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"path(...)");
        Iterable $this$map$iv = (Iterable)jsonNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.path("name").asText());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllLTRFeatureStores() {
        void $this$mapTo$iv$iv;
        ResponseEntity response = restTemplate.getForEntity(this.commonCoreUrl + "/schema/feature-store", String.class, new Object[0]);
        JsonNode jsonNode = mapper.readTree((String)response.getBody()).path("featureStores");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"path(...)");
        Iterable $this$map$iv = (Iterable)jsonNode;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asText());
        }
        return (List)destination$iv$iv;
    }

    public final void deleteAllLTRModelsAndFeatures() {
        this.deleteAllLTRModels();
        this.deleteAllLTRFeatures();
    }

    private final void deleteAllLTRModels() {
        List models = this.getAllLTRModels();
        Iterable $this$forEach$iv = models;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.deleteLTRModel(it);
        }
    }

    private final void deleteAllLTRFeatures() {
        List stores = this.getAllLTRFeatureStores();
        Iterable $this$forEach$iv = stores;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.deleteLTRFeatureDefinitions(it);
        }
    }

    public final boolean ping() {
        ResponseEntity response = restTemplate.getForEntity(this.commonCoreUrl + "/admin/ping?wt=json", String.class, new Object[0]);
        return response.getStatusCode() == HttpStatus.OK && Intrinsics.areEqual((Object)mapper.readTree((String)response.getBody()).path("status").asText(), (Object)"OK");
    }

    public static final /* synthetic */ ObjectMapper access$getMapper$cp() {
        return mapper;
    }

    public static final /* synthetic */ RestTemplate access$getRestTemplate$cp() {
        return restTemplate;
    }

    static {
        ObjectMapper objectMapper;
        Companion = new Companion(null);
        ObjectMapper $this$mapper_u24lambda_u245 = objectMapper = new ObjectMapper();
        boolean bl = false;
        $this$mapper_u24lambda_u245.registerModule((Module)new JodaModule());
        $this$mapper_u24lambda_u245.registerModule((Module)new KotlinModule.Builder().build());
        $this$mapper_u24lambda_u245.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper = objectMapper;
        restTemplate = new RestTemplate();
    }
}

