/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.tenant;

import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.tenant.Tenant;
import de.justsoftware.news.domain.tenant.TenantService;
import de.justsoftware.news.id.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/news/kafka/tenant/KafkaTenantConsumer;", "", "tenantService", "Lde/justsoftware/news/domain/tenant/TenantService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "<init>", "(Lde/justsoftware/news/domain/tenant/TenantService;Lde/justsoftware/news/domain/delete/DeleteService;)V", "listen", "", "key", "", "payload", "Lde/justsoftware/news/domain/tenant/Tenant;", "news-service"})
public class KafkaTenantConsumer {
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final DeleteService deleteService;

    public KafkaTenantConsumer(@NotNull TenantService tenantService, @NotNull DeleteService deleteService) {
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        this.tenantService = tenantService;
        this.deleteService = deleteService;
    }

    @KafkaListener(containerFactory="tenantListenerContainerFactory", topics={"just.tenants"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable Tenant payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (payload == null) {
            TenantId tenantId = TenantId.Companion.fromString(key);
            this.deleteService.markAllChannelsAsDeleted(tenantId);
            v0 = this.tenantService.delete(tenantId);
        } else {
            v0 = this.tenantService.upsert(payload);
        }
    }
}

