/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.search;

import de.justsoftware.news.events.ChannelCreatedEvent;
import de.justsoftware.news.events.ChannelDeletedEvent;
import de.justsoftware.news.events.ChannelPermissionChangedEvent;
import de.justsoftware.news.events.ChannelUpdatedEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostUpdatedEvent;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.SearchableItemId;
import de.justsoftware.news.kafka.search.SearchIndexType;
import de.justsoftware.search.shared.SolrIndexQueue;
import de.justsoftware.search.shared.model.SearchType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0019H\u0017J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001bH\u0017J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001cH\u0017J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!H\u0012J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0012R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/news/kafka/search/KafkaSearchProducer;", "", "producer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "Lde/justsoftware/news/id/SearchableItemId;", "Lde/justsoftware/news/kafka/search/SearchIndexType;", "itemChangedProducer", "", "solrIndexQueue", "Lde/justsoftware/search/shared/SolrIndexQueue;", "<init>", "(Lorg/apache/kafka/clients/producer/KafkaProducer;Lorg/apache/kafka/clients/producer/KafkaProducer;Lde/justsoftware/search/shared/SolrIndexQueue;)V", "addToSearchIndexQueue", "", "itemIds", "", "indexChannel", "channelUpdatedEvent", "Lde/justsoftware/news/events/ChannelUpdatedEvent;", "channelEvent", "Lde/justsoftware/news/events/ChannelCreatedEvent;", "indexDeletedChannel", "event", "Lde/justsoftware/news/events/ChannelDeletedEvent;", "indexChannelPermissionChanges", "Lde/justsoftware/news/events/ChannelPermissionChangedEvent;", "indexPost", "Lde/justsoftware/news/events/PostPublishedEvent;", "Lde/justsoftware/news/events/PostUpdatedEvent;", "indexDeletedPost", "Lde/justsoftware/news/events/PostDeletedEvent;", "queueFullIndex", "postId", "Lde/justsoftware/news/id/PostId;", "channelId", "Lde/justsoftware/news/id/ChannelId;", "news-service"})
@SourceDebugExtension(value={"SMAP\nKafkaSearchProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaSearchProducer.kt\nde/justsoftware/news/kafka/search/KafkaSearchProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1863#2,2:122\n1863#2,2:124\n*S KotlinDebug\n*F\n+ 1 KafkaSearchProducer.kt\nde/justsoftware/news/kafka/search/KafkaSearchProducer\n*L\n40#1:122,2\n61#1:124,2\n*E\n"})
public class KafkaSearchProducer {
    @NotNull
    private final KafkaProducer<SearchableItemId, SearchIndexType> producer;
    @NotNull
    private final KafkaProducer<String, String> itemChangedProducer;
    @NotNull
    private final SolrIndexQueue solrIndexQueue;

    public KafkaSearchProducer(@NotNull KafkaProducer<SearchableItemId, SearchIndexType> producer, @NotNull KafkaProducer<String, String> itemChangedProducer, @NotNull SolrIndexQueue solrIndexQueue) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        Intrinsics.checkNotNullParameter(itemChangedProducer, (String)"itemChangedProducer");
        Intrinsics.checkNotNullParameter((Object)solrIndexQueue, (String)"solrIndexQueue");
        this.producer = producer;
        this.itemChangedProducer = itemChangedProducer;
        this.solrIndexQueue = solrIndexQueue;
    }

    public void addToSearchIndexQueue(@NotNull Set<? extends SearchableItemId> itemIds) {
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        Iterable $this$forEach$iv = itemIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchableItemId it = (SearchableItemId)element$iv;
            boolean bl = false;
            this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)it, (Object)SearchIndexType.FULL));
        }
    }

    @Async
    @EventListener
    public void indexChannel(@NotNull ChannelUpdatedEvent channelUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)channelUpdatedEvent, (String)"channelUpdatedEvent");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)channelUpdatedEvent.getChannelId(), (Object)SearchIndexType.FULL));
        this.queueFullIndex(channelUpdatedEvent.getChannelId());
    }

    @Async
    @EventListener
    public void indexChannel(@NotNull ChannelCreatedEvent channelEvent) {
        Intrinsics.checkNotNullParameter((Object)channelEvent, (String)"channelEvent");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)channelEvent.getChannelId(), (Object)SearchIndexType.CONTENT));
        this.queueFullIndex(channelEvent.getChannelId());
    }

    @Async
    @EventListener
    public void indexDeletedChannel(@NotNull ChannelDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getChannelId(), (Object)SearchIndexType.DELETED));
        Iterable $this$forEach$iv = event.getPostIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PostId it = (PostId)element$iv;
            boolean bl = false;
            this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)it, (Object)SearchIndexType.DELETED));
        }
        this.queueFullIndex(event.getChannelId());
    }

    @Async
    @EventListener
    public void indexChannelPermissionChanges(@NotNull ChannelPermissionChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.queueFullIndex(event.getChannelId());
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getChannelId(), (Object)SearchIndexType.PERMISSIONS));
        this.itemChangedProducer.send(new ProducerRecord("just.item.visibilityChanged", (Object)event.getChannelId().toTypedString(), null));
    }

    @Async
    @EventListener
    public void indexPost(@NotNull PostPublishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getPost().getId(), (Object)SearchIndexType.FULL));
        this.queueFullIndex(event.getPost().getId());
        this.itemChangedProducer.send(new ProducerRecord("just.item.visibilityChanged", (Object)event.getPost().getId().toTypedString(), null));
    }

    @Async
    @EventListener
    public void indexPost(@NotNull PostUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getPostId(), (Object)SearchIndexType.FULL));
        this.queueFullIndex(event.getPostId());
    }

    @Async
    @EventListener
    public void indexDeletedPost(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.producer.send(new ProducerRecord("just.news.searchIndexQueue", (Object)event.getPostId(), (Object)SearchIndexType.DELETED));
        this.queueFullIndex(event.getPostId());
        this.itemChangedProducer.send(new ProducerRecord("just.item.visibilityChanged", (Object)event.getPostId().toTypedString(), null));
    }

    private void queueFullIndex(PostId postId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)postId.toSearchableId()), SearchType.NEWS_POST);
    }

    private void queueFullIndex(ChannelId channelId) {
        this.solrIndexQueue.queueFullIndex(CollectionsKt.listOf((Object)channelId.toSearchableId()), SearchType.NEWS_CHANNEL);
    }
}

