/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka.search;

import de.justsoftware.news.connector.search.SearchConnector;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.SearchableItemId;
import de.justsoftware.news.kafka.search.KafkaSearchConsumer;
import de.justsoftware.news.kafka.search.SearchIndexType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 #2\u00020\u0001:\u0002#$B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\r2\u001c\b\u0001\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u000fH\u0017J$\u0010\u0013\u001a\u00020\u00142\u001a\u0010\u000e\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u000fH\u0012J$\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0012J$\u0010\u001b\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017H\u0012J$\u0010 \u001a\u00020\r2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lde/justsoftware/news/kafka/search/KafkaSearchConsumer;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "searchConnector", "Lde/justsoftware/news/connector/search/SearchConnector;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/connector/search/SearchConnector;Lde/justsoftware/news/domain/user/ProfileRepo;)V", "listen", "", "records", "", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "Lde/justsoftware/news/id/SearchableItemId;", "Lde/justsoftware/news/kafka/search/SearchIndexType;", "sortRecords", "Lde/justsoftware/news/kafka/search/KafkaSearchConsumer$SortedRecords;", "removeDeletedChannels", "channelIds", "", "Lde/justsoftware/news/id/ChannelId;", "activeChannels", "Lde/justsoftware/news/domain/channel/Channel;", "removeDeletedPosts", "postIds", "Lde/justsoftware/news/id/PostId;", "activePosts", "Lde/justsoftware/news/domain/post/Post;", "upsertPosts", "posts", "updatedChannels", "Companion", "SortedRecords", "news-service"})
@SourceDebugExtension(value={"SMAP\nKafkaSearchConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaSearchConsumer.kt\nde/justsoftware/news/kafka/search/KafkaSearchConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1863#2,2:135\n1557#2:137\n1628#2,3:138\n827#2:141\n855#2,2:142\n1557#2:144\n1628#2,3:145\n827#2:148\n855#2,2:149\n1557#2:151\n1628#2,3:152\n1202#2,2:155\n1230#2,4:157\n1557#2:161\n1628#2,3:162\n1202#2,2:165\n1230#2,4:167\n*S KotlinDebug\n*F\n+ 1 KafkaSearchConsumer.kt\nde/justsoftware/news/kafka/search/KafkaSearchConsumer\n*L\n81#1:135,2\n104#1:137\n104#1:138,3\n105#1:141\n105#1:142,2\n110#1:144\n110#1:145,3\n111#1:148\n111#1:149,2\n120#1:151\n120#1:152,3\n121#1:155,2\n121#1:157,4\n123#1:161\n123#1:162,3\n124#1:165,2\n124#1:167,4\n*E\n"})
public class KafkaSearchConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final SearchConnector searchConnector;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private static final Logger LOG;

    public KafkaSearchConsumer(@NotNull ChannelRepo channelRepo, @NotNull PostRepo postRepo, @NotNull SearchConnector searchConnector, @NotNull ProfileRepo profileRepo) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)searchConnector, (String)"searchConnector");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        this.channelRepo = channelRepo;
        this.postRepo = postRepo;
        this.searchConnector = searchConnector;
        this.profileRepo = profileRepo;
    }

    @KafkaListener(containerFactory="searchIndexListenerContainerFactory", topics={"just.news.searchIndexQueue"}, groupId="just.news-service.searchIndexConsumer")
    public void listen(@Payload(required=true) @NotNull List<? extends ConsumerRecord<SearchableItemId, SearchIndexType>> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        this.searchConnector.checkSolarAvailability();
        LOG.info("processing " + records.size() + " records");
        SortedRecords sortedRecords = this.sortRecords(records);
        Set postIds = sortedRecords.getPostIds();
        Set channelIds = sortedRecords.getChannelIds();
        Set channelIdsWithUpdatedPermissions = sortedRecords.getChannelIdsWithUpdatedPermissions();
        StopWatch stopWatch = new StopWatch("indexing");
        stopWatch.start("loading " + channelIds.size() + " channels");
        Set activeChannels = this.channelRepo.findByIdInAndDeletedFalse(channelIds);
        stopWatch.stop();
        stopWatch.start("loading " + postIds.size() + " posts");
        Set activePosts = this.postRepo.findByIdInAndDeletedFalse(postIds);
        stopWatch.stop();
        stopWatch.start("sending data to solr");
        this.removeDeletedChannels(channelIds, activeChannels);
        this.removeDeletedPosts(postIds, activePosts);
        this.searchConnector.upsertChannels(activeChannels);
        this.upsertPosts(activePosts, channelIdsWithUpdatedPermissions);
        stopWatch.stop();
        LOG.info(stopWatch.prettyPrint());
    }

    private SortedRecords sortRecords(List<? extends ConsumerRecord<SearchableItemId, SearchIndexType>> records) {
        HashSet<SearchableItemId> postIds = new HashSet<SearchableItemId>();
        HashSet<SearchableItemId> channelIds = new HashSet<SearchableItemId>();
        HashSet<SearchableItemId> channelIdsWithUpdatedPermissions = new HashSet<SearchableItemId>();
        Iterable $this$forEach$iv = records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord it = (ConsumerRecord)element$iv;
            boolean bl = false;
            SearchableItemId itemId = (SearchableItemId)it.key();
            SearchIndexType searchIndexType = (SearchIndexType)it.value();
            SearchableItemId searchableItemId = itemId;
            if (searchableItemId instanceof ChannelId) {
                channelIds.add(itemId);
                if (searchIndexType != SearchIndexType.PERMISSIONS) continue;
                channelIdsWithUpdatedPermissions.add(itemId);
                continue;
            }
            if (searchableItemId instanceof PostId) {
                postIds.add(itemId);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return new SortedRecords((Set)postIds, (Set)channelIds, (Set)channelIdsWithUpdatedPermissions);
    }

    /*
     * WARNING - void declaration
     */
    private void removeDeletedChannels(Set<ChannelId> channelIds, Set<Channel> activeChannels) {
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = activeChannels;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List activeChannelIds = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = channelIds;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ChannelId it = (ChannelId)element$iv$iv;
            boolean bl = false;
            if (activeChannelIds.contains(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv2;
        this.searchConnector.deleteChannels((Collection)toRemove);
    }

    /*
     * WARNING - void declaration
     */
    private void removeDeletedPosts(Set<PostId> postIds, Set<Post> activePosts) {
        void $this$filterNotTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = activePosts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post post = (Post)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List activePostIds = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = postIds;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PostId it = (PostId)element$iv$iv;
            boolean bl = false;
            if (activePostIds.contains(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv2;
        this.searchConnector.deletePosts((Collection)toRemove);
    }

    /*
     * WARNING - void declaration
     */
    private void upsertPosts(Set<Post> posts, Set<ChannelId> updatedChannels) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$associateByTo$iv$iv2;
        void $this$associateBy$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Set postsFromUpdatedChannels = this.postRepo.findByChannelIdInAndDeletedFalse(updatedChannels);
        Set toUpsert = CollectionsKt.union((Iterable)posts, (Iterable)postsFromUpdatedChannels);
        Iterable iterable = toUpsert;
        Object object = this.channelRepo;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Post post = (Post)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChannelId());
        }
        $this$map$iv2 = object.getByIdInAndDeletedFalse((Collection)((List)destination$iv$iv));
        boolean $i$f$associateBy22 = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            Channel bl = (Channel)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.put(it.getId(), element$iv$iv);
        }
        Map channels = destination$iv$iv2;
        Iterable capacity$iv22 = toUpsert;
        object = this.profileRepo;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv;
        Object destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Post bl2 = (Post)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getAuthorId());
        }
        Iterable iterable2 = object.findAllById((Iterable)((List)destination$iv$iv3));
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"findAllById(...)");
        Iterable $i$f$associateBy22 = iterable2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Profile it = (Profile)element$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.put(it.getId(), element$iv$iv);
        }
        Object authors = destination$iv$iv3;
        this.searchConnector.upsertPosts((Collection)toUpsert, channels, (Map)authors);
    }

    static {
        Logger logger = LoggerFactory.getLogger(KafkaSearchConsumer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

