/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.kafka;

import de.justsoftware.news.kafka.KafkaConsumerConfiguration;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.support.serializer.ErrorHandlingDeserializer;

@Configuration
@EnableKafka
@DependsOn(value={"liquibase"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\b\u0017\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/news/kafka/KafkaConsumerConfiguration;", "", "bootstrapServers", "", "<init>", "(Ljava/lang/String;)V", "defaultConsumerConfig", "", "Companion", "news-service"})
public class KafkaConsumerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    public static final long BACKOFF_INTERVAL = 1000L;
    public static final long BACKOFF_RETRY = 1L;

    public KafkaConsumerConfiguration(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    @NotNull
    public Map<String, Object> defaultConsumerConfig() {
        Map props = new HashMap();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("key.deserializer", ErrorHandlingDeserializer.class);
        props.put("value.deserializer", ErrorHandlingDeserializer.class);
        props.put("auto.offset.reset", "earliest");
        return props;
    }
}

