/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.channel;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.channel.AllowedChannelActionsDataLoader;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelAction;
import de.justsoftware.news.domain.channel.ChannelDataFetcherKt;
import de.justsoftware.news.domain.channel.ChannelService;
import de.justsoftware.news.domain.channel.ManagedSubscriptionDataLoader;
import de.justsoftware.news.domain.channel.MayCreateEventDataLoader;
import de.justsoftware.news.domain.channel.MayCreatePostDataLoader;
import de.justsoftware.news.domain.channel.MayDeleteChannelDataLoader;
import de.justsoftware.news.domain.channel.PermissionsByChannelIdDataLoader;
import de.justsoftware.news.domain.channel.SubscriptionDataLoader;
import de.justsoftware.news.domain.delete.DeleteService;
import de.justsoftware.news.domain.subscription.ChannelSubscriptionService;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.UserDataLoaderKt;
import de.justsoftware.news.graphql.generated.types.ChannelPermission;
import de.justsoftware.news.graphql.generated.types.ChannelSubscription;
import de.justsoftware.news.graphql.generated.types.ManagedSubscription;
import de.justsoftware.news.id.ChannelId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DgsComponent
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J$\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001a\u0010\u0015\u001a\u00020\u000b2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001a\u0010\u001a\u001a\u00020\u00122\b\b\u0001\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010\u001c\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001c\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\u001f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017JG\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f0\u00172\n\b\u0001\u0010$\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010&\u001a\u0004\u0018\u00010%2\n\b\u0001\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010(J$\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00172\n\b\u0001\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001e\u0010*\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010+0\u001f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001c\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0\u001f0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u001c\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002000/0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/news/domain/channel/ChannelDataFetcher;", "", "channelService", "Lde/justsoftware/news/domain/channel/ChannelService;", "deleteService", "Lde/justsoftware/news/domain/delete/DeleteService;", "channelSubscriptionService", "Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelService;Lde/justsoftware/news/domain/delete/DeleteService;Lde/justsoftware/news/domain/subscription/ChannelSubscriptionService;)V", "addChannel", "Lde/justsoftware/news/graphql/generated/types/Channel;", "title", "", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "subscribeChannel", "channelId", "Lde/justsoftware/news/id/ChannelId;", "notificationsEnabled", "", "unsubscribeChannel", "mayCreateEvent", "Ljava/util/concurrent/CompletableFuture;", "mayCreatePost", "mayDelete", "deleteChannel", "id", "updateChannel", "channel", "channels", "", "permissions", "Lde/justsoftware/news/graphql/generated/types/ChannelPermission;", "subscribers", "Lde/justsoftware/news/graphql/generated/types/Profile;", "offset", "", "limit", "query", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;)Ljava/util/concurrent/CompletableFuture;", "subscribersCount", "subscription", "Lde/justsoftware/news/graphql/generated/types/ChannelSubscription;", "managedSubscriptions", "Lde/justsoftware/news/graphql/generated/types/ManagedSubscription;", "allowedActions", "", "Lde/justsoftware/news/domain/channel/ChannelAction;", "news-service"})
@SourceDebugExtension(value={"SMAP\nChannelDataFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelDataFetcher.kt\nde/justsoftware/news/domain/channel/ChannelDataFetcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1557#2:292\n1628#2,3:293\n1557#2:296\n1628#2,3:297\n*S KotlinDebug\n*F\n+ 1 ChannelDataFetcher.kt\nde/justsoftware/news/domain/channel/ChannelDataFetcher\n*L\n107#1:292\n107#1:293,3\n129#1:296\n129#1:297,3\n*E\n"})
public class ChannelDataFetcher {
    @NotNull
    private final ChannelService channelService;
    @NotNull
    private final DeleteService deleteService;
    @NotNull
    private final ChannelSubscriptionService channelSubscriptionService;

    public ChannelDataFetcher(@NotNull ChannelService channelService, @NotNull DeleteService deleteService, @NotNull ChannelSubscriptionService channelSubscriptionService) {
        Intrinsics.checkNotNullParameter((Object)channelService, (String)"channelService");
        Intrinsics.checkNotNullParameter((Object)deleteService, (String)"deleteService");
        Intrinsics.checkNotNullParameter((Object)channelSubscriptionService, (String)"channelSubscriptionService");
        this.channelService = channelService;
        this.deleteService = deleteService;
        this.channelSubscriptionService = channelSubscriptionService;
    }

    @DgsMutation(field="addChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel addChannel(@InputArgument @NotNull String title, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.create(title, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsMutation(field="subscribeChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel subscribeChannel(@InputArgument @NotNull ChannelId channelId, @InputArgument boolean notificationsEnabled, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.channelSubscriptionService.subscribe(channelId, notificationsEnabled, authContext);
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(channelId, authContext));
    }

    @DgsMutation(field="unsubscribeChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel unsubscribeChannel(@InputArgument @NotNull ChannelId channelId, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        AuthorizationContext authContext = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe);
        this.channelSubscriptionService.unsubscribe(channelId, authContext);
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.getById(channelId, authContext));
    }

    @DgsData(parentType="Channel", field="mayCreateEvent")
    @NotNull
    public CompletableFuture<Boolean> mayCreateEvent(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayCreateEventDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="mayCreatePost")
    @NotNull
    public CompletableFuture<Boolean> mayCreatePost(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayCreatePostDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="mayDelete")
    @NotNull
    public CompletableFuture<Boolean> mayDelete(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(MayDeleteChannelDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsMutation(field="deleteChannel")
    @NotNull
    public ChannelId deleteChannel(@InputArgument @NotNull ChannelId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return this.deleteService.markChannelAsDeleted(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsMutation(field="updateChannel")
    @NotNull
    public de.justsoftware.news.graphql.generated.types.Channel updateChannel(@InputArgument @NotNull ChannelId id, @NotNull String title, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        return ChannelDataFetcherKt.toGql((Channel)this.channelService.update(id, title, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsQuery(field="channel")
    @Nullable
    public de.justsoftware.news.graphql.generated.types.Channel channel(@InputArgument @NotNull ChannelId id, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Channel channel = this.channelService.findById(id, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        return channel != null ? ChannelDataFetcherKt.toGql((Channel)channel) : null;
    }

    /*
     * WARNING - void declaration
     */
    @DgsQuery(field="channels")
    @NotNull
    public List<de.justsoftware.news.graphql.generated.types.Channel> channels(@NotNull DgsDataFetchingEnvironment dfe) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Iterable $this$map$iv = this.channelService.findAllSortedByTitle((AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Channel channel = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ChannelDataFetcherKt.toGql((Channel)it));
        }
        return (List)destination$iv$iv;
    }

    @DgsData(parentType="Channel", field="permissions")
    @NotNull
    public CompletableFuture<List<ChannelPermission>> permissions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PermissionsByChannelIdDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscribers")
    @NotNull
    public CompletableFuture<List<de.justsoftware.news.graphql.generated.types.Profile>> subscribers(@InputArgument @Nullable Integer offset, @InputArgument @Nullable Integer limit, @InputArgument @Nullable String query, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        CompletableFuture<List<de.justsoftware.news.graphql.generated.types.Profile>> completableFuture = CompletableFuture.supplyAsync(() -> ChannelDataFetcher.subscribers$lambda$2(dfe, this, limit, offset, query));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscribersCount")
    @NotNull
    public CompletableFuture<Integer> subscribersCount(@InputArgument @Nullable String query, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        CompletableFuture<Integer> completableFuture = CompletableFuture.supplyAsync(() -> ChannelDataFetcher.subscribersCount$lambda$3(dfe, this, query));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="subscription")
    @NotNull
    public CompletableFuture<List<ChannelSubscription>> subscription(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(SubscriptionDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="managedSubscriptions")
    @NotNull
    public CompletableFuture<List<ManagedSubscription>> managedSubscriptions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ManagedSubscriptionDataLoader.class);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Channel", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<ChannelAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)dfe.getSource()).getId();
        DataLoader dataLoader = dfe.getDataLoader(AllowedChannelActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private static final List subscribers$lambda$2(DgsDataFetchingEnvironment $dfe, ChannelDataFetcher this$0, Integer $limit, Integer $offset, String $query) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$dfe, (String)"$dfe");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthorizationContext authCtx = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)$dfe);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)$dfe.getSource()).getId();
        List list2 = this$0.channelSubscriptionService.findSubscribersForChannelId(channelId, $limit, $offset, $query, authCtx);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void profile;
                Profile profile2 = (Profile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UserDataLoaderKt.toGql((Profile)profile));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private static final Integer subscribersCount$lambda$3(DgsDataFetchingEnvironment $dfe, ChannelDataFetcher this$0, String $query) {
        Intrinsics.checkNotNullParameter((Object)$dfe, (String)"$dfe");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AuthorizationContext authCtx = (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)$dfe);
        ChannelId channelId = ((de.justsoftware.news.graphql.generated.types.Channel)$dfe.getSource()).getId();
        return this$0.channelSubscriptionService.countSubscribersForChannel(channelId, $query, authCtx);
    }
}

