/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.business.usergroup.impl;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.justimport.business.JustImportConfig;
import de.justsoftware.justimport.business.usergroup.UserGroupImportPublisher;
import de.justsoftware.justimport.business.usergroup.UserGroupImportService;
import de.justsoftware.justimport.business.usergroup.impl.ExternalIdMappingResolver;
import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import de.justsoftware.justimport.domain.model.usergroup.UserGroupId;
import de.justsoftware.justimport.domain.resolver.LdapQueryResolver;
import de.justsoftware.justimport.persistence.ExternalIdMappingRepository;
import de.justsoftware.justimport.persistence.model.ImportMethod;
import de.justsoftware.justimport.util.ImportResult;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class UserGroupImportServiceImpl
implements UserGroupImportService {
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupImportServiceImpl.class);
    private final LdapQueryResolver _ldapQueryResolver;
    private final UserGroupImportPublisher _userGroupImportPublisher;
    private final ExternalIdMappingRepository _externalIdMappingRepository;
    private final ExternalSystemId _externalSystemId;
    private final Supplier<UserGroupId> _newUserGroupIdSupplier;

    @Autowired
    public UserGroupImportServiceImpl(LdapQueryResolver ldapQueryResolver, ExternalIdMappingRepository externalIdMappingRepository, UserGroupImportPublisher userGroupImportPublisher, JustImportConfig importConfig, @Nullable Supplier<UserGroupId> newUserGroupIdSupplier) {
        this._ldapQueryResolver = ldapQueryResolver;
        this._externalIdMappingRepository = externalIdMappingRepository;
        this._userGroupImportPublisher = userGroupImportPublisher;
        this._newUserGroupIdSupplier = newUserGroupIdSupplier != null ? newUserGroupIdSupplier : UserGroupId::random;
        this._externalSystemId = new ExternalSystemId(importConfig.getExternalSystemId());
    }

    public ImportResult importUserGroups(TenantId tenantId) {
        ImportResult importResult = new ImportResult();
        LOG.info("Starting import of user groups...");
        this._ldapQueryResolver.getImportModels().forEach(importModel -> {
            try {
                LOG.info("Importing user group {}", importModel);
                ExternalIdMappingResolver idMappingResolver = new ExternalIdMappingResolver(importModel, externalIds -> this._externalIdMappingRepository.getByExternalId(tenantId, this._externalSystemId, externalIds));
                UserGroupId userGroupId = this.getUserGroupId(importResult, importModel.getExternalId(), tenantId, idMappingResolver);
                boolean successfullyPublished = this._userGroupImportPublisher.publishImportedUserGroup(tenantId, userGroupId, importModel.getName(), ImportMethod.LDAP);
                if (!successfullyPublished) {
                    importResult.increaseFailed(ImportResult.ErrorReasons.GROUP_ERROR_ON_PUBLISH);
                }
                ImmutableSet allGroupMembers = (ImmutableSet)importModel.getMembers().stream().map(externalId -> idMappingResolver.getProfileIdForExternalId(externalId, () -> {
                    importResult.increaseSkipped(ImportResult.ReasonsForSkip.MEMBER_MAPPING_NOT_FOUND);
                    LOG.warn("No mapping found for user {}: Will not be added to user group with external id {}.", externalId, (Object)importModel.getExternalId());
                    return null;
                })).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
                this._userGroupImportPublisher.publishAndCleanAllUserGroupMembers(userGroupId, (Set)allGroupMembers, successful -> this.updateStatisticsForPublishingMembers(successful, importResult));
            }
            catch (RuntimeException e) {
                LOG.error("Failed to import user group: " + importModel, (Throwable)e);
                importResult.increaseFailed(ImportResult.ErrorReasons.GROUP_RUNTIME_EXCEPTION);
            }
        });
        LOG.info("Import of user groups finished:\n{}", (Object)importResult);
        return importResult;
    }

    private void updateStatisticsForPublishingMembers(Boolean successful, ImportResult importResult) {
        if (successful.booleanValue()) {
            importResult.increaseMembers();
        } else {
            importResult.increaseFailed(ImportResult.ErrorReasons.MEMBER_ERROR_ON_PUBLISH);
        }
    }

    @Nonnull
    private UserGroupId getUserGroupId(ImportResult importResult, ExternalId externalId, TenantId tenantId, ExternalIdMappingResolver idMappingResolver) {
        Optional optionalUserGroupId = idMappingResolver.getUserGroupIdForExternalId(externalId);
        if (optionalUserGroupId.isPresent()) {
            importResult.increaseUpdatedGroups();
            return (UserGroupId)optionalUserGroupId.get();
        }
        UserGroupId newUserGroupId = (UserGroupId)this._newUserGroupIdSupplier.get();
        this._externalIdMappingRepository.store(new ExternalIdMapping(tenantId, this._externalSystemId, (InternalId)newUserGroupId, externalId));
        importResult.increaseInsertedGroups();
        return newUserGroupId;
    }
}

