/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.ids.ExternalId;
import de.justsoftware.gateway.ids.OAuthClientId;
import de.justsoftware.gateway.ids.ProfileId;
import de.justsoftware.gateway.ids.TenantId;
import de.justsoftware.gateway.security.EmailToProfileMapper;
import de.justsoftware.gateway.security.ErrorCode;
import de.justsoftware.gateway.security.InMemoryExternalIdMapper;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.security.JustAuthenticationException;
import de.justsoftware.gateway.security.NoJustUserForLoginException;
import de.justsoftware.gateway.security.PrincipalId;
import de.justsoftware.gateway.security.UnknownClientRegistrationException;
import de.justsoftware.gateway.security.UserLoginService;
import de.justsoftware.gateway.security.UserNameAttributeNotFoundException;
import de.justsoftware.gateway.security.oauth2.JustClientRegistrationService;
import de.justsoftware.gateway.security.oauth2.JustLoginHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@Service
public class JustAuthenticationManager
implements ReactiveAuthenticationManager {
    private static final Logger LOG = LoggerFactory.getLogger(JustAuthenticationManager.class);
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String ISSUER_CLAIM = "iss";
    private static final String TENANT_ID_KEY = "tenantId";
    private static final String PROFILE_ID_KEY = "profileId";
    private final JustClientRegistrationService _clientRegistrationsRepo;
    private final InMemoryExternalIdMapper _inMemoryExternalIdMapper;
    private final EmailToProfileMapper _emailToProfileMapper;
    private final UserLoginService _userLoginService;

    public JustAuthenticationManager(JustClientRegistrationService clientRegistrationsRepo, InMemoryExternalIdMapper inMemoryExternalIdMapper, EmailToProfileMapper emailToProfileMapper, UserLoginService userLoginService) {
        this._clientRegistrationsRepo = clientRegistrationsRepo;
        this._inMemoryExternalIdMapper = inMemoryExternalIdMapper;
        this._emailToProfileMapper = emailToProfileMapper;
        this._userLoginService = userLoginService;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        if (authentication instanceof BearerTokenAuthentication) {
            return this.authenticateFromBearerToken((BearerTokenAuthentication)authentication);
        }
        if (authentication instanceof JwtAuthenticationToken) {
            return this.authenticateFromJwt(authentication);
        }
        if (authentication instanceof OAuth2AuthenticationToken) {
            return this.authenticateFromOAuthLoginToken((OAuth2AuthenticationToken)authentication);
        }
        return Mono.empty();
    }

    @Nonnull
    private Mono<Authentication> authenticateFromBearerToken(BearerTokenAuthentication justOpaqueToken) {
        Map tokenAttributes = justOpaqueToken.getTokenAttributes();
        TenantId tenantId = JustAuthenticationManager.extractTenantId((Map)tokenAttributes);
        String profileIdString = (String)tokenAttributes.get("profileId");
        if (profileIdString == null) {
            if (tenantId == null) {
                return Mono.just((Object)justOpaqueToken);
            }
            String clientStringId = (String)tokenAttributes.get("client_id");
            OAuthClientId oauthClientId = new OAuthClientId(clientStringId);
            JustAuthToken newToken = new JustAuthToken((PrincipalId)oauthClientId, tenantId, (AbstractAuthenticationToken)justOpaqueToken, null);
            return Mono.just((Object)newToken);
        }
        ProfileId profileId = ProfileId.parse((String)profileIdString);
        this.checkProfile(profileId);
        JustAuthToken newToken = new JustAuthToken((PrincipalId)profileId, tenantId, (AbstractAuthenticationToken)justOpaqueToken, null);
        return Mono.just((Object)newToken);
    }

    @CheckForNull
    private static TenantId extractTenantId(Map<String, Object> tokenAttributes) {
        String tenantIdString = (String)tokenAttributes.get("tenantId");
        return tenantIdString != null ? TenantId.parse((String)tenantIdString) : null;
    }

    public void checkProfile(ProfileId profileId) {
        boolean canLogin = this._emailToProfileMapper.mayLogin(profileId);
        if (!canLogin) {
            LOG.warn("inactive, blocked or deleted user tried to access just {}", (Object)profileId);
            throw new JustAuthenticationException("user can not login", ErrorCode.USER_NOT_FOUND);
        }
    }

    @Nonnull
    public Mono<Authentication> authenticateFromOAuthLoginToken(OAuth2AuthenticationToken token) {
        return this.getTenantId(token).flatMap(tenantId -> {
            ProfileId profileId = JustLoginHelper.isJustIdp((String)token.getAuthorizedClientRegistrationId()) ? ProfileId.parse((String)Objects.requireNonNull((String)token.getPrincipal().getAttribute("profileId"))) : this.getProfileId(tenantId, token.getName());
            if (profileId == null) {
                return Mono.error((Throwable)new NoJustUserForLoginException(tenantId, token.getName()));
            }
            return this._userLoginService.saveLogin(profileId, tenantId, token).map(login -> new JustAuthToken((PrincipalId)profileId, tenantId, (AbstractAuthenticationToken)token, login.getId())).switchIfEmpty(Mono.justOrEmpty((Object)new JustAuthToken((PrincipalId)profileId, tenantId, (AbstractAuthenticationToken)token, null))).cast(Authentication.class);
        }).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Login only possible with tenantId")));
    }

    @Nonnull
    private Mono<Authentication> authenticateFromJwt(Authentication authentication) {
        JwtAuthenticationToken jwt = (JwtAuthenticationToken)authentication;
        Map tokenAttributes = jwt.getTokenAttributes();
        Mono registration = this.getClientRegistrationFromToken(tokenAttributes);
        return registration.flatMap(clientRegistration -> {
            String tenantIdString = JustLoginHelper.isJustIdp((String)clientRegistration.getRegistrationId()) ? (String)tokenAttributes.get("tenantId") : (String)clientRegistration.getProviderDetails().getConfigurationMetadata().get("tenantId");
            if (tenantIdString != null) {
                TenantId tenantId = TenantId.parse((String)tenantIdString);
                String userNameAttributeName = clientRegistration.getProviderDetails().getUserInfoEndpoint().getUserNameAttributeName();
                String externalId = (String)tokenAttributes.get(userNameAttributeName);
                if (externalId == null) {
                    return Mono.error((Throwable)new UserNameAttributeNotFoundException(String.format("userNameAttributeName %s not found in token", userNameAttributeName)));
                }
                ProfileId profileId = this.getProfileId(tenantId, externalId);
                if (profileId != null) {
                    return Mono.just((Object)new JustAuthToken((PrincipalId)profileId, tenantId, (AbstractAuthenticationToken)jwt, null));
                }
                return Mono.error((Throwable)new NoJustUserForLoginException(tenantId, externalId));
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.error((Throwable)new UnknownClientRegistrationException(tokenAttributes.toString())));
    }

    @Nonnull
    private Mono<ClientRegistration> getClientRegistrationFromToken(Map<String, Object> tokenAttributes) {
        String issuer = (String)tokenAttributes.get("iss");
        return this.getClientIdFromTokenAttribute(tokenAttributes.get("aud")).flatMap(clientId -> this._clientRegistrationsRepo.findByClientId(clientId, issuer));
    }

    @Nonnull
    private Mono<String> getClientIdFromTokenAttribute(@Nullable Object audienceAttribute) {
        if (audienceAttribute instanceof ArrayList) {
            ArrayList list = (ArrayList)audienceAttribute;
            if (!list.isEmpty()) {
                return Mono.just((Object)((String)list.get(0)));
            }
        } else if (audienceAttribute instanceof String) {
            return Mono.just((Object)((String)audienceAttribute));
        }
        return Mono.empty();
    }

    @Nonnull
    public Mono<TenantId> getTenantId(OAuth2AuthenticationToken principal) {
        if (JustLoginHelper.isJustIdp((String)principal.getAuthorizedClientRegistrationId())) {
            String tenantIdString = (String)principal.getPrincipal().getAttribute("tenantId");
            return tenantIdString != null ? Mono.just((Object)TenantId.parse((String)tenantIdString)) : Mono.empty();
        }
        return this._clientRegistrationsRepo.findByRegistrationId(principal.getAuthorizedClientRegistrationId()).map(clientRegistration -> {
            String tenantId = (String)clientRegistration.getProviderDetails().getConfigurationMetadata().get("tenantId");
            return TenantId.parse((String)tenantId);
        }).switchIfEmpty(Mono.error((Throwable)new UnknownClientRegistrationException(String.format("unknown registrationId %s", principal.getAuthorizedClientRegistrationId()))));
    }

    @CheckForNull
    private ProfileId getProfileId(TenantId tenantId, String externalId) {
        ProfileId byEmail = this._emailToProfileMapper.findByEmail(externalId);
        if (byEmail != null) {
            return byEmail;
        }
        ProfileId profileIdByExternalId = this._inMemoryExternalIdMapper.lookupInternalId(tenantId, ExternalId.parse((String)externalId));
        if (profileIdByExternalId == null) {
            LOG.warn("no internalId found for externalId: {} and tenantId: {}", (Object)externalId, (Object)tenantId);
        }
        return profileIdByExternalId;
    }
}

