/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.ids.core;

import com.fasterxml.jackson.annotation.JsonValue;
import de.justsoftware.gateway.ids.core.ItemType;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractItemId<T>
implements Serializable {
    private final T _id;
    private final ItemType _type;
    private final int _hash;
    private final Object[] _hashObjects;

    AbstractItemId(T id, ItemType type) {
        this._id = id;
        this._type = type;
        this._hashObjects = new Object[]{id, type};
        this._hash = Arrays.hashCode(this._hashObjects);
    }

    @Nonnull
    public final T getId() {
        return (T)this._id;
    }

    @Nonnull
    public ItemType getType() {
        return this._type;
    }

    public final int hashCode() {
        return this._hash;
    }

    public final boolean equals(Object obj) {
        return this == obj || obj instanceof AbstractItemId && Arrays.equals(this._hashObjects, ((AbstractItemId)obj)._hashObjects);
    }

    @Nonnull
    private String idToString() {
        return this._id.toString();
    }

    @JsonValue
    public final String toString() {
        return this._type + "," + this.idToString();
    }

    @Nonnull
    public final String asString() {
        return this.toString();
    }
}

