/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.document.model.DocumentListSortParams;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class StartupConfig {
    private final boolean _publicLinksEnabled;
    private final PersonId _currentUser;
    private final String _fileSyncDownloadPageURL;
    private final ImmutableSet<String> _newFileTypes;
    private final boolean _mayCreateShares;
    private final long _uploadMaxFileSize;
    private final UserGroupId _allUsersGroupId;
    private final DocumentListSortParams _documentListSortParams;

    public StartupConfig(boolean publicLinksEnabled, PersonId currentUser, String fileSyncDownloadPageURL, ImmutableSet<String> newFileTypes, boolean mayCreateShares, long uploadMaxFileSize, @Nullable UserGroupId allUsersGroupId, DocumentListSortParams documentListSortParams) {
        this._publicLinksEnabled = publicLinksEnabled;
        this._currentUser = currentUser;
        this._fileSyncDownloadPageURL = fileSyncDownloadPageURL;
        this._newFileTypes = newFileTypes;
        this._mayCreateShares = mayCreateShares;
        this._uploadMaxFileSize = uploadMaxFileSize;
        this._allUsersGroupId = allUsersGroupId;
        this._documentListSortParams = documentListSortParams;
    }

    @Schema(required=true)
    public boolean isPublicLinksEnabled() {
        return this._publicLinksEnabled;
    }

    @Schema(required=true)
    @Nonnull
    public PersonId getCurrentUser() {
        return this._currentUser;
    }

    @Schema(required=true)
    @Nonnull
    public String getFileSyncDownloadPageURL() {
        return this._fileSyncDownloadPageURL;
    }

    @Schema(required=false)
    @Nonnull
    public ImmutableSet<String> getNewFileTypes() {
        return this._newFileTypes;
    }

    @Schema(required=true)
    public boolean isMayCreateShares() {
        return this._mayCreateShares;
    }

    @Schema(required=true)
    public long getUploadMaxFileSize() {
        return this._uploadMaxFileSize;
    }

    @CheckForNull
    @Schema(required=true)
    public String getAllUsersGroupId() {
        if (this._allUsersGroupId == null) {
            return null;
        }
        return this._allUsersGroupId.asPermissionRole().asString();
    }

    @Nonnull
    public DocumentListSortParams getDocumentSortParams() {
        return this._documentListSortParams;
    }
}

