/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.document.DocumentVersionCreateModel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
@Mapper
public interface DocumentVersionMapper {
    @Insert(value={"INSERT INTO document_version(id, document_id, version, name, change_id, first_published_change_id, owner, change_date)", "VALUES (#{_id}, #{_documentId}, #{_version}, #{_name}, #{_changeId}, #{_firstPublishedChangeId}, #{_owner}, #{_changeDate})"})
    public void insertDocumentVersion(DocumentVersionCreateModel<?> var1);

    @Select(value={"<script>", "SELECT id, document_id FROM document_version WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentVersionId.class), @Result(column="document_id", property="value", javaType=DocumentId.class)})
    @ResultType(value=Map.class)
    public void getDocumentIdsByDocument(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Delete(value={"<script>", "DELETE FROM document_version WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteByIds(@Param(value="ids") List<DocumentVersionId> var1);

    @Select(value={"<script>", "SELECT change_id, id FROM document_version", "WHERE change_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="change_id", property="key", javaType=DocumentVersionId.class), @Result(column="id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getNewDocumentsForChange(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT first_published_change_id, id FROM document_version", "WHERE first_published_change_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="first_published_change_id", property="key", javaType=DocumentVersionId.class), @Result(column="id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getPublishedDocumentsForChange(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT id, first_published_change_id FROM document_version", "WHERE first_published_change_id IS NOT NULL", "AND id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentVersionId.class), @Result(column="first_published_change_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getFirstPublishedChangesForDocuments(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "WITH <if test=\"_databaseId == 'POSTGRES'\">RECURSIVE</if>", "r(parent_id, child_id) AS (", "  SELECT id parent_id, id child_id FROM document_version", "  WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "UNION ALL", "  SELECT p.parent_id, r.child_id", "  FROM sub_folder p", "  JOIN r ON p.child_id = r.parent_id", ")", "SELECT document_version_id, change_id FROM (", "  SELECT r.child_id as document_version_id, c.folder_version_id as change_id, ", "    RANK() OVER (PARTITION BY r.child_id ORDER BY c.version ASC) AS rank", "  FROM r JOIN change c ON r.parent_id = c.folder_version_id AND c.first_published_date IS NOT NULL", "  WHERE r.child_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", ") dc", "WHERE dc.rank = 1", "</script>"})
    @Results(value={@Result(column="document_version_id", property="key", javaType=DocumentVersionId.class), @Result(column="change_id", property="value", javaType=DocumentVersionId.class)})
    @ResultType(value=Map.class)
    public void getFirstPublishedChangesForDocumentsRecursive(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Update(value={"UPDATE document_version SET", "  first_published_change_id = #{changeId}", "WHERE id = #{documentVersionId}"})
    public void setFirstPublishedChange(@Param(value="documentVersionId") DocumentVersionId var1, @Param(value="changeId") DocumentVersionId var2);

    @Update(value={"<script>", "UPDATE document_version SET", "  first_published_change_id = NULL", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deletePublishedChange(@Param(value="ids") List<DocumentVersionId> var1);

    @Select(value={"<script>", "SELECT document_id, item_id FROM (", "   SELECT v.document_id, c.item_id, rank() OVER (PARTITION BY v.document_id ORDER BY v.version DESC) AS rank", "   FROM document_version v", "   JOIN change c ON c.folder_version_id = v.change_id", "   WHERE v.document_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", ") t", "WHERE rank = 1", "</script>"})
    @Results(value={@Result(column="document_id", property="key", javaType=DocumentId.class), @Result(column="item_id", property="value", javaType=ItemId.class)})
    @ResultType(value=Map.class)
    public void getItemIdsOfDocument(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentId> var2);

    @Select(value={"<script>", "SELECT v.id, c.item_id", "FROM document_version v", "JOIN change c ON c.folder_version_id = v.change_id", "WHERE v.id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentVersionId.class), @Result(column="item_id", property="value", javaType=ItemId.class)})
    @ResultType(value=Map.class)
    public void getItemIdsOfDocumentVersions(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Update(value={"<script>", "UPDATE document_version", "SET change_id = #{targetChange}, first_published_change_id = #{targetChange}", "WHERE id NOT IN (<foreach collection='newestVersions' item='i' separator=','>#{i}</foreach>)", "AND document_id IN (<foreach collection='documents' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void moveOtherVersionsToTargetChange(@Param(value="newestVersions") List<DocumentVersionId> var1, @Param(value="documents") List<DocumentId> var2, @Param(value="targetChange") DocumentVersionId var3);

    @Delete(value={"<script>", "DELETE FROM document_version ", "WHERE change_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteIntroducedByChanges(@Param(value="ids") List<DocumentVersionId> var1);

    @Update(value={"<script>", "UPDATE document_version", "SET change_id = #{targetChange}, first_published_change_id = #{targetChange}", "WHERE id IN (<foreach collection='documentVersions' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void moveVersionsToTargetChange(@Param(value="documentVersions") List<DocumentVersionId> var1, @Param(value="targetChange") DocumentVersionId var2);

    @Select(value={"<script>", "SELECT document_id", "FROM document_version d", "JOIN change c ON c.folder_version_id = d.change_id", "WHERE d.change_id != id AND d.change_id IN (<foreach collection='changeIds' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=DocumentId.class)
    public void getDocumentsByChangeIds(ResultHandler<DocumentId> var1, @Param(value="changeIds") List<? extends DocumentVersionId> var2);

    @Select(value={"SELECT id FROM document_version dv JOIN change c ON c.folder_version_id = dv.change_id WHERE c.item_id = #{itemId}"})
    @Nonnull
    public Set<DocumentVersionId> getAllDocumentsForItem(ItemId var1);
}

