/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.kafka.NotificationConnector;
import de.justsoftware.drive.business.shares.PermissionShareItemPublisher;
import de.justsoftware.drive.business.shares.ShareNotificationPublisher;
import de.justsoftware.drive.business.shares.ShareRoleAssignmentPublisher;
import de.justsoftware.drive.business.shares.SharesPublisher;
import de.justsoftware.drive.business.shares.UpdateType;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@ParametersAreNonnullByDefault
@Service
public class SharesPublisherImpl
implements SharesPublisher {
    private static final TenantId NULL_TENANT_ID = new TenantId(new UUID(0L, 0L));
    private static final Logger LOG = LoggerFactory.getLogger(SharesPublisherImpl.class);
    private final ShareNotificationPublisher _shareNotificationPublisher;
    private final PermissionShareItemPublisher _permissionShareItemPublisher;
    private final ShareRoleAssignmentPublisher _sharePermissionPublisher;
    @Autowired
    private NotificationConnector _notificationConnector;

    @Autowired
    public SharesPublisherImpl(ShareNotificationPublisher shareNotificationPublisher, PermissionShareItemPublisher permissionShareItemPublisher, ShareRoleAssignmentPublisher sharePermissionPublisher) {
        this._shareNotificationPublisher = shareNotificationPublisher;
        this._permissionShareItemPublisher = permissionShareItemPublisher;
        this._sharePermissionPublisher = sharePermissionPublisher;
    }

    public WaitForOffsets publishDeletedShare(ItemId shareId, ImmutableSet<Role> deletedMembers) {
        this._shareNotificationPublisher.publishDeletedShare(shareId, (ImmutableSet)deletedMembers.stream().filter(Role::isProfileRole).map(e -> PersonId.parse((String)e.asString())).filter(Optional::isPresent).map(Optional::get).collect(ImmutableSet.toImmutableSet()));
        ImmutableMap.Builder deletedMembersForNotification = ImmutableMap.builder();
        deletedMembers.forEach(role -> deletedMembersForNotification.put(role, Optional.empty()));
        WaitForOffsets waiter = this._sharePermissionPublisher.publishSharePermission(shareId, (Map)deletedMembersForNotification.build());
        this._permissionShareItemPublisher.publishDeletedShare(shareId);
        return waiter;
    }

    public void publishAccessRequest(String requestor, TenantId tenantId, ImmutableSet<String> receiverIds, ItemId shareId, String shareName) {
        try {
            this._notificationConnector.sendShareRequestNotification(tenantId, shareName, shareId, requestor, receiverIds);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error sending notifications for share request (drive).", (Throwable)e);
        }
    }

    public void publishMemberChanges(ItemId shareId, PersonId executor, String name, DocumentId rootFolderId, ImmutableSet<PersonId> addedMembers, ImmutableSet<PersonId> deletedMembers) {
        this._shareNotificationPublisher.publishMemberChanges(shareId, executor, name, UpdateType.UPDATED_SHARE, rootFolderId, addedMembers, deletedMembers);
    }

    public void publishNewShare(ItemId shareId, PersonId executor, String name, DocumentId rootFolderId, ImmutableSet<PersonId> addedMembers) {
        this._shareNotificationPublisher.publishMemberChanges(shareId, executor, name, UpdateType.NEW_SHARE, rootFolderId, addedMembers, ImmutableSet.of());
        this._permissionShareItemPublisher.publishNewShare(shareId);
    }

    public WaitForOffsets publishMemberPermissionChanges(ItemId shareId, Map<Role, Optional<SharePrivilege>> changedMembers) {
        return this._sharePermissionPublisher.publishSharePermission(shareId, changedMembers);
    }

    public void publishAllSharePermissions() {
        StopWatch watch = new StopWatch("Publish all share permissions to permission service");
        watch.start("Publish share items");
        this._permissionShareItemPublisher.publishAllShares();
        watch.stop();
        watch.start("Publish all share role assignments");
        this._sharePermissionPublisher.publishAllShareRoleAssignments();
        watch.stop();
        LOG.info(watch.prettyPrint());
    }
}

