/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business.impl;

import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessInfo;
import de.justsoftware.drive.business.server.business.DriveVersionUpdateProcessor;
import de.justsoftware.drive.business.server.business.PeopleApiConnector;
import de.justsoftware.drive.business.server.business.UpdateBehaviour;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.versionupdate.model.DriveVersionBO;
import de.justsoftware.drive.common.versionupdate.model.UpdateProcessorType;
import de.justsoftware.drive.persistence.versionupdate.DriveVersionDAO;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class MigrateAllUsersRoleUpdateProcessor
implements DriveVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateAllUsersRoleUpdateProcessor.class);
    private static final UpdateProcessorType UPDATE_PROCESSOR_TYPE = new UpdateProcessorType("MIGRATE_ALL_USERS_ROLE");
    private final SharesService _sharesService;
    private final PeopleApiConnector _peopleApiConnector;
    private final DriveVersionDAO _driveVersionDAO;

    @Autowired
    public MigrateAllUsersRoleUpdateProcessor(SharesService sharesService, PeopleApiConnector peopleApiConnector, DriveVersionDAO driveVersionDAO) {
        this._sharesService = sharesService;
        this._peopleApiConnector = peopleApiConnector;
        this._driveVersionDAO = driveVersionDAO;
    }

    public boolean preconditionsMet() {
        return this.isSameVersion() && this._peopleApiConnector.available();
    }

    private boolean isSameVersion() {
        DriveVersionBO latestVersion = this._driveVersionDAO.getLatestVersion();
        String peopleVersion = this._peopleApiConnector.getPeopleVersion();
        if (peopleVersion == null) {
            LOG.error("Couldn't retrieve People version. Assume it's not the same version. MigrateAllUsersRoleUpdateProcessor probably wont run.");
            return false;
        }
        return latestVersion != null && latestVersion.compareWithoutBuildNumber(peopleVersion) == 0;
    }

    public UpdateProcessorType getProcessorType() {
        return UPDATE_PROCESSOR_TYPE;
    }

    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceForVersion((DriveVersionUpdateProcessInfo)this, (String)"11.11.0");
    }

    public void process() {
        this._sharesService.migrateAllUsersRole();
    }
}

