/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.search.SolrResultDocument;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.solr.client.solrj.beans.Field;

public class SolrResultDocumentBean
implements SolrResultDocument {
    @Field(value="id")
    private String _documentIdAsItemId;
    @Field(value="drive_version_id")
    private String _documentVersionIdAsUUID;
    @Field(value="drive_parent_folder_id")
    private List<String> _parentFolderIds;

    public DocumentId getId() {
        String stringUUID = this._documentIdAsItemId.substring(this._documentIdAsItemId.indexOf(",") + 1, this._documentIdAsItemId.length());
        return new DocumentId(UUID.fromString(stringUUID));
    }

    public DocumentVersionId getDocumentVersionId() {
        return new DocumentVersionId(UUID.fromString(this._documentVersionIdAsUUID));
    }

    public ImmutableSet<DocumentId> getParentFolderIds() {
        if (this._parentFolderIds == null) {
            return ImmutableSet.of();
        }
        return FluentIterable.from((Iterable)this._parentFolderIds).filter(Objects::nonNull).transform(DocumentId::new).toSet();
    }
}

