/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.event.ProfileDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.kafka.model.KafkaProfile;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.persistence.ProfileRepository;
import de.justsoftware.chat.persistence.model.DbProfile;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.KafkaUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0017J\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\r0\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J!\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001cH\u0011\u00a2\u0006\u0002\b\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0011H\u0012J\u001a\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010 H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/chat/business/ProfileService;", "", "profileRepository", "Lde/justsoftware/chat/persistence/ProfileRepository;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "clock", "Ljava/time/Clock;", "<init>", "(Lde/justsoftware/chat/persistence/ProfileRepository;Lde/justsoftware/chat/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Ljava/time/Clock;)V", "save", "Lde/justsoftware/chat/business/model/Profile;", "profile", "findByIds", "", "Lde/justsoftware/chat/model/ProfileId;", "profileIds", "", "getById", "id", "updateImageUrl", "imageUrl", "", "onProfilesUpdate", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/chat/kafka/model/KafkaProfile;", "onProfilesUpdate$chat_service", "getCurrentStatus", "Lde/justsoftware/chat/model/ProfileStatus;", "profileId", "fireUpdateEventAfterCommit", "savedProfile", "oldStatus", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/chat/business/ProfileService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,130:1\n1#2:131\n1557#3:132\n1628#3,3:133\n1368#3:136\n1454#3,5:137\n1557#3:142\n1628#3,3:143\n1202#3,2:146\n1230#3,4:148\n1557#3:152\n1628#3,3:153\n1628#3,3:157\n1863#3,2:160\n7#4:156\n9#5:162\n8#5,3:163\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/chat/business/ProfileService\n*L\n44#1:132\n44#1:133,3\n46#1:136\n46#1:137,5\n47#1:142\n47#1:143,3\n48#1:146,2\n48#1:148,4\n76#1:152\n76#1:153,3\n77#1:157,3\n78#1:160,2\n77#1:156\n127#1:162\n127#1:163,3\n*E\n"})
public class ProfileService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final Clock clock;
    @NotNull
    public static final String PERSONS_TOPIC = "just.persons";
    @NotNull
    private static final Logger LOG;

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.profileRepository = profileRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.clock = clock;
    }

    @Transactional
    @NotNull
    public Profile save(@NotNull Profile profile) {
        Profile profile2;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        ProfileStatus oldStatus = this.getCurrentStatus(profile.getId());
        Object object = this.profileRepository.save((Object)DbProfile.Companion.toDbProfile(profile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        Profile savedProfile = profile2 = DbProfile.Companion.toProfile((DbProfile)object);
        boolean bl = false;
        this.fireUpdateEventAfterCommit(savedProfile, oldStatus);
        return profile2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findByIds(@NotNull Set<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.toCanonicalId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        ProfileRepository $i$f$map22 = this.profileRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllById(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        Iterable $i$f$flatMap22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (DbProfile)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            object.add(DbProfile.Companion.toProfile((DbProfile)it));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv22;
    }

    @NotNull
    public Profile getById(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Profile profile = this.profileRepository.findById((Object)id.toCanonicalId()).map(arg_0 -> ProfileService.getById$lambda$5(ProfileService::getById$lambda$4, arg_0)).orElseThrow(() -> ProfileService.getById$lambda$6(id));
        Intrinsics.checkNotNullExpressionValue((Object)profile, (String)"orElseThrow(...)");
        return profile;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Profile updateImageUrl(@NotNull ProfileId id, @NotNull String imageUrl) {
        Profile profile;
        void dbProfile;
        DbProfile $this$updateImageUrl_u24lambda_u248;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Object t = this.profileRepository.findById((Object)id.toCanonicalId()).orElseThrow(() -> ProfileService.updateImageUrl$lambda$7(id));
        DbProfile dbProfile2 = (DbProfile)t;
        DbProfile.Companion companion = DbProfile.Companion;
        boolean bl = false;
        $this$updateImageUrl_u24lambda_u248.setImageUrl(imageUrl);
        $this$updateImageUrl_u24lambda_u248 = (DbProfile)t;
        boolean bl2 = false;
        DbProfile dbProfile3 = (DbProfile)this.profileRepository.save((Object)dbProfile);
        Intrinsics.checkNotNullExpressionValue((Object)dbProfile3, (String)"let(...)");
        Profile savedProfile = profile = companion.toProfile(dbProfile3);
        boolean bl3 = false;
        this.fireUpdateEventAfterCommit(savedProfile, savedProfile.getStatus());
        return profile;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="profileConsumer", containerFactory="profileConsumerFactory", topics={"just.persons"}, idIsGroup=false)
    @Transactional
    public void onProfilesUpdate$chat_service(@NotNull ConsumerRecords<String, KafkaProfile> records) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$map$iv = KafkaUtilsKt.filterAndLogDeserializationErrors(records);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ConsumerRecord consumerRecord = (ConsumerRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((KafkaProfile)it.value());
        }
        List kafkaProfiles = (List)destination$iv$iv;
        Iterable $i$f$map22 = kafkaProfiles;
        collection = this;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KafkaProfile bl = (KafkaProfile)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(p0.getId());
        }
        Map currentProfiles = collection.findByIds((Set)destination$iv$iv2);
        Iterable $this$forEach$iv = kafkaProfiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KafkaProfile kafkaProfile = (KafkaProfile)element$iv;
            boolean bl = false;
            try {
                Profile currentProfile = (Profile)currentProfiles.get(kafkaProfile.getId());
                Intrinsics.checkNotNull((Object)kafkaProfile);
                Object object = currentProfile;
                if (object == null || (object = object.getCreatedAt()) == null) {
                    object = this.clock.instant();
                }
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                Object object3 = object2;
                Object object4 = currentProfile;
                if (object4 == null || (object4 = object4.getUpdatedAt()) == null) {
                    object4 = this.clock.instant();
                }
                object2 = object4;
                Intrinsics.checkNotNull((Object)object2);
                Profile newProfile = KafkaProfile.Companion.toProfile(kafkaProfile, (Instant)object3, (Instant)object2);
                if (Intrinsics.areEqual((Object)newProfile, (Object)currentProfile)) continue;
                this.save(newProfile);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to save or update profile with id = " + kafkaProfile.getId() + ". Skip this record.", (Throwable)e);
            }
        }
    }

    private ProfileStatus getCurrentStatus(ProfileId profileId) {
        return this.profileRepository.findById((Object)profileId.toCanonicalId()).map(arg_0 -> ProfileService.getCurrentStatus$lambda$15(ProfileService::getCurrentStatus$lambda$14, arg_0)).orElse(null);
    }

    private void fireUpdateEventAfterCommit(Profile savedProfile, ProfileStatus oldStatus) {
        this.transactionUtils.afterCommit(() -> ProfileService.fireUpdateEventAfterCommit$lambda$16(this, savedProfile, oldStatus));
    }

    private static final Profile getById$lambda$4(DbProfile it) {
        Intrinsics.checkNotNull((Object)it);
        return DbProfile.Companion.toProfile(it);
    }

    private static final Profile getById$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Profile)$tmp0.invoke(p0);
    }

    private static final NotFoundException getById$lambda$6(ProfileId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("User with id " + $id + " does not exist.");
    }

    private static final NotFoundException updateImageUrl$lambda$7(ProfileId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("User with id " + $id + " does not exist.");
    }

    private static final ProfileStatus getCurrentStatus$lambda$14(DbProfile dbProfile) {
        return ProfileStatus.Companion.profileStatusOf(dbProfile.getActive(), dbProfile.getBlocked(), dbProfile.getDeleted());
    }

    private static final ProfileStatus getCurrentStatus$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileStatus)$tmp0.invoke(p0);
    }

    private static final Unit fireUpdateEventAfterCommit$lambda$16(ProfileService this$0, Profile $savedProfile, ProfileStatus $oldStatus) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$savedProfile, (String)"$savedProfile");
        this$0.applicationEventPublisher.publishEvent(WhenMappings.$EnumSwitchMapping$0[$savedProfile.getStatus().ordinal()] == 1 ? (ApplicationEvent)new ProfileDeletedEvent((Object)this$0, $savedProfile.getId()) : (ApplicationEvent)new ProfileUpdatedEvent((Object)this$0, $savedProfile.getId(), $oldStatus, $savedProfile.getStatus()));
        return Unit.INSTANCE;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

