/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.model.drive.DriveAttachment;
import de.justsoftware.chat.business.model.drive.DriveTempFile;
import de.justsoftware.chat.exception.PersistFilesException;
import de.justsoftware.chat.model.DriveDocumentId;
import de.justsoftware.chat.model.ImageSize;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.RestOperationsUtilsKt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 .2\u00020\u0001:\u0001.B9\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJK\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0013\u0012\u0004\u0012\u0002H\u00110\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00132\u0006\u0010 \u001a\u00020\u0017H\u0016J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001fH\u0016J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u001fH\u0016J$\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J&\u0010,\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u00132\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006/"}, d2={"Lde/justsoftware/chat/business/DriveService;", "", "driveApiUrl", "", "driveInternalApiUrl", "apiGatewayRestOperations", "Lorg/springframework/web/client/RestOperations;", "internalApiRestOperations", "driveFileUploadRestOperations", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/springframework/web/client/RestOperations;Lorg/springframework/web/client/RestOperations;Lorg/springframework/web/client/RestOperations;)V", "persistTemporaryFilesUrl", "getPersistTemporaryFilesUrl", "()Ljava/lang/String;", "uploadTemporaryFilesUrl", "getUploadTemporaryFilesUrl", "uploadFiles", "T", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "targetItemId", "creator", "Lde/justsoftware/chat/model/ProfileId;", "callback", "Lkotlin/Function1;", "Lde/justsoftware/chat/business/model/drive/DriveAttachment;", "(Ljava/util/List;Ljava/lang/String;Lde/justsoftware/chat/model/ProfileId;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deleteFiles", "", "ids", "Lde/justsoftware/chat/model/DriveDocumentId;", "deleter", "downloadFileUrl", "id", "downloadFileThumbnailUri", "Ljava/net/URI;", "size", "Lde/justsoftware/chat/model/ImageSize;", "downloadFilePreviewUrl", "getVideoStreamUrl", "getUnauthorizedVideoUrl", "uploadTempFiles", "Lde/justsoftware/chat/business/model/drive/DriveTempFile;", "persistFiles", "filesToPersist", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nDriveService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveService.kt\nde/justsoftware/chat/business/DriveService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RestOperationsUtils.kt\nde/justsoftware/chat/util/RestOperationsUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 RestOperationsExtensions.kt\norg/springframework/web/client/RestOperationsExtensionsKt\n+ 6 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n*L\n1#1,130:1\n1557#2:131\n1628#2,3:132\n1557#2:135\n1628#2,3:136\n1863#2,2:139\n1628#2,3:145\n17#3:141\n23#3:148\n1#4:142\n162#5:143\n7#6:144\n*S KotlinDebug\n*F\n+ 1 DriveService.kt\nde/justsoftware/chat/business/DriveService\n*L\n46#1:131\n46#1:132,3\n55#1:135\n55#1:136,3\n56#1:139,2\n96#1:145,3\n74#1:141\n98#1:148\n84#1:143\n96#1:144\n*E\n"})
public class DriveService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String driveApiUrl;
    @NotNull
    private final String driveInternalApiUrl;
    @NotNull
    private final RestOperations apiGatewayRestOperations;
    @NotNull
    private final RestOperations internalApiRestOperations;
    @NotNull
    private final RestOperations driveFileUploadRestOperations;
    @NotNull
    private final String persistTemporaryFilesUrl;
    @NotNull
    private final String uploadTemporaryFilesUrl;

    public DriveService(@Value(value="${just.drive.api.url}") @NotNull String driveApiUrl, @Value(value="${just.drive.internal}") @NotNull String driveInternalApiUrl, @Qualifier(value="apiGatewayRestOperations") @NotNull RestOperations apiGatewayRestOperations, @Qualifier(value="internalApiRestOperations") @NotNull RestOperations internalApiRestOperations, @Qualifier(value="driveFileUploadRestOperations") @NotNull RestOperations driveFileUploadRestOperations) {
        Intrinsics.checkNotNullParameter((Object)driveApiUrl, (String)"driveApiUrl");
        Intrinsics.checkNotNullParameter((Object)driveInternalApiUrl, (String)"driveInternalApiUrl");
        Intrinsics.checkNotNullParameter((Object)apiGatewayRestOperations, (String)"apiGatewayRestOperations");
        Intrinsics.checkNotNullParameter((Object)internalApiRestOperations, (String)"internalApiRestOperations");
        Intrinsics.checkNotNullParameter((Object)driveFileUploadRestOperations, (String)"driveFileUploadRestOperations");
        this.driveApiUrl = driveApiUrl;
        this.driveInternalApiUrl = driveInternalApiUrl;
        this.apiGatewayRestOperations = apiGatewayRestOperations;
        this.internalApiRestOperations = internalApiRestOperations;
        this.driveFileUploadRestOperations = driveFileUploadRestOperations;
        this.persistTemporaryFilesUrl = this.driveInternalApiUrl + "/tmp/move";
        this.uploadTemporaryFilesUrl = this.driveInternalApiUrl + "/tmp/upload";
    }

    @NotNull
    public String getPersistTemporaryFilesUrl() {
        return this.persistTemporaryFilesUrl;
    }

    @NotNull
    public String getUploadTemporaryFilesUrl() {
        return this.uploadTemporaryFilesUrl;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T uploadFiles(@NotNull List<? extends MultipartFile> files, @NotNull String targetItemId, @NotNull ProfileId creator, @NotNull Function1<? super List<DriveAttachment>, ? extends T> callback) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)targetItemId, (String)"targetItemId");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        List tempFiles = this.uploadTempFiles(files, creator);
        Object object = CollectionsKt.zip((Iterable)tempFiles, (Iterable)files);
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DriveTempFile tempFile = (DriveTempFile)pair.component1();
            MultipartFile file = (MultipartFile)pair.component2();
            collection.add(Companion.access$toDriveAttachment((Companion)Companion, (DriveTempFile)tempFile, (MultipartFile)file));
        }
        object = (List)destination$iv$iv;
        Object it = object = callback.invoke(object);
        boolean bl = false;
        this.persistFiles(tempFiles, targetItemId, creator);
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteFiles(@NotNull List<DriveDocumentId> ids, @NotNull ProfileId deleter) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)deleter, (String)"deleter");
        Iterable $this$map$iv = ids;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            DriveDocumentId driveDocumentId = (DriveDocumentId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.driveInternalApiUrl + "/file/" + file.getValue() + "/delete?deletingUser=" + deleter.getValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        RestOperations restOperations = this.internalApiRestOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            restOperations.delete(p0, new Object[0]);
        }
    }

    @NotNull
    public String downloadFileUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.driveApiUrl + "/documents/" + id.getValue() + "/download";
    }

    @NotNull
    public URI downloadFileThumbnailUri(@NotNull DriveDocumentId id, @NotNull ImageSize size) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return RestOperationsUtilsKt.buildUri((String)(this.driveApiUrl + "/previews/thumbnail/" + id.getValue()), arg_0 -> DriveService.downloadFileThumbnailUri$lambda$3(size, arg_0));
    }

    @NotNull
    public String downloadFilePreviewUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.driveApiUrl + "/previews/previewImage/" + id.getValue() + "/latest";
    }

    @NotNull
    public String getVideoStreamUrl(@NotNull DriveDocumentId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.driveApiUrl + "/previews/embed/" + id.getValue() + "/latest";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getUnauthorizedVideoUrl(@NotNull DriveDocumentId id) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = this.apiGatewayRestOperations;
        String url$iv = this.driveApiUrl + "/previews/preview/" + id.getValue() + "/accessToken";
        boolean $i$f$get = false;
        ResponseEntity responseEntity = $this$get$iv.getForEntity(url$iv, String.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"getForEntity(...)");
        object = new char[1];
        object[0] = (RestOperations)34;
        String accessToken = StringsKt.trim((String)((String)RestOperationsUtilsKt.bodyOrNotFound((ResponseEntity)responseEntity)), (char[])object);
        boolean bl = false;
        return "/drive/api/unauthenticated/previewVideoFile/" + accessToken;
    }

    /*
     * WARNING - void declaration
     */
    private List<DriveTempFile> uploadTempFiles(List<? extends MultipartFile> files, ProfileId creator) {
        void uriVariables$iv;
        void url$iv;
        void $this$postForObject$iv;
        MultiValueMap postData = RestOperationsUtilsKt.createMultipartPayload((String)"files", files);
        postData.add((Object)"ownerId", (Object)creator.getValue());
        RestOperations restOperations = this.driveFileUploadRestOperations;
        String string = this.getUploadTemporaryFilesUrl();
        Object[] objectArray = new Object[]{};
        boolean $i$f$postForObject = false;
        Object object = $this$postForObject$iv.postForObject((String)url$iv, (Object)postData, DriveTempFile[].class, (Object[])Arrays.copyOf(uriVariables$iv, ((void)uriVariables$iv).length));
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<de.justsoftware.chat.business.model.drive.DriveTempFile>");
        }
        Object[] driveTempFiles = (DriveTempFile[])object;
        return ArraysKt.toList((Object[])driveTempFiles);
    }

    /*
     * WARNING - void declaration
     */
    private void persistFiles(List<DriveTempFile> filesToPersist, String targetItemId, ProfileId creator) {
        ResponseEntity responseEntity;
        void data$iv;
        void url$iv;
        void $this$post$iv;
        Object $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = filesToPersist;
        boolean $i$f$mapToSet232 = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void p0;
            DriveTempFile driveTempFile = (DriveTempFile)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set idsToPersists = (Set)destination$iv$iv;
        $this$mapToSet$iv = this.internalApiRestOperations;
        String $i$f$mapToSet232 = this.getPersistTemporaryFilesUrl();
        $this$mapTo$iv$iv = new Pair[]{TuplesKt.to((Object)"targetItemId", (Object)targetItemId), TuplesKt.to((Object)"tempFileIds", (Object)idsToPersists), TuplesKt.to((Object)"ownerId", (Object)creator.getValue())};
        $this$mapTo$iv$iv = MapsKt.mapOf((Pair[])$this$mapTo$iv$iv);
        boolean $i$f$post = false;
        ResponseEntity responseEntity2 = $this$post$iv.postForEntity((String)url$iv, (Object)data$iv, String.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity2, (String)"postForEntity(...)");
        ResponseEntity response = responseEntity = responseEntity2;
        boolean bl = false;
        if (response.getStatusCode() != HttpStatus.OK) {
            HttpStatusCode httpStatusCode = response.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
            throw new PersistFilesException(idsToPersists, httpStatusCode);
        }
    }

    private static final Unit downloadFileThumbnailUri$lambda$3(ImageSize $size, UriComponentsBuilder $this$buildUri) {
        Intrinsics.checkNotNullParameter((Object)$size, (String)"$size");
        Intrinsics.checkNotNullParameter((Object)$this$buildUri, (String)"$this$buildUri");
        Object[] objectArray = new Object[]{$size.getWidth()};
        $this$buildUri.queryParam("width", objectArray);
        objectArray = new Object[]{$size.getHeight()};
        $this$buildUri.queryParam("height", objectArray);
        return Unit.INSTANCE;
    }
}

