/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.CommonCoreSearchService;
import de.justsoftware.chat.model.CommonCoreSearchFields;
import de.justsoftware.chat.model.CommonCoreSearchModelType;
import de.justsoftware.chat.model.CommonCoreSearchResult;
import de.justsoftware.chat.model.CommonCoreSearchSortType;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 (2\u00020\u0001:\u0001(B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JI\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J8\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0016Jd\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0019\b\u0002\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!H\u0012\u00a2\u0006\u0002\u0010\"J^\u0010#\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0019\b\u0002\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!H\u0012\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/justsoftware/chat/business/CommonCoreSearchService;", "", "commonCoreFollowerSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/authorization/AuthorizationService;)V", "suggestChat", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/model/CommonCoreSearchResult;", "query", "", "types", "", "Lde/justsoftware/chat/model/CommonCoreSearchModelType;", "sortBy", "Lde/justsoftware/chat/model/CommonCoreSearchSortType;", "searchBy", "Lde/justsoftware/chat/model/ProfileId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "offset", "Lde/justsoftware/chat/model/Offset;", "(Ljava/lang/String;[Lde/justsoftware/chat/model/CommonCoreSearchModelType;Lde/justsoftware/chat/model/CommonCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lde/justsoftware/chat/model/TenantId;Lde/justsoftware/chat/model/Offset;)Lorg/springframework/data/domain/Page;", "suggestUser", "sendSolrQuery", "pageable", "Lorg/springframework/data/domain/Pageable;", "configure", "Lkotlin/Function1;", "Lorg/apache/solr/client/solrj/SolrQuery;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;[Lde/justsoftware/chat/model/CommonCoreSearchModelType;Lde/justsoftware/chat/model/CommonCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lde/justsoftware/chat/model/TenantId;Lorg/springframework/data/domain/Pageable;Lkotlin/jvm/functions/Function1;)Lorg/springframework/data/domain/Page;", "buildSolrQuery", "(Ljava/lang/String;[Lde/justsoftware/chat/model/CommonCoreSearchModelType;Lde/justsoftware/chat/model/CommonCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lde/justsoftware/chat/model/TenantId;Lorg/springframework/data/domain/Pageable;Lkotlin/jvm/functions/Function1;)Lorg/apache/solr/client/solrj/SolrQuery;", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nCommonCoreSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonCoreSearchService.kt\nde/justsoftware/chat/business/CommonCoreSearchService\n+ 2 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n9#2:166\n8#2,3:167\n1#3:170\n*S KotlinDebug\n*F\n+ 1 CommonCoreSearchService.kt\nde/justsoftware/chat/business/CommonCoreSearchService\n*L\n135#1:166\n135#1:167,3\n*E\n"})
public class CommonCoreSearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient commonCoreFollowerSolrClient;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String QUERY_PERSON_IDS_PARAM_NAME = "jucoPersonIds";
    @NotNull
    private static final String QUERY_ROLES_PARAM_NAME = "jucoRoles";
    @NotNull
    private static final String ROLE_VISIBILITY_FILTER_QUERY = "_query_:\"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$jucoRoles}\"";
    @NotNull
    private static final String PERSON_VISIBILITY_FILTER_QUERY = "_query_:\"{!edismax q.op=OR qf=visible_for_persons mm=1 v=$jucoPersonIds}\"";
    @NotNull
    private static final String VISIBILITY_FILTER_QUERY = "(_query_:\"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$jucoRoles}\" OR _query_:\"{!edismax q.op=OR qf=visible_for_persons mm=1 v=$jucoPersonIds}\")";
    @NotNull
    private static final String REQUESTED_FIELDS;

    public CommonCoreSearchService(@Qualifier(value="commonCoreFollowerSolrClient") @NotNull SolrClient commonCoreFollowerSolrClient, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)commonCoreFollowerSolrClient, (String)"commonCoreFollowerSolrClient");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.commonCoreFollowerSolrClient = commonCoreFollowerSolrClient;
        this.authorizationService = authorizationService;
    }

    @NotNull
    public Page<CommonCoreSearchResult> suggestChat(@NotNull String query, @NotNull CommonCoreSearchModelType[] types, @NotNull CommonCoreSearchSortType sortBy, @NotNull ProfileId searchBy, @NotNull TenantId tenantId, @NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return types.length == 0 ? (Page)new PageImpl(CollectionsKt.emptyList(), CommonCoreSearchSortType.Companion.toPageable(offset, sortBy), 0L) : this.sendSolrQuery(query, types, sortBy, searchBy, tenantId, CommonCoreSearchSortType.Companion.toPageable(offset, sortBy), arg_0 -> CommonCoreSearchService.suggestChat$lambda$0(searchBy, arg_0));
    }

    @NotNull
    public Page<CommonCoreSearchResult> suggestUser(@NotNull String query, @NotNull ProfileId searchBy, @NotNull TenantId tenantId, @NotNull Offset offset, @NotNull CommonCoreSearchSortType sortBy) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        CommonCoreSearchModelType[] commonCoreSearchModelTypeArray = new CommonCoreSearchModelType[]{CommonCoreSearchModelType.PERSON};
        return CommonCoreSearchService.sendSolrQuery$default((CommonCoreSearchService)this, (String)query, (CommonCoreSearchModelType[])commonCoreSearchModelTypeArray, (CommonCoreSearchSortType)sortBy, (ProfileId)searchBy, (TenantId)tenantId, (Pageable)CommonCoreSearchSortType.Companion.toPageable(offset, sortBy), null, (int)64, null);
    }

    public static /* synthetic */ Page suggestUser$default(CommonCoreSearchService commonCoreSearchService, String string, ProfileId profileId, TenantId tenantId, Offset offset, CommonCoreSearchSortType commonCoreSearchSortType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: suggestUser");
        }
        if ((n & 0x10) != 0) {
            commonCoreSearchSortType = CommonCoreSearchSortType.ALPHABETICAL;
        }
        return commonCoreSearchService.suggestUser(string, profileId, tenantId, offset, commonCoreSearchSortType);
    }

    private Page<CommonCoreSearchResult> sendSolrQuery(String query, CommonCoreSearchModelType[] types, CommonCoreSearchSortType sortBy, ProfileId searchBy, TenantId tenantId, Pageable pageable, Function1<? super SolrQuery, Unit> configure) {
        return Companion.access$toSearchResultsPage((Companion)Companion, (QueryResponse)this.send(this.buildSolrQuery(query, types, sortBy, searchBy, tenantId, pageable, configure)), (Pageable)pageable);
    }

    static /* synthetic */ Page sendSolrQuery$default(CommonCoreSearchService commonCoreSearchService, String string, CommonCoreSearchModelType[] commonCoreSearchModelTypeArray, CommonCoreSearchSortType commonCoreSearchSortType, ProfileId profileId, TenantId tenantId, Pageable pageable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendSolrQuery");
        }
        if ((n & 0x40) != 0) {
            function1 = CommonCoreSearchService::sendSolrQuery$lambda$1;
        }
        return commonCoreSearchService.sendSolrQuery(string, commonCoreSearchModelTypeArray, commonCoreSearchSortType, profileId, tenantId, pageable, function1);
    }

    private SolrQuery buildSolrQuery(String query, CommonCoreSearchModelType[] types, CommonCoreSearchSortType sortBy, ProfileId searchBy, TenantId tenantId, Pageable pageable, Function1<? super SolrQuery, Unit> configure) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u244 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)query)) {
            $this$buildSolrQuery_u24lambda_u244.setQuery(Companion.access$toEscapedQuery((Companion)Companion, (String)query));
        }
        $this$buildSolrQuery_u24lambda_u244.setHighlight(true);
        String[] stringArray = new String[]{sortBy.getSolrSortValue()};
        $this$buildSolrQuery_u24lambda_u244.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(pageable.getOffset())};
        $this$buildSolrQuery_u24lambda_u244.set("start", stringArray);
        stringArray = new String[]{String.valueOf(pageable.getPageSize())};
        $this$buildSolrQuery_u24lambda_u244.set("rows", stringArray);
        stringArray = new String[]{REQUESTED_FIELDS};
        $this$buildSolrQuery_u24lambda_u244.set("fl", stringArray);
        stringArray = new String[]{ArraysKt.joinToString$default((Object[])types, (CharSequence)" OR ", null, null, (int)0, null, CommonCoreSearchService::buildSolrQuery$lambda$4$lambda$3, (int)30, null)};
        $this$buildSolrQuery_u24lambda_u244.addFilterQuery(stringArray);
        String searchRoles = CollectionsKt.joinToString$default((Iterable)this.authorizationService.searchRolesBy(searchBy), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{"(_query_:\"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$jucoRoles}\" OR _query_:\"{!edismax q.op=OR qf=visible_for_persons mm=1 v=$jucoPersonIds}\")"};
        $this$buildSolrQuery_u24lambda_u244.addFilterQuery(stringArray2);
        stringArray2 = new String[]{"tenant_id:" + tenantId.toCanonicalId()};
        $this$buildSolrQuery_u24lambda_u244.addFilterQuery(stringArray2);
        stringArray2 = new String[]{searchRoles};
        $this$buildSolrQuery_u24lambda_u244.add("jucoRoles", stringArray2);
        stringArray2 = new String[]{String.valueOf(searchBy.getValue())};
        $this$buildSolrQuery_u24lambda_u244.add("jucoPersonIds", stringArray2);
        $this$buildSolrQuery_u24lambda_u244.setRequestHandler("suggest");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u244);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(CommonCoreSearchService commonCoreSearchService, String string, CommonCoreSearchModelType[] commonCoreSearchModelTypeArray, CommonCoreSearchSortType commonCoreSearchSortType, ProfileId profileId, TenantId tenantId, Pageable pageable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n & 0x40) != 0) {
            function1 = CommonCoreSearchService::buildSolrQuery$lambda$2;
        }
        return commonCoreSearchService.buildSolrQuery(string, commonCoreSearchModelTypeArray, commonCoreSearchSortType, profileId, tenantId, pageable, function1);
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            queryResponse = this.commonCoreFollowerSolrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    private static final Unit suggestChat$lambda$0(ProfileId $searchBy, SolrQuery $this$sendSolrQuery) {
        Intrinsics.checkNotNullParameter((Object)$searchBy, (String)"$searchBy");
        Intrinsics.checkNotNullParameter((Object)$this$sendSolrQuery, (String)"$this$sendSolrQuery");
        String[] stringArray = new String[]{"!id:" + $searchBy};
        $this$sendSolrQuery.addFilterQuery(stringArray);
        stringArray = new String[]{"!chat_type:ONE_ON_ONE"};
        $this$sendSolrQuery.addFilterQuery(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit sendSolrQuery$lambda$1(SolrQuery solrQuery) {
        Intrinsics.checkNotNullParameter((Object)solrQuery, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Unit buildSolrQuery$lambda$2(SolrQuery solrQuery) {
        Intrinsics.checkNotNullParameter((Object)solrQuery, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final CharSequence buildSolrQuery$lambda$4$lambda$3(CommonCoreSearchModelType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "type:" + it;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        CommonCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u245 = CommonCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, name, type, chat_type, modify_date";
    }
}

