/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationToken;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.web.authentication.AuthenticationConverter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lde/justsoftware/authorization/oauth2/MobileClientRefreshTokenAuthenticationConverter;", "Lorg/springframework/security/web/authentication/AuthenticationConverter;", "()V", "convert", "Lorg/springframework/security/core/Authentication;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "just-authorization-server"})
public final class MobileClientRefreshTokenAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(@NotNull HttpServletRequest request) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String grantType = request.getParameter("grant_type");
        String clientId = request.getParameter("client_id");
        if (!Intrinsics.areEqual((Object)AuthorizationGrantType.REFRESH_TOKEN.getValue(), (Object)grantType) || (charSequence = (CharSequence)clientId) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Intrinsics.checkNotNull((Object)clientId);
        return (Authentication)new MobileClientRefreshTokenAuthenticationToken(clientId);
    }
}

