/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustAuthenticationProvider$retrieveUser$;
import de.justsoftware.authorization.oauth2.JustToroUser;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.LoginDto;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "Lorg/springframework/security/authentication/dao/AbstractUserDetailsAuthenticationProvider;", "toroInternalUrl", "", "(Ljava/lang/String;)V", "restClient", "Lorg/springframework/web/client/RestClient;", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "getToroInternalUrl", "()Ljava/lang/String;", "additionalAuthenticationChecks", "", "userDetails", "Lorg/springframework/security/core/userdetails/UserDetails;", "authentication", "Lorg/springframework/security/authentication/UsernamePasswordAuthenticationToken;", "retrieveUser", "username", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nJustAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n+ 2 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,57:1\n43#2:58\n*S KotlinDebug\n*F\n+ 1 JustAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/JustAuthenticationProvider\n*L\n40#1:58\n*E\n"})
public class JustAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestClient restClient;

    public JustAuthenticationProvider(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        this.toroInternalUrl = toroInternalUrl;
        RestClient restClient = RestClient.create();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"create(...)");
        this.restClient = restClient;
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    protected void additionalAuthenticationChecks(@Nullable UserDetails userDetails, @Nullable UsernamePasswordAuthenticationToken authentication) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected UserDetails retrieveUser(@NotNull String username, @NotNull UsernamePasswordAuthenticationToken authentication) {
        void $this$body$iv;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        String password = authentication.getCredentials().toString();
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.getRestClient().post().uri(this.getToroInternalUrl() + "/auth/login/", new Object[0])).accept(mediaTypeArray)).body((Object)new LoginDto(username, password)).retrieve().onStatus(JustAuthenticationProvider::retrieveUser$lambda$0, (arg_0, arg_1) -> JustAuthenticationProvider.retrieveUser$lambda$1(username, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
        Object object = responseSpec;
        boolean $i$f$body = false;
        JustToroUser justToroUser = (JustToroUser)$this$body$iv.body((ParameterizedTypeReference)new retrieveUser$$inlined$body$1());
        if (justToroUser == null) {
            throw new UsernameNotFoundException("null returned from toro when trying to load user " + username + ".");
        }
        JustToroUser toroUser = justToroUser;
        String string = toroUser.getUsername();
        object = toroUser.getAuthorities();
        ProfileId profileId = toroUser.getProfileId();
        TenantId tenantId = toroUser.getTenantId();
        boolean bl = toroUser.isAccountNonExpired();
        boolean bl2 = toroUser.isAccountNonLocked();
        boolean bl3 = toroUser.isCredentialsNonExpired();
        boolean bl4 = toroUser.isEnabled();
        return (UserDetails)new JustUser(profileId, tenantId, string, null, (List)object, bl, bl2, bl3, bl4);
    }

    private static final boolean retrieveUser$lambda$0(HttpStatusCode it) {
        return it != HttpStatus.OK;
    }

    private static final void retrieveUser$lambda$1(String $username, HttpRequest httpRequest, ClientHttpResponse clientHttpResponse) {
        Intrinsics.checkNotNullParameter((Object)$username, (String)"$username");
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)clientHttpResponse, (String)"<anonymous parameter 1>");
        throw new UsernameNotFoundException("User " + $username + " not found. take a look in just-toro log for error. (bad credentials, user locked, user not forund, etc.)");
    }
}

